/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.Registries;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.spells.SpellValidityResult;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.blocks.BlockInit;
import com.mna.blocks.sorcery.InscriptionTableBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.gui.containers.block.ContainerInscriptionTable;
import com.mna.items.ItemInit;
import com.mna.network.ClientMessageDispatcher;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.to_server.InscriptionTableAttributeChangeMessage;
import com.mna.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import com.mna.network.messages.to_server.InscriptionTableRequestStartCraftingMessage;
import com.mna.network.messages.to_server.InscriptionTableSetComponentMessage;
import com.mna.network.messages.to_server.InscriptionTableSetModifierMessage;
import com.mna.network.messages.to_server.InscriptionTableSetShapeMessage;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class InscriptionTableTile
extends TileEntityWithInventory
implements MenuProvider,
Consumer<FriendlyByteBuf>,
GeoBlockEntity {
    private static final int SIZE_INVENTORY = 4;
    private static final int SLOT_INK = 0;
    private static final int SLOT_PAPER = 1;
    private static final int SLOT_FUEL = 2;
    private static final int SLOT_OUTPUT = 3;
    private static final int TICKS_PER_FUEL = 160;
    private static final int SCRIBE_TICKS_PER_COMPLEXITY = 20;
    private SpellRecipe recipe;
    private boolean isCrafting = false;
    private int craftTicksTotal = 0;
    private int craftTicksConsumed = 0;
    private int burnTicksRemaining = 0;
    private int inkDamageRemaining = 0;
    private int paperRemaining = 0;
    private int fuelRemaining = 0;
    private boolean creative;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public InscriptionTableTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, 4);
        this.recipe = new SpellRecipe();
    }

    public static void ServerTick(Level level, BlockPos pos, BlockState state, InscriptionTableTile tile) {
        if (tile.isCrafting) {
            if (!tile.creative) {
                if (tile.paperRemaining > 0 || tile.inkDamageRemaining > 0) {
                    tile.consumeMaterials();
                    return;
                }
                if (tile.burnTicksRemaining <= 5) {
                    if (!level.m_5776_()) {
                        tile.tryConsumeFuel();
                    }
                    return;
                }
            }
            ++tile.craftTicksConsumed;
            --tile.burnTicksRemaining;
            if (!level.m_5776_()) {
                if (tile.craftTicksConsumed >= tile.craftTicksTotal) {
                    tile.completeSpellPart();
                } else if (tile.craftTicksConsumed > 0 && tile.craftTicksConsumed % 20 == 0) {
                    ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(tile);
                }
            }
        }
    }

    public void setCreative(boolean creative) {
        this.creative = creative;
    }

    public boolean isCraftingPaused() {
        return this.isCrafting && (this.paperRemaining > 0 || this.inkDamageRemaining > 0);
    }

    private void completeSpellPart() {
        this.isCrafting = false;
        this.burnTicksRemaining = 0;
        this.craftTicksConsumed = 0;
        this.craftTicksTotal = 0;
        ItemStack outputStack = this.creative ? new ItemStack((ItemLike)ItemInit.SPELL.get()) : new ItemStack((ItemLike)ItemInit.ENCHANTED_VELLUM.get());
        this.recipe.setMysterious(false);
        this.recipe.writeToNBT(outputStack.m_41784_());
        this.recipe.writeRecipeForRitual(this.f_58857_, outputStack.m_41784_());
        this.m_6836_(3, outputStack);
        ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
    }

    private void tryConsumeFuel() {
        ItemStack consumeStack = this.m_7407_(2, 1);
        if (!consumeStack.m_41619_()) {
            this.burnTicksRemaining = 160;
            ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
        }
    }

    public SpellValidityResult canBeginCrafting(IPlayerProgression progression) {
        if (this.isCrafting) {
            return SpellValidityResult.ALREADY_CRAFTING;
        }
        if (!this.m_8020_(3).m_41619_()) {
            return SpellValidityResult.OUTPUT_FULL;
        }
        if (this.getCurrentShape() == null) {
            return SpellValidityResult.NO_SHAPE;
        }
        if (this.getCurrentComponent() == null) {
            return SpellValidityResult.NO_COMPONENT;
        }
        if (!(!this.getCurrentShape().getPart().isChanneled() && this.getCurrentShape().getPart().allowChanneledComponents() || this.getCurrentComponent().getPart().canBeChanneled())) {
            return SpellValidityResult.CANNOT_CHANNEL;
        }
        if (this.creative) {
            return SpellValidityResult.READY;
        }
        if (progression.getTier() < this.getCurrentRecipe().getTier(this.f_58857_)) {
            return SpellValidityResult.LOW_TIER;
        }
        if (this.getCurrentRecipe().getComplexity() > (float)progression.getTierMaxComplexity()) {
            return SpellValidityResult.TOO_COMPLEX;
        }
        if (!this.getCurrentRecipe().canFactionCraft(progression)) {
            return SpellValidityResult.WRONG_FACTION;
        }
        this.calculateMaterialRequirements();
        if (this.m_8020_(1).m_41613_() < this.paperRemaining) {
            return SpellValidityResult.MISSING_PAPER;
        }
        if (this.m_8020_(0).m_41776_() - this.m_8020_(0).m_41773_() < this.inkDamageRemaining) {
            return SpellValidityResult.MISSING_INK;
        }
        if (this.m_8020_(2).m_41613_() == 0) {
            return SpellValidityResult.MISSING_ASH;
        }
        return SpellValidityResult.READY;
    }

    private void consumeMaterials() {
        int availableInk;
        ItemStack ink;
        boolean updated = false;
        ItemStack paperconsumed = this.m_7407_(1, this.paperRemaining);
        if (!paperconsumed.m_41619_()) {
            this.paperRemaining -= paperconsumed.m_41613_();
            updated = true;
        }
        if (!(ink = this.m_8020_(0)).m_41619_() && (availableInk = this.m_8020_(0).m_41776_() - this.m_8020_(0).m_41773_()) > 0) {
            if (availableInk > this.inkDamageRemaining) {
                this.m_8020_(0).m_41721_(this.m_8020_(0).m_41773_() + this.inkDamageRemaining);
                this.inkDamageRemaining = 0;
            } else {
                this.inkDamageRemaining -= availableInk;
                this.m_8020_(0).m_41721_(this.m_8020_(0).m_41776_());
            }
            updated = true;
        }
        if (updated) {
            ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
        }
    }

    private void calculateMaterialRequirements() {
        this.paperRemaining = (int)Math.ceil(this.getComplexity() / 5.0f);
        this.inkDamageRemaining = (int)Math.ceil(this.getComplexity() / 2.5f);
        this.fuelRemaining = (int)Math.ceil((float)((int)this.getComplexity() * 20) / 160.0f);
    }

    public InscriptionTableTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.INSCRIPTION_TABLE.get(), pos, state);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerInscriptionTable(id, playerInventory, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"mna:container.inscription_table");
    }

    public void setCurrentShape(Shape shape) {
        if (this.isCrafting) {
            return;
        }
        this.recipe.setShape(shape);
        if (this.m_58898_()) {
            if (!this.f_58857_.m_5776_()) {
                this.m_6596_();
            } else {
                ClientMessageDispatcher.sendInscriptionTableSetShape(this);
            }
        }
        this.calculateMaterialRequirements();
    }

    public void setCurrentComponent(SpellEffect component) {
        if (this.isCrafting) {
            return;
        }
        this.recipe.clearComponents();
        if (component != null) {
            this.recipe.addComponent(component);
        }
        if (this.m_58898_()) {
            if (!this.f_58857_.m_5776_()) {
                this.m_6596_();
            } else {
                ClientMessageDispatcher.sendInscriptionTableSetComponent(this);
            }
        }
        this.calculateMaterialRequirements();
    }

    public void setCurrentModifier(Modifier modifier, int index) {
        if (this.isCrafting) {
            return;
        }
        this.recipe.setModifier(modifier, index);
        if (this.m_58898_()) {
            if (this.f_58857_.m_5776_()) {
                ClientMessageDispatcher.sendInscriptionTableSetModifier(this, modifier != null ? modifier.getRegistryName() : new ResourceLocation(""), index);
            } else {
                this.m_6596_();
            }
        }
        this.calculateMaterialRequirements();
    }

    public SpellRecipe getCurrentRecipe() {
        return this.recipe;
    }

    public ModifiedSpellPart<Shape> getCurrentShape() {
        return this.recipe.getShape();
    }

    public ModifiedSpellPart<SpellEffect> getCurrentComponent() {
        return this.recipe.getComponent(0);
    }

    public Modifier getCurrentModifier(int index) {
        return this.recipe.getModifier(index);
    }

    public void build() {
        if (this.recipe.isValid() && this.m_8020_(3).m_41619_()) {
            if (this.f_58857_.m_5776_()) {
                ClientMessageDispatcher.sendInscriptionTableRequestStartCrafting(this);
            } else {
                this.isCrafting = true;
                this.craftTicksTotal = this.creative ? 5 : (int)this.getComplexity() * 20;
                this.craftTicksConsumed = 0;
                if (this.m_58898_() && !this.f_58857_.m_5776_()) {
                    this.calculateMaterialRequirements();
                    ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
                    this.m_6596_();
                    this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                }
            }
        }
    }

    public boolean isBuilding() {
        return this.isCrafting;
    }

    public void changeShapeAttributeValue(Attribute attribute, float newValue) {
        if (this.recipe.changeShapeAttributeValue(attribute, newValue) && this.m_58898_()) {
            if (this.f_58857_.m_5776_()) {
                ClientMessageDispatcher.sendInscriptionTableAttributeChange(this, attribute, newValue, InscriptionTableAttributeChangeMessage.ChangeType.SHAPE);
            } else {
                this.m_6596_();
            }
        }
        this.calculateMaterialRequirements();
    }

    public void changeComponentAttributeValue(Attribute attribute, float newValue) {
        if (this.recipe.changeComponentAttributeValue(0, attribute, newValue) && this.m_58898_()) {
            if (this.f_58857_.m_5776_()) {
                ClientMessageDispatcher.sendInscriptionTableAttributeChange(this, attribute, newValue, InscriptionTableAttributeChangeMessage.ChangeType.COMPONENT);
            } else {
                this.m_6596_();
            }
        }
        this.calculateMaterialRequirements();
    }

    public float getComplexity() {
        return this.recipe.getComplexity();
    }

    public float getManaCost(Player player) {
        this.recipe.calculateManaCost();
        SpellCaster.applyAdjusters(ItemStack.f_41583_, (LivingEntity)player, InteractionHand.MAIN_HAND, false, this.recipe, SpellCastStage.SPELLCRAFTING_MANA_COST_ESTIMATE);
        return this.recipe.isChanneled() ? this.recipe.getManaCost() * 20.0f : this.recipe.getManaCost();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        CompoundTag recipeData = new CompoundTag();
        this.recipe.writeToNBT(recipeData);
        compound.m_128365_("recipe_data", (Tag)recipeData);
        compound.m_128379_("isCrafting", this.isCrafting);
        compound.m_128405_("craftTicksTotal", this.craftTicksTotal);
        compound.m_128405_("craftTicksConsumed", this.craftTicksConsumed);
        compound.m_128405_("burnTicksRemaining", this.burnTicksRemaining);
        compound.m_128405_("inkDamageRemaining", this.inkDamageRemaining);
        compound.m_128405_("paperRemaining", this.paperRemaining);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("recipe_data")) {
            this.recipe = SpellRecipe.fromNBT(compound.m_128469_("recipe_data"));
        }
        this.isCrafting = compound.m_128471_("isCrafting");
        this.craftTicksTotal = compound.m_128451_("craftTicksTotal");
        this.craftTicksConsumed = compound.m_128451_("craftTicksConsumed");
        this.burnTicksRemaining = compound.m_128451_("burnTicksRemaining");
        this.inkDamageRemaining = compound.m_128451_("inkDamageRemaining");
        this.paperRemaining = compound.m_128451_("paperRemaining");
        super.m_142466_(compound);
    }

    @Override
    public void accept(FriendlyByteBuf data) {
        data.m_130064_(this.m_58899_());
        CompoundTag nbt = new CompoundTag();
        this.recipe.writeToNBT(nbt);
        data.m_130079_(nbt);
        data.writeInt(this.craftTicksTotal);
        data.writeInt(this.craftTicksConsumed);
        data.writeInt(this.burnTicksRemaining);
        data.writeInt(this.inkDamageRemaining);
        data.writeInt(this.paperRemaining);
    }

    public InscriptionTableTile readFrom(FriendlyByteBuf data) {
        this.recipe = SpellRecipe.fromNBT(data.m_130260_());
        this.craftTicksTotal = data.readInt();
        this.craftTicksConsumed = data.readInt();
        this.burnTicksRemaining = data.readInt();
        this.inkDamageRemaining = data.readInt();
        this.paperRemaining = data.readInt();
        return this;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public int getCraftTicks() {
        return this.craftTicksTotal;
    }

    public int getCraftTicksConsumed() {
        return this.craftTicksConsumed;
    }

    public int getBurnTicksRemaining() {
        return this.burnTicksRemaining;
    }

    public int getPaperRemaining() {
        return this.paperRemaining;
    }

    public int getInkRemaining() {
        return this.inkDamageRemaining;
    }

    public int getFuelRemaining() {
        return this.fuelRemaining;
    }

    public void m_6596_() {
        super.m_6596_();
        int modelStateFlag = 0;
        if (!this.m_8020_(0).m_41619_()) {
            modelStateFlag |= 1;
        }
        if (!this.m_8020_(1).m_41619_()) {
            modelStateFlag |= 2;
        }
        if (!this.m_8020_(2).m_41619_()) {
            modelStateFlag |= 4;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)InscriptionTableBlock.CONTAINED_RESOURCES, (Comparable)Integer.valueOf(modelStateFlag)));
        }
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN || side == Direction.UP) {
            return new int[]{3};
        }
        return new int[]{0, 1, 2};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isCrafting && direction != Direction.UP && direction != Direction.DOWN;
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isCrafting) {
            return false;
        }
        ItemStack existing = this.m_8020_(index);
        switch (index) {
            case 0: {
                return stack.m_41720_() == ItemInit.ARCANIST_INK.get() && existing.m_41619_();
            }
            case 1: {
                return stack.m_41720_() == ItemInit.VELLUM.get() && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
            case 2: {
                return stack.m_41720_() == ItemInit.ARCANE_ASH.get() && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
        }
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (this.isBuilding() && !this.isCraftingPaused()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.inscription_table.quillwrite"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.inscription_table.quillidle"));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    private static InscriptionTableTile getAndVerify(Level world, BlockPos position) {
        BlockEntity te;
        if (world.m_46749_(position) && world.m_8055_(position).m_60734_() == BlockInit.INSCRIPTION_TABLE.get() && (te = world.m_7702_(position)) != null && te instanceof InscriptionTableTile) {
            return (InscriptionTableTile)te;
        }
        return null;
    }

    public static final void handleShapeSet(ServerPlayer sendingPlayer, InscriptionTableSetShapeMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.m_9236_(), message.getPosition());
        if (te == null) {
            return;
        }
        Shape spellShape = (Shape)Registries.Shape.get().getValue(message.getShape());
        te.setCurrentShape(spellShape);
    }

    public static final void handleComponentSet(ServerPlayer sendingPlayer, InscriptionTableSetComponentMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.m_9236_(), message.getPosition());
        if (te == null) {
            return;
        }
        SpellEffect spellComponent = (SpellEffect)Registries.SpellEffect.get().getValue(message.getComponent());
        te.setCurrentComponent(spellComponent);
    }

    public static final void handleModifierSet(ServerPlayer sendingPlayer, InscriptionTableSetModifierMessage message) {
        if (message.getIndex() < 0 || message.getIndex() >= 3) {
            return;
        }
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.m_9236_(), message.getPosition());
        if (te == null) {
            return;
        }
        Modifier spellModifier = (Modifier)Registries.Modifier.get().getValue(message.getModifier());
        te.setCurrentModifier(spellModifier, message.getIndex());
    }

    public static final void handleAttributeValueChange(ServerPlayer sendingPlayer, InscriptionTableAttributeChangeMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.m_9236_(), message.getPosition());
        if (te == null) {
            return;
        }
        switch (message.getChangeType()) {
            case COMPONENT: {
                te.changeComponentAttributeValue(message.getAttribute(), message.getValue());
                break;
            }
            case SHAPE: {
                te.changeShapeAttributeValue(message.getAttribute(), message.getValue());
            }
        }
    }

    public static final void handleRequestStartCrafting(ServerPlayer sendingPlayer, InscriptionTableRequestStartCraftingMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.m_9236_(), message.getPosition());
        if (te == null) {
            return;
        }
        if (!te.isBuilding()) {
            te.build();
        }
    }

    public static final void handleCraftingUpdate(Level world, InscriptionTableCraftingUpdateMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(world, message.getPosition());
        if (te == null) {
            return;
        }
        te.isCrafting = message.getBurnTimeRemaining() > 0;
        te.craftTicksTotal = message.getTotalCraftTicks();
        te.craftTicksConsumed = message.getCraftTicksPassed();
        te.burnTicksRemaining = message.getBurnTimeRemaining();
        te.inkDamageRemaining = message.getInkRemaining();
        te.paperRemaining = message.getPaperRemaining();
    }
}

