/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.magic;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagic;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerMagicProvider
implements ICapabilitySerializable<Tag> {
    final String KEY_CASTING_RESOURCE_TYPE = "casting_resource_id";
    final String KEY_TELEPORT_SALT = "teleport_salt";
    final String KEY_PORTAL_COOLDOWN = "portal_cooldown";
    final String KEY_RIFT = "rift";
    final String KEY_GRIMOIRE = "grimoire";
    final String KEY_ROTE = "rote";
    final String KEY_AFFINITY = "affinity";
    final String KEY_MAGIC_LEVEL = "magic_level";
    final String KEY_MAGIC_XP = "magic_xp";
    final String KEY_AIR_CASTS = "air_casts";
    final String KEY_AIR_JUMPS = "air_jumps";
    final String KEY_DID_ALLOW_FLIGHT = "did_allow_flying";
    final String KEY_MAX_MANA_MODIFIERS = "max_mana_modifiers";
    final String KEY_LAST_CODEX_ENTRY = "last_codex_entry";
    final String KEY_CANTRIPS = "cantrips";
    final String KEY_ARMOR_REPAIR = "banked_armor_repair";
    final String KEY_SPELL_COLOR = "spell_color_override";
    final String KEY_EMBER_COOLDOWN = "ember_cooldown";
    public static final Capability<IPlayerMagic> MAGIC = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerMagic>(){});
    private final LazyOptional<IPlayerMagic> holder = LazyOptional.of(PlayerMagic::new);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return MAGIC.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        IPlayerMagic instance = (IPlayerMagic)this.holder.orElse(null);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("casting_resource_id", instance.getCastingResource().getRegistryName().toString());
        instance.getCastingResource().writeNBT(nbt);
        nbt.m_128405_("teleport_salt", instance.getTeleportSalt());
        nbt.m_128405_("air_casts", instance.getAirCasts());
        nbt.m_128405_("air_jumps", instance.getAirJumps());
        nbt.m_128405_("ember_cooldown", instance.getEmberCooldown());
        nbt.m_128405_("spell_color_override", instance.getParticleColorOverride());
        nbt.m_128365_("rift", (Tag)this.saveInventory((Container)instance.getRiftInventory()));
        nbt.m_128365_("grimoire", (Tag)this.saveInventory((Container)instance.getGrimoireInventory()));
        nbt.m_128365_("rote", (Tag)this.saveInventory((Container)instance.getRoteInventory()));
        nbt.m_128379_("did_allow_flying", instance.didAllowFlying());
        for (Affinity aff : Affinity.values()) {
            nbt.m_128350_("affinity_" + aff.toString().toLowerCase(), instance.getAffinityDepth(aff));
        }
        nbt.m_128405_("magic_level", instance.getMagicLevel());
        nbt.m_128405_("magic_xp", instance.getMagicXP());
        instance.getChronoAnchorData().writeToNBT(nbt);
        nbt.m_128365_("cantrips", (Tag)instance.getCantripData().writeToNBT(false));
        ListTag armor_repair = new ListTag();
        for (Map.Entry<Integer, Float> bank_slot : instance.getBankedArmorRepair().entrySet()) {
            CompoundTag bank = new CompoundTag();
            bank.m_128405_("key", bank_slot.getKey().intValue());
            bank.m_128350_("value", bank_slot.getValue().floatValue());
            armor_repair.add((Object)bank);
        }
        nbt.m_128365_("banked_armor_repair", (Tag)armor_repair);
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        IPlayerMagic instance = (IPlayerMagic)this.holder.orElse(null);
        if (nbt instanceof CompoundTag) {
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_("magic_level")) {
                instance.setMagicLevel(null, cnbt.m_128451_("magic_level"));
            }
            if (cnbt.m_128441_("casting_resource_id")) {
                instance.setCastingResourceType(new ResourceLocation(cnbt.m_128461_("casting_resource_id")));
            }
            instance.getCastingResource().readNBT(cnbt);
            instance.getCastingResource().setNeedsSync();
            if (cnbt.m_128441_("teleport_salt")) {
                instance.setTeleportSalt(cnbt.m_128451_("teleport_salt"));
            }
            if (cnbt.m_128441_("portal_cooldown")) {
                instance.setPortalCooldown(cnbt.m_128451_("portal_cooldown"));
            }
            if (cnbt.m_128441_("spell_color_override")) {
                instance.setParticleColorOverride(cnbt.m_128451_("spell_color_override"));
            }
            if (cnbt.m_128441_("air_casts")) {
                instance.setAirCasts(cnbt.m_128451_("air_casts"));
            }
            if (cnbt.m_128441_("air_jumps")) {
                instance.setAirJumps(cnbt.m_128451_("air_jumps"));
            }
            if (cnbt.m_128441_("ember_cooldown")) {
                instance.setEmberCooldown(cnbt.m_128451_("ember_cooldown"));
            }
            if (cnbt.m_128441_("did_allow_flying")) {
                instance.setDidAllowFlying(cnbt.m_128471_("did_allow_flying"));
            }
            if (cnbt.m_128441_("rift")) {
                this.readInventory((Container)instance.getRiftInventory(), cnbt.m_128469_("rift"));
            }
            if (cnbt.m_128441_("grimoire")) {
                this.readInventory((Container)instance.getGrimoireInventory(), cnbt.m_128469_("grimoire"));
            }
            if (cnbt.m_128441_("rote")) {
                this.readInventory((Container)instance.getRoteInventory(), cnbt.m_128469_("rote"));
            }
            if (cnbt.m_128441_("magic_xp")) {
                instance.setMagicXP(cnbt.m_128451_("magic_xp"));
            }
            for (Affinity aff : Affinity.values()) {
                if (!cnbt.m_128441_("affinity_" + aff.toString().toLowerCase())) continue;
                instance.setAffinityDepth(aff, cnbt.m_128457_("affinity_" + aff.toString().toLowerCase()));
            }
            instance.getChronoAnchorData().readFromNBT(cnbt);
            if (cnbt.m_128441_("cantrips")) {
                instance.getCantripData().readFromNBT((CompoundTag)cnbt.m_128423_("cantrips"));
            }
            if (cnbt.m_128441_("banked_armor_repair")) {
                ListTag banked_armor = cnbt.m_128437_("banked_armor_repair", 10);
                HashMap<Integer, Float> parsed_banked_armor = new HashMap<Integer, Float>();
                for (int i = 0; i < banked_armor.size(); ++i) {
                    CompoundTag bank = banked_armor.m_128728_(i);
                    if (!bank.m_128441_("key") || !bank.m_128441_("value")) continue;
                    int key = bank.m_128451_("key");
                    float value = bank.m_128457_("value");
                    parsed_banked_armor.put(key, Float.valueOf(value));
                }
                instance.setBankedArmorRepair(parsed_banked_armor);
            }
            instance.validate();
            instance.forceSync();
        } else {
            ManaAndArtifice.LOGGER.error("Mana NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }

    private CompoundTag saveInventory(Container inventory) {
        NonNullList inventoryItems = NonNullList.m_122779_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            inventoryItems.add((Object)inventory.m_8020_(i));
        }
        CompoundTag inv = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inv, (NonNullList)inventoryItems);
        return inv;
    }

    private void readInventory(Container inventory, CompoundTag nbt) {
        NonNullList inventoryItems = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)inventoryItems);
        for (int i = 0; i < inventoryItems.size(); ++i) {
            if (inventory.m_6643_() <= i) continue;
            inventory.m_6836_(i, (ItemStack)inventoryItems.get(i));
        }
    }
}

