/*
 * Decompiled with CFR 0.152.
 */
package com.mna.effects.beneficial;

import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.effects.interfaces.IDoubleTapEndEarly;
import com.mna.effects.interfaces.IInputDisable;
import com.mna.effects.interfaces.INoCreeperLingering;
import com.mna.factions.Factions;
import com.mna.tools.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;

public class EffectPossession
extends MobEffect
implements IInputDisable,
IDoubleTapEndEarly,
INoCreeperLingering {
    public static final int AMP_TARGET = 0;
    public static final int AMP_CASTER_STANDARD = 1;
    public static final int AMP_CASTER_GREATER = 2;

    public EffectPossession() {
        super(MobEffectCategory.HARMFUL, 0);
    }

    public void m_6385_(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        super.m_6385_(entityLivingBaseIn, attributeMapIn, amplifier);
        if (entityLivingBaseIn instanceof Mob) {
            Mob mob = (Mob)entityLivingBaseIn;
            mob.m_21557_(true);
        }
    }

    public void m_6386_(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        super.m_6386_(entityLivingBaseIn, attributeMapIn, amplifier);
        if (entityLivingBaseIn instanceof Mob) {
            ((Mob)entityLivingBaseIn).m_21557_(false);
        }
        if (entityLivingBaseIn instanceof Player) {
            Player player = (Player)entityLivingBaseIn;
            if (amplifier == 2) {
                EntityUtil.removeInvisibility((LivingEntity)player);
                Mob mob = this.getPossessedMob(player);
                if (mob == null || !mob.m_6084_() || mob.m_21224_()) {
                    MutableInt mistFormDuration = new MutableInt(200);
                    player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                        if (p.getAlliedFaction() != null && p.getAlliedFaction().isAlliedTo(Factions.UNDEAD)) {
                            mistFormDuration.setValue(-1);
                        }
                    });
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MIST_FORM.get(), mistFormDuration.getValue().intValue()));
                }
            }
        }
    }

    @Override
    public EnumSet<IInputDisable.InputMask> getDisabledFlags() {
        return EnumSet.of(IInputDisable.InputMask.LEFT_CLICK, IInputDisable.InputMask.RIGHT_CLICK, IInputDisable.InputMask.MOVEMENT);
    }

    @Override
    public boolean canEndEarly(LivingEntity living, MobEffectInstance effect) {
        return effect.m_19564_() > 0;
    }

    @Override
    public void onRemoved(LivingEntity living, MobEffectInstance effect) {
        Player player;
        Mob mob;
        if (living instanceof Player && (mob = this.getPossessedMob(player = (Player)living)) != null) {
            mob.m_21195_((MobEffect)this);
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity instanceof Player) {
            Mob mob;
            Player player = (Player)pLivingEntity;
            if (pAmplifier == 2 && (mob = this.getPossessedMob(player)) != null) {
                Vec3 forward = mob.m_20156_();
                player.m_6021_(mob.m_20185_() - forward.f_82479_, mob.m_20186_(), mob.m_20189_() - forward.f_82481_);
                player.m_183634_();
                player.m_6842_(true);
            }
        }
    }

    @Nullable
    private Mob getPossessedMob(Player player) {
        if (player.getPersistentData().m_128441_("posessed_entity_id")) {
            int id = player.getPersistentData().m_128451_("posessed_entity_id");
            Entity e = player.m_9236_().m_6815_(id);
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
                return mob;
            }
        }
        return null;
    }
}

