/*
 * Decompiled with CFR 0.152.
 */
package com.mna.effects.particles;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.capabilities.entity.MAPFX;
import com.mna.capabilities.entity.MAPFXProvider;
import com.mna.entities.boss.DemonLord;
import com.mna.particles.types.movers.ParticleOrbitMover;
import com.mna.tools.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EffectParticleSpawner {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        boolean isThirdPerson = entity != ManaAndArtifice.instance.proxy.getClientPlayer() || Minecraft.m_91087_().f_91063_.m_109153_().m_90594_();
        entity.getCapability(MAPFXProvider.MAPFX).ifPresent(pfx -> {
            Vec3 pos;
            int i;
            pfx.requestSync(entity);
            if ((pfx.getFlag(entity, MAPFX.Flag.FIRE_SHIELD) || pfx.getFlag(entity, MAPFX.Flag.LIVING_BOMB)) && isThirdPerson) {
                int amount = (int)(entity.m_20206_() * 5.0f);
                MAParticleType type = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get()));
                if (entity instanceof DemonLord) {
                    type.setColor(Affinity.HELLFIRE.getColor()[0], Affinity.HELLFIRE.getColor()[1], Affinity.HELLFIRE.getColor()[2]);
                    type.setScale(0.075f);
                }
                for (int i2 = 0; i2 < amount; ++i2) {
                    world.m_7106_((ParticleOptions)type, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 3.0f * 2.0f) * Math.random(), entity.m_20189_(), (double)0.1f, (double)0.01f + Math.random() * (double)0.02f, 1.0 + Math.random());
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.MANA_SHIELD) && isThirdPerson) {
                for (i = 0; i < 3; ++i) {
                    double angle = Math.random() * 360.0 / 180.0 * Math.PI;
                    pos = new Vec3(entity.m_20185_() + Math.cos(angle), entity.m_20186_() + 1.9 + Math.random() * 0.2, entity.m_20189_() + Math.sin(angle));
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.BRIARTHORN_BARRIER) && isThirdPerson) {
                for (i = 0; i < 3; ++i) {
                    double angle = Math.random() * 360.0 / 180.0 * Math.PI;
                    pos = new Vec3(entity.m_20185_() + Math.cos(angle), entity.m_20186_() + 0.9 + Math.random() * 0.2, entity.m_20189_() + Math.sin(angle));
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, MathUtils.RandomBetween(0.01, 0.03), 0.0);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.MIST_FORM) && isThirdPerson) {
                for (i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.MIST.get())), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), (Math.random() - 0.5) * (double)0.1f, (Math.random() - 0.5) * (double)0.1f, (Math.random() - 0.5) * (double)0.1f);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.AURA_OF_FROST) && !pfx.getFlag(entity, MAPFX.Flag.MIST_FORM)) {
                for (i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMover(new ParticleOrbitMover(entity.m_20185_(), entity.m_20186_() + (double)0.05f, entity.m_20189_(), 0.05f, 0.01f, 1.0 + Math.random() * 2.0)), entity.m_20185_(), entity.m_20186_() + (double)0.05f, entity.m_20189_(), 0.0, Math.random() * (double)0.05f, 0.0);
                }
                for (i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), entity.m_20185_() - 3.0 + Math.random() * 6.0, entity.m_20186_() + (double)0.05f, entity.m_20189_() - 3.0 + Math.random() * 6.0, 0.0, Math.random() * (double)0.01f, 0.0);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.CIRCLE_OF_POWER) && isThirdPerson) {
                world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setMaxAge(5), entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() / 2.0, entity.m_20189_() - 0.5 + Math.random(), 0.0, (double)0.17f, 0.0);
            }
            if (pfx.getFlag(entity, MAPFX.Flag.WIND_WALL) && isThirdPerson) {
                for (i = 0; i < 10; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.05f).setColor(10, 10, 10), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (double)0.1f, (double)0.04f + Math.random() * (double)0.04f, (double)1.2f);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.SOAKED) && Math.random() < 0.5 && !entity.m_20072_() && isThirdPerson) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() * (double)entity.m_20206_(), entity.m_20189_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
            }
            if (pfx.getFlag(entity, MAPFX.Flag.SOUL_TRAP) && Math.random() < 0.5 && isThirdPerson) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_235898_, entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() * (double)entity.m_20206_(), entity.m_20189_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
            }
            if (pfx.getFlag(entity, MAPFX.Flag.CURSE_OF_AGONY) && isThirdPerson) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() * (double)entity.m_20206_(), entity.m_20189_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
                if (world.m_46467_() % 100L == 0L) {
                    for (i = 0; i < 25; ++i) {
                        world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(0.05f).setPhysics(true), entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() * (double)entity.m_20206_(), entity.m_20189_() - 0.5 + Math.random(), MathUtils.RandomBetween(-0.25, 0.25), MathUtils.RandomBetween(0.0, 0.05), MathUtils.RandomBetween(-0.25, 0.25));
                    }
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.SHACKLES_OF_PAIN) && Math.random() < 0.5 && isThirdPerson) {
                world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_GRAVITY.get())).setColor(150, 220, 181).setScale(0.25f).setPhysics(true), entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() * (double)entity.m_20206_(), entity.m_20189_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
            }
        });
    }
}

