/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss.attacks;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class ThrownWeapon
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    private ItemStack renderStack = ItemStack.f_41583_;
    private ParticleOptions trailParticle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setMaxAge(10);
    private float renderScale = 1.0f;

    public ThrownWeapon(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super(type, world);
    }

    public ThrownWeapon(EntityType<? extends AbstractHurtingProjectile> type, LivingEntity shooter, Level worldIn, ItemStack renderStack) {
        this(type, worldIn, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_(), renderStack);
        this.m_5602_((Entity)shooter);
    }

    public ThrownWeapon(EntityType<? extends AbstractHurtingProjectile> type, Level worldIn, double x, double y, double z, ItemStack renderStack) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
        this.setRenderStack(renderStack);
    }

    public ThrownWeapon setRenderStack(ItemStack stack) {
        this.renderStack = stack;
        return this;
    }

    public ThrownWeapon setTrailParticle(ParticleOptions particle) {
        this.trailParticle = particle;
        return this;
    }

    public ThrownWeapon setScale(float scale) {
        this.renderScale = scale;
        return this;
    }

    public ItemStack getRenderStack() {
        return this.renderStack;
    }

    public float getRenderScale() {
        return this.renderScale;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 Vector3d = new Vec3(x, y, z).m_82541_().m_82490_((double)velocity);
        this.m_20256_(Vector3d);
        double f = Vector3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_5790_(EntityHitResult ray) {
        Entity hitEntity = ray.m_82443_();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)hitEntity;
            Entity eOwner = this.m_19749_();
            if (eOwner instanceof LivingEntity) {
                livingHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)eOwner), 15.0f);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8060_(BlockHitResult ray) {
        if (!this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected ParticleOptions m_5967_() {
        return this.trailParticle;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_(this.trailParticle, this.m_20185_(), this.m_20186_(), this.m_20189_(), -0.5 + Math.random(), -0.5 + Math.random(), -0.5 + Math.random());
            }
        }
    }

    protected float m_6884_() {
        return 0.95f;
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.05f, 0.0));
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6087_() {
        return false;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.renderStack, true);
        buffer.m_130070_(this.trailParticle.m_5942_());
        buffer.writeFloat(this.renderScale);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.renderStack = additionalData.m_130267_();
        String trailParticle = additionalData.m_130277_();
        try {
            this.trailParticle = ParticleArgument.m_247456_((StringReader)new StringReader(trailParticle), (HolderLookup)this.m_9236_().m_246945_(Registries.f_256890_));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            ManaAndArtifice.LOGGER.warn("Couldn't load custom particle {}", (Object)trailParticle, (Object)commandsyntaxexception);
        }
        this.renderScale = additionalData.readFloat();
    }
}

