/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskFilterParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskItemStackParameter;
import com.mna.api.events.construct.ConstructEatItemEvent;
import com.mna.api.items.DynamicItemFilter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ConstructEatItem
extends ConstructAITask<ConstructEatItem> {
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private DynamicItemFilter filter = new DynamicItemFilter();
    private int eat_counter = -1;

    public ConstructEatItem(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        InteractionHand[] hands = this.construct.getCarryingHands(this.filter);
        if (hands.length <= 0) {
            this.forceFail();
            return;
        }
        InteractionHand hand = hands[0];
        if (this.eat_counter == -1) {
            this.getConstructAsEntity().m_6674_(hand);
            this.construct.setEating(hand);
            this.eat_counter = 30;
        } else if (--this.eat_counter <= 0) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.eat_success", new Object[0]));
            ItemStack stackCopy = this.construct.asEntity().m_21120_(hand).m_41777_();
            MinecraftForge.EVENT_BUS.post((Event)new ConstructEatItemEvent(this.construct, stackCopy));
            this.construct.asEntity().m_21008_(hand, ItemStack.f_41583_);
            this.construct.setHappy(100);
            this.construct.resetActions();
            this.setSuccessCode();
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.clearMoveTarget();
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.m_8036_();
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.EAT_ITEM);
    }

    @Override
    public ConstructEatItem duplicate() {
        return new ConstructEatItem(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructEatItem copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructEatItem) {
            ConstructEatItem otherEat = (ConstructEatItem)other;
            this.filter.copyFrom(otherEat.filter);
        }
        return this;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        return nbt;
    }

    @Override
    public void inflateParameters() {
        this.filter.clear();
        this.getParameter("eat_item.single").ifPresent(param -> {
            ConstructTaskItemStackParameter stackParam;
            if (param instanceof ConstructTaskItemStackParameter && !(stackParam = (ConstructTaskItemStackParameter)param).getStack().m_41619_()) {
                this.filter.getWhiteList().add((Object)stackParam.getStack().m_41777_());
            }
        });
        this.getParameter("eat_item.filter").ifPresent(param -> {
            ConstructTaskFilterParameter filter;
            if (param instanceof ConstructTaskFilterParameter && !(filter = (ConstructTaskFilterParameter)param).getValue().isEmpty()) {
                this.filter.copyFrom(filter.getValue());
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskFilterParameter("eat_item.filter"));
        parameters.add(new ConstructTaskItemStackParameter("eat_item.single"));
        return parameters;
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public boolean isFullyConfigured() {
        return true;
    }
}

