/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.api.items.DynamicItemFilter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ConstructSortItems
extends ConstructAITask<ConstructSortItems> {
    private static final int NUM_DESTINATIONS = 6;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private static final DynamicItemFilter emptyFilter = new DynamicItemFilter();
    ArrayList<DirectionalPoint> points = new ArrayList();
    private int interactTimer = 0;
    private int constructInventoryIndex = -2;
    private ItemStack curSort = ItemStack.f_41583_;
    private Optional<DirectionalPoint> insertLocation = Optional.empty();

    public ConstructSortItems(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.constructInventoryIndex >= this.construct.getSlots()) {
            this.setExitCode();
            return;
        }
        if (this.curSort.m_41619_()) {
            this.curSort = this.getNextSortItem();
            if (this.curSort.m_41619_()) {
                this.setExitCode();
                return;
            }
        }
        if (this.insertLocation.isEmpty()) {
            this.insertLocation = this.getPosFor(this.curSort);
            if (this.insertLocation.isEmpty()) {
                this.curSort = ItemStack.f_41583_;
                return;
            }
            this.setMoveTarget(this.insertLocation.get().getPosition());
        }
        if (this.doMove()) {
            AbstractGolem c = this.construct.asEntity();
            InteractionHand[] carrying = this.construct.getCarryingHands();
            if (this.interactTimer > 0) {
                if (this.interactTimer == 5) {
                    if (carrying.length > 0) {
                        c.m_6674_(carrying[0]);
                    } else {
                        c.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                --this.interactTimer;
            } else if (this.interactTimer == 0 && !this.performSortInsert(this.curSort, this.insertLocation.get())) {
                this.insertLocation = Optional.empty();
            }
        }
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && (this.construct.getCarryingHands().length > 0 || this.construct.hasItem(emptyFilter));
    }

    @Override
    public void onTaskSet() {
        super.onTaskSet();
        this.constructInventoryIndex = -2;
        this.interactTimer = 0;
        this.curSort = ItemStack.f_41583_;
        this.insertLocation = Optional.empty();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.interactTimer = 20;
    }

    private void setExitCode() {
        if (!this.construct.hasItem(emptyFilter)) {
            this.setSuccessCode();
        } else {
            this.forceFail();
        }
    }

    private Optional<DirectionalPoint> getPosFor(ItemStack sortStack) {
        AbstractGolem c = this.construct.asEntity();
        Level level = c.m_9236_();
        return this.points.stream().filter(p -> {
            if (!level.m_46749_(p.getPosition())) {
                return false;
            }
            BlockEntity be = level.m_7702_(p.getPosition());
            if (be == null) {
                return false;
            }
            LazyOptional handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, p.getDirection());
            if (!handler.isPresent()) {
                return false;
            }
            if (!InventoryUtilities.hasStackInInventory(new ItemStack((ItemLike)sortStack.m_41720_()), true, true, (IItemHandler)handler.resolve().get(), p.getDirection())) {
                return false;
            }
            return InventoryUtilities.hasRoomForAny((IItemHandler)handler.resolve().get(), sortStack);
        }).findFirst();
    }

    private boolean performSortInsert(ItemStack sortStack, DirectionalPoint point) {
        AbstractGolem c = this.construct.asEntity();
        Level level = c.m_9236_();
        if (!level.m_46749_(point.getPosition())) {
            return false;
        }
        BlockEntity be = level.m_7702_(point.getPosition());
        if (be == null) {
            return false;
        }
        LazyOptional handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, point.getDirection());
        if (!handler.isPresent()) {
            return false;
        }
        if (!InventoryUtilities.hasStackInInventory(new ItemStack((ItemLike)sortStack.m_41720_()), true, true, (IItemHandler)handler.resolve().get(), point.getDirection())) {
            return false;
        }
        String stackTranslated = this.translate(sortStack);
        String containerTranslated = this.translate(be);
        int initialSize = sortStack.m_41613_();
        boolean fullMerge = InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), sortStack);
        if (fullMerge) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.sort_success", stackTranslated, containerTranslated));
        } else {
            this.insertLocation = Optional.empty();
            if (sortStack.m_41613_() == initialSize) {
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.sort_fail", stackTranslated, containerTranslated));
            } else {
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.sort_success_partial", stackTranslated, containerTranslated));
                return true;
            }
        }
        return false;
    }

    private ItemStack getNextSortItem() {
        ItemStack next = ItemStack.f_41583_;
        do {
            next = this.constructInventoryIndex == -2 ? this.construct.asEntity().m_21205_() : (this.constructInventoryIndex == -1 ? this.construct.asEntity().m_21206_() : this.construct.getStackInSlot(this.constructInventoryIndex));
            ++this.constructInventoryIndex;
        } while (next.m_41619_() && this.constructInventoryIndex < this.construct.getSlots());
        return next;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.SORT_ITEMS);
    }

    @Override
    public void inflateParameters() {
        this.points.clear();
        for (int i = 0; i < 6; ++i) {
            this.getParameter("sort_items.point." + i).ifPresent(param -> {
                ConstructTaskPointParameter point;
                if (param instanceof ConstructTaskPointParameter && (point = (ConstructTaskPointParameter)param).getPoint() != null) {
                    this.points.add(point.getPoint());
                }
            });
        }
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        ArrayList<ConstructAITaskParameter> parameters = new ArrayList<ConstructAITaskParameter>();
        for (int i = 0; i < 6; ++i) {
            parameters.add(new ConstructTaskPointParameter("sort_items.point." + i));
        }
        return parameters;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.points.size() > 0;
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
    }

    @Override
    protected CompoundTag writeInternal(CompoundTag nbt) {
        return new CompoundTag();
    }

    @Override
    public ConstructSortItems copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructSortItems) {
            ConstructSortItems sort = (ConstructSortItems)other;
            this.points.clear();
            sort.points.forEach(dp -> this.points.add(DirectionalPoint.of(dp.save())));
        }
        return this;
    }

    @Override
    public ConstructSortItems duplicate() {
        return new ConstructSortItems(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }
}

