/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.ISpellInteractibleEntity;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.entities.EntityInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.ProjectileHelper;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Barkling
extends BaseFactionMob<Barkling>
implements ISpellInteractibleEntity<Barkling> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String ACTION_MELEE = "melee";
    private static final String ACTION_PARRY = "parry";
    private static final int PARRY_CD_T1 = 40;
    private static final int PARRY_CD_T2 = 20;
    private int parryCooldown = 0;
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean isParrying = false;

    public Barkling(EntityType<Barkling> type, Level worldIn) {
        super(type, worldIn);
    }

    public Barkling(Level worldIn) {
        this((EntityType<Barkling>)((EntityType)EntityInit.BARKLING.get()), worldIn);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.isActing) {
            if (this.isParrying) {
                builder.thenPlay("animation.barkling.parry");
            } else if (this.f_20912_ == InteractionHand.MAIN_HAND) {
                builder.thenPlay("animation.barkling.attack_1");
            } else {
                builder.thenPlay("animation.barkling.attack_2");
            }
        }
        if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
            if (this.m_5448_() != null) {
                builder.thenLoop("animation.barkling.walk_hasTarget");
            } else {
                builder.thenLoop("animation.barkling.walk_noTarget");
            }
        } else if (this.m_5448_() != null) {
            builder.thenLoop("animation.barkling.idle_hasTarget");
        } else {
            builder.thenLoop("animation.barkling.idle_noTarget");
        }
        return state.setAndContinue(builder);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        --this.parryCooldown;
    }

    @Override
    public IFaction getFaction() {
        return Factions.FEY;
    }

    public void m_6710_(LivingEntity pLivingEntity) {
        if (this.m_5448_() == pLivingEntity) {
            return;
        }
        super.m_6710_(pLivingEntity);
        if (!this.m_9236_().m_5776_()) {
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void m_21011_(InteractionHand p_226292_1_, boolean p_226292_2_) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 20, ACTION_MELEE, this::handleDelayCallback));
        this.isActing = true;
        this.isMeleeAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.m_5496_(SFX.Entity.Generic.WOOSH, 1.0f, (float)(0.9 + Math.random() * 0.2));
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.isMeleeAttacking) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 10, entityIn, this::handleDelayCallback));
        this.isMeleeAttacking = false;
        return true;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(1, this, new ParryGoal()));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_) * 1.5, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11755_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11688_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12635_;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isParrying) {
            Entity e = source.m_7640_();
            if (source.m_276093_(DamageTypes.f_268534_) && e instanceof Projectile) {
                ProjectileHelper.ReflectProjectile((LivingEntity)this, (Projectile)e, this.getTier() >= 1, (float)e.m_20184_().m_82553_());
                return false;
            }
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_)) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        if (this.m_5448_() == null) {
            return false;
        }
        double dist = this.m_20280_((Entity)this.m_5448_());
        if (dist > 9.0) {
            return false;
        }
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.2f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.45f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.6f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.9);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            switch (data) {
                case "melee": {
                    this.isMeleeAttacking = false;
                    break;
                }
                case "parry": {
                    this.parryCooldown = this.getTier() == 1 ? 40 : 20;
                    this.isParrying = false;
                }
            }
            this.isActing = this.isMeleeAttacking || this.isParrying;
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isActing);
        nbt.m_128379_("parrying", this.isParrying);
        nbt.m_128405_("target", this.m_5448_() == null ? -1 : this.m_5448_().m_19879_());
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        Entity e;
        this.isActing = nbt.m_128471_("attacking");
        this.isParrying = nbt.m_128471_("parrying");
        int targetId = nbt.m_128451_("target");
        if (targetId == -1) {
            this.m_6710_(null);
        }
        if ((e = this.m_9236_().m_6815_(targetId)) instanceof LivingEntity) {
            this.m_6710_((LivingEntity)e);
        }
    }

    @Override
    public boolean onShapeTarget(ISpellDefinition spell, SpellSource source) {
        if (!this.isParrying) {
            return false;
        }
        Vec3 fwd = Vec3.m_82503_((Vec2)this.m_20155_());
        return ManaAndArtificeMod.getSpellHelper().reflectSpell(this.m_9236_(), (LivingEntity)this, spell, source, this.m_20182_(), fwd, true);
    }

    public class ParryGoal
    extends Goal {
        private Entity dodgeEntity;

        public ParryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            if (Barkling.this.parryCooldown > 0) {
                return false;
            }
            Vec3 rt_startVec = Barkling.this.m_20182_();
            Vec3 thisFwd = Vec3.m_82503_((Vec2)Barkling.this.m_20155_());
            Vec3 rt_endVec = rt_startVec.m_82549_(thisFwd.m_82490_(10.0));
            List potentials = Barkling.this.m_9236_().m_45933_((Entity)Barkling.this, Barkling.this.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof Projectile && !e.m_20096_()).filter(e -> {
                AABB axisalignedbb = e.m_20191_().m_82400_(5.0);
                Optional optional = axisalignedbb.m_82371_(rt_startVec, rt_endVec);
                return optional.isPresent();
            }).collect(Collectors.toList());
            if (potentials.size() == 0) {
                return false;
            }
            potentials.sort(new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    Double d1 = o1.m_20280_((Entity)Barkling.this);
                    Double d2 = o2.m_20280_((Entity)Barkling.this);
                    return d1.compareTo(d2);
                }
            });
            this.dodgeEntity = (Entity)potentials.get(0);
            return true;
        }

        public void m_8056_() {
            Barkling.this.m_21573_().m_26573_();
            Barkling.this.isParrying = true;
            Barkling.this.isActing = true;
            Barkling.this.m_21563_().m_24960_(this.dodgeEntity, 30.0f, 30.0f);
            DelayedEventQueue.pushEvent(Barkling.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 70, Barkling.ACTION_PARRY, Barkling.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(Barkling.this);
        }

        public void m_8037_() {
            Barkling.this.m_21563_().m_24960_(this.dodgeEntity, 30.0f, 30.0f);
        }

        public boolean m_8045_() {
            return Barkling.this.isParrying;
        }

        protected EntityHitResult rayTraceEntity(Vec3 startVec, Vec3 endVec, float size, Entity searchEntity) {
            return ProjectileUtil.m_37304_((Level)Barkling.this.m_9236_(), (Entity)Barkling.this, (Vec3)startVec, (Vec3)endVec, (AABB)Barkling.this.m_20191_().m_82400_((double)size), entity -> searchEntity == entity);
        }
    }
}

