/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.ai.TargetEnemyFactionGoal;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.targeting.SpellTargetHelper;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.faction.HulkingZombie;
import com.mna.entities.faction.SkeletonAssassin;
import com.mna.entities.faction.base.BaseFlyingFactionMob;
import com.mna.factions.Factions;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Chatterer
extends BaseFlyingFactionMob<Chatterer>
implements AnimationController.SoundKeyframeHandler<Chatterer> {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(Chatterer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int CHATTER_ID = 1000;
    private static final int PARALYZE_DIST = 10;

    public Chatterer(EntityType<Chatterer> type, Level world) {
        super(type, world);
        this.randomFlyCooldown = 220;
    }

    public Chatterer(Level world) {
        this((EntityType<Chatterer>)((EntityType)EntityInit.CHATTERER.get()), world);
    }

    private void checkForParalysis() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ArrayList players = new ArrayList();
        this.m_9236_().m_6907_().forEach(p -> {
            double dist = p.m_20280_((Entity)this);
            boolean isBlind = p.m_21023_(MobEffects.f_19610_);
            if (isBlind) {
                return;
            }
            if (dist < 100.0 && p.m_6084_()) {
                if (this.getRaidTarget() == p) {
                    players.add(p);
                } else if (!p.m_7500_() && !p.m_5833_()) {
                    p.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(pr -> {
                        if (pr.getAlliedFaction() != Factions.UNDEAD) {
                            players.add(p);
                        }
                    });
                }
            }
        });
        for (Player p2 : players) {
            EntityHitResult hitResult = SpellTargetHelper.rayTraceEntities(this.m_9236_(), (Entity)p2, p2.m_146892_(), p2.m_146892_().m_82549_(p2.m_20156_().m_82490_(10.0)), p2.m_20191_().m_82400_(10.0), e -> e == this);
            if (!p2.m_21023_(MobEffects.f_19619_) && (hitResult == null || hitResult.m_6662_() != HitResult.Type.ENTITY)) continue;
            this.setAction(Action.PARALYZED);
            this.m_7292_(new MobEffectInstance((MobEffect)EffectInit.GRAVITY_WELL.get(), 60));
            this.setTimer("paralyze", 60, () -> {
                this.setAction(Action.IDLE);
                this.checkForParalysis();
            }, false);
            return;
        }
        if (this.getAction() == Action.PARALYZED) {
            this.setAction(Action.IDLE);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 10L == 0L) {
            this.checkForParalysis();
        }
        if (this.m_9236_().m_5776_() && this.getAction() != Action.PARALYZED) {
            RandomSource random = this.m_9236_().m_213780_();
            Vec3 pos = this.m_20182_().m_82549_(this.m_20156_().m_82490_(-0.25));
            for (int i = 0; i < 30; ++i) {
                int color = random.m_188503_(50);
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())).setColor(color, color, color).setMaxAge(10 + random.m_188503_(10)).setScale(0.05f + (float)(random.m_188583_() * 0.05)), pos.f_82479_ - 0.1 + random.m_188583_() * 0.2 + this.m_20184_().f_82479_, pos.f_82480_ - 0.35 + random.m_188583_() * 0.2 + this.m_20184_().f_82480_, pos.f_82481_ - 0.1 + random.m_188583_() * 0.2 + this.m_20184_().f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SummonReinforcements());
        this.f_21345_.m_25352_(3, (Goal)new Chatter());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, -1.0);
    }

    public static boolean canSpawnPredicate(EntityType<Chatterer> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return IFactionEnemy.canMnASpawn((LevelAccessor)worldIn, pos) && worldIn.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)randomIn) && pos.m_123342_() < worldIn.m_141937_() + 64 && Chatterer.m_217057_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    @Override
    public IFaction getFaction() {
        return Factions.UNDEAD;
    }

    @Override
    public CompoundTag getPacketData() {
        return new CompoundTag();
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
    }

    private Action getAction() {
        int ordinal = (this.getStateFlag() & 0x7F8) >> 3 & 0xFF;
        if (ordinal >= Action.values().length) {
            return Action.IDLE;
        }
        return Action.values()[ordinal];
    }

    private void setAction(Action action) {
        byte ordinal = (byte)((action.ordinal() & 0xFF) << 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFF807;
        this.setState(flag |= ordinal);
    }

    @Override
    protected float keepDistanceFromAttackTarget() {
        return 6.0f;
    }

    @Override
    protected void addControllerListeners(AnimationController<Chatterer> controller) {
        controller.transitionLength(2);
        controller.setSoundKeyframeHandler((AnimationController.SoundKeyframeHandler)this);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFlyingFactionMob<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.getAction() != Action.IDLE) {
            switch (this.getAction()) {
                case CHATTERING: {
                    builder.thenPlay("animation.chatterer.chatter");
                    break;
                }
                case DESTRUCTING: {
                    builder.thenPlayAndHold("animation.chatterer.destruct");
                    break;
                }
                case PARALYZED: {
                    builder.thenPlay("animation.chatterer.paralyzed");
                    break;
                }
            }
        }
        if (builder.getAnimationStages().size() == 0) {
            if (this.m_20184_().m_82553_() > (double)0.1f) {
                builder.thenLoop("animation.chatterer.move");
            } else if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                builder.thenLoop("animation.chatterer.idle");
            } else {
                builder.thenLoop("animation.chatterer.idle_hostile");
            }
        }
        return state.setAndContinue(builder);
    }

    public void handle(SoundKeyframeEvent<Chatterer> event) {
        if (event.getKeyframeData().getSound().contains("click")) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Entity.Chatterer.CLACK, this.m_5720_(), 1.0f, (float)(0.95 + Math.random() * 0.1), false);
        }
    }

    public static enum Action {
        IDLE,
        CHATTERING,
        PARALYZED,
        DESTRUCTING;

    }

    private class SummonReinforcements
    extends Goal {
        private SummonReinforcements() {
        }

        public boolean m_8036_() {
            if (Chatterer.this.m_5448_() == null || Chatterer.this.getAction() != Action.IDLE) {
                return false;
            }
            LivingEntity target = Chatterer.this.m_5448_();
            if (Chatterer.this.m_20270_((Entity)target) > 16.0f) {
                return false;
            }
            if (!target.m_21023_(MobEffects.f_19610_)) {
                return false;
            }
            if (Chatterer.this.getTier() > 0 && !target.m_21023_((MobEffect)EffectInit.FORTIFICATION.get())) {
                return false;
            }
            if (Chatterer.this.getTier() == 1 && !target.m_21023_(MobEffects.f_19614_)) {
                return false;
            }
            return Chatterer.this.getTier() != 2 || target.m_21023_(MobEffects.f_19615_);
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Chatterer.this.setAction(Action.DESTRUCTING);
            if (Chatterer.this.m_9236_().m_5776_()) {
                return;
            }
            Chatterer.this.setTimer("destruct", 75, () -> {
                int i;
                int tier = Chatterer.this.getTier();
                int numSkeletons = 0;
                int numZombies = 0;
                ArrayList spawns = new ArrayList();
                spawns.add(new SkeletonAssassin(Chatterer.this.m_9236_()));
                if (tier == 0) {
                    numZombies = 1 + (int)(Math.random() * 2.0);
                } else if (tier == 1) {
                    numZombies = 1 + (int)(Math.random() * 2.0);
                    numSkeletons = 1 + (int)(Math.random() * 1.0);
                } else {
                    numZombies = 1 + (int)(Math.random() * 3.0);
                    numSkeletons = 1 + (int)(Math.random() * 2.0);
                    if (Math.random() < 0.5) {
                        spawns.add(new HulkingZombie(Chatterer.this.m_9236_()));
                    }
                }
                for (i = 0; i < numZombies; ++i) {
                    spawns.add(new Zombie(Chatterer.this.m_9236_()));
                }
                for (i = 0; i < numSkeletons; ++i) {
                    Skeleton skeleton = new Skeleton(EntityType.f_20524_, Chatterer.this.m_9236_());
                    skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    spawns.add(skeleton);
                }
                spawns.forEach(z -> {
                    z.m_146884_(Chatterer.this.m_20182_().m_82520_(-1.0 + Math.random() * 2.0, 0.0, -1.0 + Math.random() * 2.0));
                    z.m_6710_(Chatterer.this.m_5448_());
                    z.f_21346_.m_262460_(g -> true);
                    z.f_21346_.m_25352_(0, (Goal)new TargetEnemyFactionGoal((Mob)z, LivingEntity.class, true, true, Factions.UNDEAD));
                    Chatterer.this.m_9236_().m_7967_((Entity)z);
                });
                Chatterer.this.m_146870_();
            });
        }
    }

    private class Chatter
    extends Goal {
        private Chatter() {
        }

        public boolean m_8036_() {
            if (Chatterer.this.isOnCooldown(1000) || Chatterer.this.m_5448_() == null || Chatterer.this.getAction() != Action.IDLE) {
                return false;
            }
            LivingEntity target = Chatterer.this.m_5448_();
            if (Chatterer.this.m_20270_((Entity)target) > 8.0f) {
                return false;
            }
            if (!target.m_21023_(MobEffects.f_19610_)) {
                return true;
            }
            if (Chatterer.this.getTier() > 0 && !target.m_21023_((MobEffect)EffectInit.FORTIFICATION.get())) {
                return true;
            }
            if (Chatterer.this.getTier() == 1 && !target.m_21023_(MobEffects.f_19614_)) {
                return true;
            }
            return Chatterer.this.getTier() == 2 && !target.m_21023_(MobEffects.f_19615_);
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Chatterer.this.setCooldown(1000, 60);
            Chatterer.this.setAction(Action.CHATTERING);
            LivingEntity target = Chatterer.this.m_5448_();
            Chatterer.this.setTimer("chatter", 36, () -> {
                if (Chatterer.this.getAction() != Action.CHATTERING) {
                    return;
                }
                Chatterer.this.setAction(Action.IDLE);
                if (Chatterer.this.m_20270_((Entity)target) > 8.0f) {
                    return;
                }
                if (!target.m_21023_(MobEffects.f_19610_)) {
                    Chatterer.this.setCooldown(1000, 80);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 0));
                    return;
                }
                if (Chatterer.this.getTier() > 0 && !target.m_21023_((MobEffect)EffectInit.FORTIFICATION.get())) {
                    Chatterer.this.setCooldown(1000, 100);
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectInit.FORTIFICATION.get(), 200, 0));
                    return;
                }
                if (Chatterer.this.getTier() == 1 && !target.m_21023_(MobEffects.f_19614_)) {
                    Chatterer.this.setCooldown(1000, 100);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
                    return;
                }
                if (Chatterer.this.getTier() == 2 && !target.m_21023_(MobEffects.f_19615_)) {
                    Chatterer.this.setCooldown(1000, 100);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
                    return;
                }
            });
        }
    }
}

