/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.affinity.Affinity;
import com.mna.api.entities.DamageHelper;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.ai.CastSpellOnSelfGoal;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.effects.EffectInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFlyingFactionMob;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.network.ServerMessageDispatcher;
import com.mna.spells.crafting.SpellRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Pixie
extends BaseFlyingFactionMob<Pixie> {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Pixie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TELEPORTING = SynchedEntityData.m_135353_(Pixie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> AFFINITY = SynchedEntityData.m_135353_(Pixie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Pixie(EntityType<Pixie> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean canSpawnPredicate(EntityType<Pixie> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        if (IFactionEnemy.canMnASpawn((LevelAccessor)worldIn, pos)) {
            return worldIn.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)randomIn) && Pixie.m_217057_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
        }
        return false;
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles();
        }
        super.m_8119_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_()) {
            this.pickRandomAffinity();
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SFX.Entity.Pixie.HURT;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.Pixie.DEATH;
    }

    @Override
    public IFaction getFaction() {
        return Factions.FEY;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAffinity() == Affinity.FIRE && source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (this.getAffinity() == Affinity.WATER && source.m_269533_(DamageTypeTags.f_268581_)) {
            return false;
        }
        if (this.getAffinity() == Affinity.EARTH && !source.m_269533_(DamageTypeTags.f_268490_)) {
            amount /= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TELEPORTING, (Object)false);
        this.f_19804_.m_135372_(AFFINITY, (Object)Affinity.WIND.ordinal());
    }

    public boolean isActing() {
        return this.isAttacking() || this.isTeleporting();
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public boolean isTeleporting() {
        return (Boolean)this.f_19804_.m_135370_(TELEPORTING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public void setTeleporting(boolean teleporting) {
        this.f_19804_.m_135381_(TELEPORTING, (Object)teleporting);
    }

    public Affinity getAffinity() {
        return Affinity.values()[(Integer)this.f_19804_.m_135370_(AFFINITY)];
    }

    private void pickRandomAffinity() {
        Affinity[] validAffinities = new Affinity[]{Affinity.FIRE, Affinity.EARTH, Affinity.WATER, Affinity.WIND};
        this.f_19804_.m_135381_(AFFINITY, (Object)validAffinities[(int)(Math.random() * (double)validAffinities.length)].ordinal());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        CastSpellOnSelfGoal<Pixie> teleportGoal = new CastSpellOnSelfGoal<Pixie>(this, this.createBlinkSpell(), pix -> pix.m_5448_() != null && pix.m_5448_().m_20280_((Entity)pix) < 16.0, pix -> {
            pix.setTeleporting(true);
            pix.m_21195_((MobEffect)EffectInit.GRAVITY_WELL.get());
        }, pix -> pix.setTeleporting(false), 10);
        this.f_21345_.m_25352_(6, (Goal)new FactionTierWrapperGoal(2, this, teleportGoal));
        this.f_21345_.m_25352_(7, (Goal)new BoltAttackGoal(this));
    }

    private ItemStack createBlinkSpell() {
        ItemStack invisSpell = new ItemStack((ItemLike)ItemInit.SPELL.get());
        SpellRecipe invis = new SpellRecipe();
        invis.setShape(Shapes.SELF);
        invis.addComponent(Components.BLINK);
        invis.changeComponentAttributeValue(0, Attribute.RANGE, 12.0f);
        invis.writeToNBT(invisSpell.m_41784_());
        return invisSpell;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.45f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    @Override
    protected void addControllerListeners(AnimationController<Pixie> controller) {
        controller.transitionLength(2);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFlyingFactionMob<?>> state) {
        if (!this.isActing()) {
            if (this.m_20184_().m_82553_() > (double)0.1f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.pixie.move"));
            }
        } else {
            if (this.isAttacking()) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.pixie.cast").thenLoop("animation.pixie.idle_hostile"));
            }
            if (this.isTeleporting()) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.pixie.teleport").thenLoop("animation.pixie.idle_hostile"));
            }
        }
        if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.pixie.idle"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.pixie.idle_hostile"));
    }

    private void spawnParticles() {
        int numParticles = 2;
        for (int i = 0; i < numParticles; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())).setColor(229, 220, 84), this.m_20185_() - 0.2 + Math.random() * 0.4, this.m_20186_() + Math.random() * 0.5, this.m_20189_() - 0.2 + Math.random() * 0.4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        return new CompoundTag();
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
    }

    static class BoltAttackGoal
    extends Goal {
        private final Pixie parentEntity;
        public int attackTimer;

        public BoltAttackGoal(Pixie pixie) {
            this.parentEntity = pixie;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.parentEntity.setAttacking(false);
        }

        public boolean m_8045_() {
            return this.parentEntity.m_5448_() != null && this.parentEntity.m_5448_().m_6084_();
        }

        public void m_8037_() {
            LivingEntity livingentity = this.parentEntity.m_5448_();
            if (livingentity == null) {
                return;
            }
            if (livingentity.m_20280_((Entity)this.parentEntity) < 144.0 && this.parentEntity.m_21574_().m_148306_((Entity)livingentity)) {
                ++this.attackTimer;
                if (this.attackTimer == 40) {
                    this.parentEntity.setAttacking(true);
                }
                if (this.attackTimer == 42) {
                    if (!this.parentEntity.m_20067_()) {
                        this.parentEntity.m_5496_(SFX.Entity.Pixie.ATTACK, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                    }
                    boolean isMiss = Math.random() > (double)(0.3f + (float)this.parentEntity.getTier() * 0.5f);
                    Vec3 offset = new Vec3(0.0, 0.0, 0.0);
                    if (isMiss) {
                        offset = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() * 0.5);
                    }
                    int color = 0;
                    switch (this.parentEntity.getAffinity()) {
                        case EARTH: {
                            color = -14126821;
                            break;
                        }
                        case WIND: {
                            color = -3815995;
                            break;
                        }
                        case FIRE: {
                            color = -3648221;
                            break;
                        }
                        default: {
                            color = 0;
                        }
                    }
                    ServerMessageDispatcher.sendParticleSpawn(this.parentEntity.m_20185_(), this.parentEntity.m_20186_(), this.parentEntity.m_20189_(), this.parentEntity.m_5448_().m_20185_() + offset.m_7096_(), this.parentEntity.m_5448_().m_20186_() + (double)this.parentEntity.m_5448_().m_20192_() + offset.m_7098_(), this.parentEntity.m_5448_().m_20189_() + offset.m_7094_(), color, 64.0f, (ResourceKey<Level>)this.parentEntity.m_9236_().m_46472_(), (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()));
                    if (!isMiss) {
                        switch (this.parentEntity.getAffinity()) {
                            case EARTH: {
                                this.applyEarthEffect();
                                break;
                            }
                            case WATER: {
                                this.applyWaterEffect();
                                break;
                            }
                            case FIRE: {
                                this.applyFireEffect();
                                break;
                            }
                            default: {
                                this.applyAirEffect();
                            }
                        }
                    }
                } else if (this.attackTimer >= 62) {
                    this.parentEntity.setAttacking(false);
                    this.attackTimer = 0;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }

        private void applyAirEffect() {
            LivingEntity tgt = this.parentEntity.m_5448_();
            if (tgt.m_20096_()) {
                tgt.m_5997_((double)-0.2f + Math.random() * (double)0.4f, 1.0, (double)-0.2f + Math.random() * (double)0.4f);
                if (tgt instanceof Player) {
                    ((ServerPlayer)tgt).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)tgt));
                }
            }
        }

        private void applyWaterEffect() {
            if (this.parentEntity.m_5448_().m_20069_()) {
                this.parentEntity.m_5448_().m_7292_(new MobEffectInstance((MobEffect)EffectInit.WATERY_GRAVE.get(), 10));
            } else {
                this.parentEntity.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
            }
            this.parentEntity.m_5448_().m_6469_(DamageHelper.createSourcedType(DamageHelper.FROST, this.parentEntity.m_9236_().m_9598_(), (Entity)this.parentEntity), (float)(2 * this.parentEntity.getTier()));
        }

        private void applyEarthEffect() {
            if (!this.parentEntity.m_5448_().m_20096_() && this.parentEntity.m_5448_().m_21124_((MobEffect)EffectInit.GRAVITY_WELL.get()) == null) {
                this.parentEntity.m_5448_().m_7292_(new MobEffectInstance((MobEffect)EffectInit.GRAVITY_WELL.get(), 100));
            }
            this.parentEntity.m_5448_().m_6469_(this.parentEntity.m_269291_().m_269333_((LivingEntity)this.parentEntity), 4.0f);
        }

        private void applyFireEffect() {
            this.parentEntity.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100));
            if (this.parentEntity.m_5448_() instanceof Player) {
                Player player = (Player)this.parentEntity.m_5448_();
                player.m_6168_().forEach(stack -> stack.m_41622_(5, (LivingEntity)player, item -> {}));
            }
        }
    }
}

