/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.ai.AIPredicateWrapperGoal;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.entities.projectile.SkeletonAssassinBolo;
import com.mna.entities.projectile.SkeletonAssassinShuriken;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.math.Vector3;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SkeletonAssassin
extends BaseFactionMob<SkeletonAssassin>
implements RangedAttackMob {
    private static final String INSTRUCTION_SHURIKEN = "shuriken";
    private static final String INSTRUCTION_MELEE = "melee";
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_BOLO = "bolo";
    private static final String INSTRUCTION_SMOKEBOMB = "smokebomb";
    private static final String INSTRUCTION_BACKFLIP = "backflip";
    private static final int COOLDOWN_BOLO = 300;
    private static final int COOLDOWN_BACKFLIP = 200;
    private static final int COOLDOWN_SMOKEBOMB = 1200;
    private boolean isActing = false;
    private boolean throwingShuriken = false;
    private boolean smokeBomb = false;
    private boolean throwingBolo = false;
    private boolean backflipping = false;
    private int boloCooldown = 0;
    private int backflipCooldown = 0;
    private int smokeBombCooldown = 0;
    private boolean instantTransition = false;

    public SkeletonAssassin(EntityType<SkeletonAssassin> type, Level worldIn) {
        super(type, worldIn);
    }

    public SkeletonAssassin(Level worldIn) {
        this((EntityType<SkeletonAssassin>)((EntityType)EntityInit.SKELETON_ASSASSIN.get()), worldIn);
    }

    public static boolean canSpawnPredicate(EntityType<SkeletonAssassin> p_234351_0_, LevelAccessor p_234351_1_, MobSpawnType p_234351_2_, BlockPos p_234351_3_, RandomSource p_234351_4_) {
        if (p_234351_1_ instanceof ServerLevelAccessor) {
            return p_234351_3_.m_123342_() <= 60 && Monster.m_219013_(p_234351_0_, (ServerLevelAccessor)((ServerLevelAccessor)p_234351_1_), (MobSpawnType)p_234351_2_, (BlockPos)p_234351_3_, (RandomSource)p_234351_4_);
        }
        return false;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        if (this.instantTransition) {
            state.getController().transitionLength(0);
            this.instantTransition = false;
        } else {
            state.getController().transitionLength(5);
        }
        if (!this.isActing) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.skeleton_assassin.run"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.skeleton_assassin.idle"));
        }
        if (this.throwingShuriken) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.skeleton_assassin.quick_throw"));
        }
        if (this.smokeBomb) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.skeleton_assassin.smoke_bomb"));
        }
        if (this.throwingBolo) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.skeleton_assassin.outerhand_throw"));
        }
        if (this.backflipping) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.skeleton_assassin.backflip"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.skeleton_assassin.slash"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.boloCooldown > 0) {
            --this.boloCooldown;
        }
        if (this.backflipCooldown > 0) {
            --this.backflipCooldown;
        }
        if (this.smokeBombCooldown > 0) {
            --this.smokeBombCooldown;
        }
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
    }

    @Override
    public IFaction getFaction() {
        return Factions.UNDEAD;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new AIPredicateWrapperGoal<SkeletonAssassin>(this, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false)).executionPredicate(me -> me.m_5448_() != null && me.m_5448_().m_6084_() && me.m_20145_()));
        this.f_21345_.m_25352_(2, (Goal)new FleeSunGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_)));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(2, this, new SmokeBombGoal()));
        this.f_21345_.m_25352_(3, (Goal)new FactionTierWrapperGoal(1, this, new BoloGoal(this, this.m_21133_(Attributes.f_22279_), 20, 15, 24.0f)));
        this.f_21345_.m_25352_(4, (Goal)new FactionTierWrapperGoal(1, this, new BackflipGoal()));
        this.f_21345_.m_25352_(5, (Goal)new ShootGoal(this.m_21133_(Attributes.f_22279_), 15, 30, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_DAMAGE, 12, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 20, INSTRUCTION_SHURIKEN, this::handleDelayCallback));
        this.isActing = true;
        this.throwingShuriken = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    private void throwBolo(LivingEntity target, float distanceFactor) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BOLO, 17, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 22, INSTRUCTION_BOLO, this::handleDelayCallback));
        this.isActing = true;
        this.throwingBolo = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    private void throwSmokeBomb() {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_SMOKEBOMB, 28, (LivingEntity)this, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 30, INSTRUCTION_SMOKEBOMB, this::handleDelayCallback));
        this.isActing = true;
        this.smokeBomb = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    private void doBackflip() {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BACKFLIP, 31, (LivingEntity)this, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 32, INSTRUCTION_BACKFLIP, this::handleDelayCallback));
        this.isActing = true;
        this.backflipping = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean spawnShuriken(Entity target) {
        Vec3 direction = target == this ? Vec3.m_82503_((Vec2)this.m_20155_()).m_82541_() : target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() * 0.5f), 0.0).m_82546_(this.m_20182_()).m_82541_();
        SkeletonAssassinShuriken shuriken = new SkeletonAssassinShuriken(this.m_9236_(), (LivingEntity)this);
        shuriken.m_5602_((Entity)this);
        shuriken.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.6f, 0.0f);
        this.m_9236_().m_7967_((Entity)shuriken);
        this.m_5496_(SFX.Entity.SkeletonAssassin.SHURIKEN_THROW, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public boolean spawnBolo(Entity target) {
        Vec3 direction = target.m_20182_().m_82549_(target.m_20184_()).m_82520_(0.0, (double)(target.m_20206_() * 0.5f), 0.0).m_82546_(this.m_20182_()).m_82541_();
        SkeletonAssassinBolo bolo = new SkeletonAssassinBolo(this.m_9236_(), (LivingEntity)this);
        bolo.m_5602_((Entity)this);
        bolo.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.5f, 0.0f);
        this.m_9236_().m_7967_((Entity)bolo);
        this.m_5496_(SFX.Entity.SkeletonAssassin.BOLO_THROW, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12381_;
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.isActing) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 10, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 20, INSTRUCTION_MELEE, this::handleDelayCallback));
        this.isActing = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.backflipping && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286973_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268444_)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        if (this.m_5448_() == null) {
            return false;
        }
        double dist = this.m_20280_((Entity)this.m_5448_());
        if (dist > 9.0) {
            return false;
        }
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
            if (this.m_20145_() || ((LivingEntity)entityIn).m_21023_(MobEffects.f_19610_)) {
                if (!((LivingEntity)entityIn).m_21023_((MobEffect)EffectInit.ELDRIN_SIGHT.get())) {
                    f *= (float)(this.getTier() + 2);
                }
                this.m_21195_(MobEffects.f_19609_);
            }
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0 || this.m_6060_()) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity = (Player)entityIn;
                this.m_21424_(playerentity, this.m_21205_(), playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
        }
        return flag;
    }

    private void m_21424_(Player p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.m_41619_() && !p_233655_3_.m_41619_() && p_233655_2_.m_41720_() instanceof AxeItem && p_233655_3_.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_233655_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                switch (identifier) {
                    case "damage": {
                        if (this.throwingShuriken) {
                            this.spawnShuriken(entity);
                            break;
                        }
                        this.damageEntity(entity);
                        break;
                    }
                    case "bolo": {
                        this.spawnBolo(entity);
                        this.boloCooldown = 300;
                        break;
                    }
                    case "smokebomb": {
                        this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200));
                        this.m_5496_(SFX.Entity.SkeletonAssassin.SMOKE_BOMB, 1.0f, (float)(0.8 + Math.random() * 0.2));
                        this.smokeBombCooldown = 1200;
                        break;
                    }
                    case "backflip": {
                        this.backflipCooldown = 200;
                    }
                }
            } else {
                switch (identifier) {
                    case "smokebomb": {
                        for (int i = 0; i < 50; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() - 0.25 + Math.random() * 0.5, this.m_20186_() + Math.random() * 2.0, this.m_20189_() - 0.25 + Math.random() * 0.5, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            boolean wasFlipping = this.backflipping;
            switch (data) {
                case "shuriken": {
                    this.throwingShuriken = false;
                    break;
                }
                case "bolo": {
                    this.throwingBolo = false;
                    break;
                }
                case "smokebomb": {
                    this.smokeBomb = false;
                    break;
                }
                case "backflip": {
                    this.backflipping = false;
                }
            }
            boolean bl = this.isActing = this.throwingShuriken || this.throwingBolo || this.smokeBomb || this.backflipping;
            if (!this.backflipping && wasFlipping) {
                this.instantTransition = true;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isActing);
        nbt.m_128379_(INSTRUCTION_SHURIKEN, this.throwingShuriken);
        nbt.m_128379_(INSTRUCTION_BOLO, this.throwingBolo);
        nbt.m_128379_("smoke", this.smokeBomb);
        nbt.m_128379_(INSTRUCTION_BACKFLIP, this.backflipping);
        nbt.m_128379_("instant", this.instantTransition);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isActing = nbt.m_128471_("attacking");
        this.throwingShuriken = nbt.m_128471_(INSTRUCTION_SHURIKEN);
        this.throwingBolo = nbt.m_128471_(INSTRUCTION_BOLO);
        this.smokeBomb = nbt.m_128471_("smoke");
        this.backflipping = nbt.m_128471_(INSTRUCTION_BACKFLIP);
        this.instantTransition = nbt.m_128471_("instant");
        if (this.smokeBomb) {
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_SMOKEBOMB, 22, (LivingEntity)this, this::handleDelayCallback));
        }
    }

    public class SmokeBombGoal
    extends Goal {
        public SmokeBombGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return SkeletonAssassin.this.m_5448_() != null && !SkeletonAssassin.this.isActing && SkeletonAssassin.this.smokeBombCooldown == 0;
        }

        public boolean m_8045_() {
            return SkeletonAssassin.this.isActing && SkeletonAssassin.this.throwingBolo;
        }

        public void m_8056_() {
            SkeletonAssassin.this.throwSmokeBomb();
        }
    }

    public class BoloGoal
    extends Goal {
        private int rangedAttackTime = -1;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public BoloGoal(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public BoloGoal(RangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (SkeletonAssassin.this.isActing || SkeletonAssassin.this.boloCooldown > 0) {
                return false;
            }
            LivingEntity livingentity = SkeletonAssassin.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && livingentity.m_20186_() > SkeletonAssassin.this.m_20186_() + 2.0 && (livingentity.f_19812_ || !livingentity.m_20096_() || livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35935_);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !SkeletonAssassin.this.m_21573_().m_26577_();
        }

        public void m_8041_() {
            this.rangedAttackTime = -1;
        }

        public void m_8037_() {
            LivingEntity e = SkeletonAssassin.this.m_5448_();
            if (e == null) {
                return;
            }
            double distance = SkeletonAssassin.this.m_20275_(e.m_20185_(), e.m_20186_(), e.m_20189_());
            boolean canSeeTarget = SkeletonAssassin.this.m_21574_().m_148306_((Entity)e);
            if (distance <= (double)this.maxAttackDistance && canSeeTarget) {
                SkeletonAssassin.this.m_21573_().m_26573_();
            } else {
                SkeletonAssassin.this.m_21573_().m_5624_((Entity)e, SkeletonAssassin.this.m_21133_(Attributes.f_22279_));
            }
            SkeletonAssassin.this.m_21563_().m_24960_((Entity)e, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!canSeeTarget) {
                    return;
                }
                float f = Mth.m_14116_((float)((float)distance)) / this.attackRadius;
                float lvt_5_1_ = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                SkeletonAssassin.this.throwBolo(e, lvt_5_1_);
                this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = Mth.m_14116_((float)((float)distance)) / this.attackRadius;
                this.rangedAttackTime = Mth.m_14143_((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }

    public class BackflipGoal
    extends Goal {
        private Vector3 start;
        private Vector3 end;
        private int tick_count;
        private float move_time = 31.0f;

        public boolean m_8036_() {
            if (SkeletonAssassin.this.m_20145_()) {
                return false;
            }
            LivingEntity target = SkeletonAssassin.this.m_5448_();
            if (target != null && !SkeletonAssassin.this.isActing && SkeletonAssassin.this.backflipCooldown == 0) {
                double dist = SkeletonAssassin.this.m_20280_((Entity)target);
                if (dist > 9.0) {
                    return false;
                }
                Vec3 startPos = SkeletonAssassin.this.m_20182_().m_82520_(0.0, 0.5, 0.0);
                Vec3 delta = startPos.m_82546_(target.m_20182_().m_82520_(0.0, 0.5, 0.0)).m_82541_();
                delta = new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
                float searchDist = 20.0f;
                Vec3 endPos = startPos.m_82549_(delta.m_82490_((double)searchDist));
                BlockPos bp = BlockPos.m_274446_((Position)endPos);
                int vCount = 0;
                int count = 0;
                int vSearch = 5;
                int tSearch = 50;
                while (!SkeletonAssassin.this.m_9236_().m_8055_(bp).m_60812_((BlockGetter)SkeletonAssassin.this.m_9236_(), bp).m_83281_() && count < tSearch && searchDist > 10.0f) {
                    ++count;
                    if (++vCount == vSearch) {
                        vCount = 0;
                        endPos = startPos.m_82549_(delta.m_82490_((double)(searchDist -= 1.0f)));
                    } else {
                        endPos = endPos.m_82520_(0.0, 1.0, 0.0);
                    }
                    bp = BlockPos.m_274446_((Position)endPos);
                }
                if (count >= tSearch) {
                    return false;
                }
                ClipContext ctx = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)SkeletonAssassin.this);
                BlockHitResult brtr = SkeletonAssassin.this.m_9236_().m_45547_(ctx);
                if (brtr.m_6662_() == HitResult.Type.MISS) {
                    this.start = new Vector3(SkeletonAssassin.this.m_20182_());
                    this.end = new Vector3(endPos.m_82492_(0.0, 0.5, 0.0));
                } else {
                    this.start = new Vector3(SkeletonAssassin.this.m_20182_());
                    this.end = new Vector3(brtr.m_82450_().m_82549_(delta));
                }
                return this.start != null && this.end != null && !(this.start.distanceSqTo(this.end) < 5.0);
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            SkeletonAssassin.this.doBackflip();
        }

        public boolean m_8045_() {
            return SkeletonAssassin.this.isActing && SkeletonAssassin.this.backflipping;
        }

        public void m_8041_() {
            super.m_8041_();
            this.start = null;
            this.end = null;
            this.tick_count = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8037_() {
            ++this.tick_count;
            if ((float)this.tick_count <= this.move_time) {
                Vector3 interp_pos = Vector3.lerp(this.start, this.end, (float)this.tick_count / this.move_time);
                SkeletonAssassin.this.m_6034_(interp_pos.x, interp_pos.y, interp_pos.z);
                SkeletonAssassin.this.m_6853_(true);
            }
        }
    }

    public class ShootGoal
    extends Goal {
        private final double speedModifier;
        private int attackIntervalMin;
        private int attackIntervalMax;
        private final float attackRadiusSqr;
        private int attackTime = -1;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public ShootGoal(double pSpeedModifier, int pAttackIntervalMin, int attackIntervalMax, float pAttackRadius) {
            this.speedModifier = pSpeedModifier;
            this.attackIntervalMin = pAttackIntervalMin;
            this.attackIntervalMax = attackIntervalMax;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (SkeletonAssassin.this.backflipping) {
                this.attackTime = -1;
                return false;
            }
            if (SkeletonAssassin.this.throwingBolo || SkeletonAssassin.this.m_20145_() || SkeletonAssassin.this.smokeBomb) {
                return false;
            }
            LivingEntity livingentity = SkeletonAssassin.this.m_5448_();
            return livingentity != null && !livingentity.m_21224_();
        }

        public boolean m_8045_() {
            if (!this.m_8036_()) {
                return false;
            }
            return !SkeletonAssassin.this.m_21573_().m_26571_();
        }

        public void m_8041_() {
            SkeletonAssassin.this.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = SkeletonAssassin.this.m_5448_();
            if (livingentity != null) {
                double distance = SkeletonAssassin.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean hasLineOfSight = SkeletonAssassin.this.m_21574_().m_148306_((Entity)livingentity);
                if (!SkeletonAssassin.this.isActing) {
                    if (distance <= (double)this.attackRadiusSqr && hasLineOfSight) {
                        SkeletonAssassin.this.m_21573_().m_26573_();
                        ++this.strafingTime;
                    } else {
                        SkeletonAssassin.this.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                        this.strafingTime = -1;
                    }
                    if (this.strafingTime >= 40) {
                        if ((double)SkeletonAssassin.this.m_217043_().m_188501_() < 0.3) {
                            boolean bl = this.strafingClockwise = !this.strafingClockwise;
                        }
                        if ((double)SkeletonAssassin.this.m_217043_().m_188501_() < 0.3) {
                            this.strafingBackwards = !this.strafingBackwards;
                        }
                        this.strafingTime = 0;
                    }
                    if (this.strafingTime > -1) {
                        if (distance > (double)(this.attackRadiusSqr * 0.75f)) {
                            this.strafingBackwards = false;
                        } else if (distance < (double)(this.attackRadiusSqr * 0.25f)) {
                            this.strafingBackwards = true;
                        }
                        SkeletonAssassin.this.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                        Entity entity = SkeletonAssassin.this.m_275832_();
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                        }
                    }
                } else {
                    SkeletonAssassin.this.m_21573_().m_26573_();
                }
                SkeletonAssassin.this.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                SkeletonAssassin.this.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                --this.attackTime;
                if (this.attackTime <= 0) {
                    if (!hasLineOfSight) {
                        return;
                    }
                    SkeletonAssassin.this.m_6504_(livingentity, 0.0f);
                    this.attackTime = this.attackIntervalMax - this.attackIntervalMin + this.attackIntervalMin;
                }
            }
        }
    }
}

