/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction.base;

import com.google.common.collect.Maps;
import com.mna.api.entities.IFactionEnemy;
import com.mna.effects.EffectInit;
import com.mna.entities.IAnimPacketSync;
import com.mna.entities.ai.RetaliateOnAttackGoal;
import com.mna.tools.SummonUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BaseFlyingFactionMob<T extends BaseFlyingFactionMob<?>>
extends FlyingMob
implements Enemy,
IFactionEnemy<T>,
GeoEntity,
IAnimPacketSync<T>,
IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<OptionalInt> TARGET_ID = SynchedEntityData.m_135353_(BaseFlyingFactionMob.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Integer> DATA_STATE = SynchedEntityData.m_135353_(BaseFlyingFactionMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final int RANDOM_FLY_ID = 999;
    protected Player raidTarget;
    protected int tier;
    protected HashMap<String, Integer> damageResists;
    protected AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected LivingEntity localTarget;
    protected int randomFlyCooldown = 0;
    protected boolean disableFlyAway = false;
    private final Map<String, Tuple<MutableInt, Runnable>> timers = Maps.newHashMap();
    private final Map<Integer, Integer> cooldowns = Maps.newHashMap();

    protected BaseFlyingFactionMob(EntityType<T> mobType, Level world) {
        super(mobType, world);
        this.m_20242_(true);
        this.f_21342_ = new MoveHelperController(this);
        this.damageResists = new HashMap();
    }

    protected void setTimer(String id, int delay, Runnable callback) {
        this.setTimer(id, delay, callback, true);
    }

    protected void setTimer(String id, int delay, Runnable callback, boolean runIfExists) {
        if (runIfExists && this.timers.containsKey(id)) {
            ((Runnable)this.timers.get(id).m_14419_()).run();
        }
        this.timers.put(id, (Tuple<MutableInt, Runnable>)new Tuple((Object)new MutableInt(delay), (Object)callback));
    }

    protected void setCooldown(int id, int ticks) {
        this.cooldowns.put(id, ticks);
    }

    protected boolean isOnCooldown(int id) {
        return this.cooldowns.getOrDefault(id, 0) > 0;
    }

    protected int getStateFlag() {
        return (Integer)this.f_19804_.m_135370_(DATA_STATE);
    }

    protected void setState(int ... flags) {
        int finalFlag = 0;
        for (int i : flags) {
            finalFlag |= i;
        }
        this.f_19804_.m_135381_(DATA_STATE, (Object)finalFlag);
    }

    public void m_8119_() {
        Vec3 wanted;
        if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
            this.m_21563_().m_148051_((Entity)this.m_5448_());
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_5448_().m_146892_());
        } else if (this.m_20184_().m_82553_() > (double)0.1f) {
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(this.m_20184_().m_82541_().m_82490_(30.0)));
        }
        if (this.m_21023_((MobEffect)EffectInit.GRAVITY_WELL.get())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2, 0.0));
        }
        this.cooldowns.keySet().forEach(c -> {
            int cd = this.cooldowns.get(c);
            if (cd > 0) {
                this.cooldowns.put((Integer)c, cd - 1);
            }
        });
        ArrayList timersToRemove = new ArrayList();
        this.timers.forEach((k, v) -> {
            ((MutableInt)this.timers.get(k).m_14418_()).subtract(1);
            if (((MutableInt)this.timers.get(k).m_14418_()).getValue() <= 0) {
                timersToRemove.add(k);
            }
        });
        timersToRemove.forEach(id -> {
            ((Runnable)this.timers.get(id).m_14419_()).run();
            this.timers.remove(id);
        });
        if (this.randomFlyCooldown > 0 && this.isOnCooldown(999) && this.m_20184_().m_82553_() > 0.0 && this.m_20238_(wanted = new Vec3(this.m_21566_().m_25000_(), this.m_21566_().m_25001_(), this.m_21566_().m_25002_())) < 1.0) {
            this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0);
            this.m_20256_(Vec3.f_82478_);
        }
        super.m_8119_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ID, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_STATE, (Object)0);
    }

    public void m_6710_(LivingEntity pLivingEntity) {
        super.m_6710_(pLivingEntity);
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(TARGET_ID, (Object)(pLivingEntity != null ? OptionalInt.of(pLivingEntity.m_19879_()) : OptionalInt.empty()));
        }
    }

    public LivingEntity m_5448_() {
        Entity e;
        if (!this.m_9236_().m_5776_()) {
            return super.m_5448_();
        }
        OptionalInt targetId = (OptionalInt)this.f_19804_.m_135370_(TARGET_ID);
        if (!targetId.isPresent()) {
            return null;
        }
        if ((this.localTarget == null || this.localTarget.m_19879_() != targetId.getAsInt()) && (e = this.m_9236_().m_6815_(targetId.getAsInt())) instanceof LivingEntity) {
            this.localTarget = (LivingEntity)e;
        }
        return this.localTarget;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new BaseFlyingFactionMobFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new RetaliateOnAttackGoal((Mob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction() && e.m_6084_()));
    }

    public float getStepHeight() {
        return 1.2f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.applyInitialSpawnTier((LevelAccessor)worldIn);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> this.handleAnimState(state));
        this.addControllerListeners(controller);
        registrar.add(new AnimationController[]{controller});
    }

    protected void addControllerListeners(AnimationController<T> controller) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    @Override
    public void setRaidTarget(Player player) {
        this.raidTarget = player;
        this.m_6710_((LivingEntity)player);
    }

    @Override
    public Player getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("tier_health_bonus", (double)(tier + 1), AttributeModifier.Operation.MULTIPLY_BASE));
        this.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier("tier_armor_bonus", (double)(5 * tier), AttributeModifier.Operation.ADDITION));
        this.m_21153_(this.m_21233_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeFactionData(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readFactionData(compound);
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return this.damageResists;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268549_)) {
            return false;
        }
        amount = this.applyDamageResists(source, amount);
        return super.m_6469_(source, amount);
    }

    public void m_6043_() {
        super.m_6043_();
        this.raidTargetDespawn();
        if (this.m_9236_() != null && !this.m_9236_().m_5776_() && this.m_9236_().m_7654_() != null && this.m_9236_().m_7654_().m_129910_().m_5472_() == Difficulty.PEACEFUL) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.onKilled(cause);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.tier = additionalData.readInt();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.tier);
    }

    protected abstract PlayState handleAnimState(AnimationState<? extends BaseFlyingFactionMob<?>> var1);

    protected float keepDistanceFromAttackTarget() {
        return 10.0f;
    }

    protected float heightAboveAttackTarget() {
        return 3.0f;
    }

    protected float attackTargetRunawayThreshold() {
        return 0.0f;
    }

    protected float attackTargetRunawayDistance() {
        return 0.0f;
    }

    protected boolean canFlyInWater() {
        return false;
    }

    static class MoveHelperController
    extends MoveControl {
        private final BaseFlyingFactionMob<?> parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(BaseFlyingFactionMob<?> parent) {
            super(parent);
            this.parentEntity = parent;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.isCollided(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean isCollided(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(p_220673_1_);
                if (this.parentEntity.m_9236_().m_45756_(this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    static class BaseFlyingFactionMobFlyGoal
    extends Goal {
        private final BaseFlyingFactionMob<?> parentEntity;

        public BaseFlyingFactionMobFlyGoal(BaseFlyingFactionMob<?> parent) {
            this.parentEntity = parent;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return !this.parentEntity.isOnCooldown(999);
            }
            if (this.parentEntity.m_5448_() == null) {
                double d2;
                double d1;
                if (this.parentEntity.isOnCooldown(999)) {
                    return false;
                }
                double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
                double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
                return d3 < 4.0 || d3 > 3600.0;
            }
            double dist = this.parentEntity.m_5448_().m_20280_(this.parentEntity);
            return !this.parentEntity.m_21574_().m_148306_((Entity)this.parentEntity.m_5448_()) || dist > 25.0 || dist < 4.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (this.parentEntity.m_5448_() == null) {
                LivingEntity summoner;
                boolean setRandom = true;
                if (SummonUtils.isSummon(this.parentEntity) && (summoner = SummonUtils.getSummoner(this.parentEntity)) != null && summoner.m_20270_(this.parentEntity) > 16.0f) {
                    setRandom = false;
                    this.parentEntity.m_21566_().m_6849_(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_(), this.parentEntity.m_21133_(Attributes.f_22279_));
                }
                if (setRandom) {
                    RandomSource random = this.parentEntity.m_217043_();
                    double d0 = this.parentEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                    double d1 = this.parentEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.parentEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                    int count = 0;
                    int y = (int)d1;
                    boolean ground = false;
                    while (count < 16) {
                        BlockPos bpTestPos = BlockPos.m_274561_((double)d0, (double)y, (double)d2);
                        if (this.parentEntity.m_9236_().m_46859_(bpTestPos)) {
                            ++count;
                            --y;
                            continue;
                        }
                        if (this.parentEntity.m_9236_().m_46801_(bpTestPos)) {
                            ++count;
                            if (!this.parentEntity.canFlyInWater()) {
                                ++y;
                            }
                            ground = true;
                            continue;
                        }
                        ground = true;
                        break;
                    }
                    if (!ground) {
                        d1 -= 16.0;
                    }
                    this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
                    if (this.parentEntity.randomFlyCooldown > 0) {
                        this.parentEntity.setCooldown(999, this.parentEntity.randomFlyCooldown);
                    }
                }
            } else if (!this.parentEntity.disableFlyAway) {
                Vec3 direction = this.parentEntity.m_20182_().m_82546_(this.parentEntity.m_5448_().m_20182_()).m_82541_();
                direction = direction.m_82520_(0.0, -direction.f_82480_, 0.0);
                Vec3 offset = direction.m_82490_((double)this.parentEntity.keepDistanceFromAttackTarget());
                Vec3 target = this.parentEntity.m_5448_().m_20182_().m_82549_(offset);
                if (this.parentEntity.m_5448_().m_20096_()) {
                    target = target.m_82520_(0.0, (double)this.parentEntity.heightAboveAttackTarget(), 0.0);
                }
                Vec3 vec3 = new Vec3(target.f_82479_, 0.0, target.f_82481_);
                Vec3 vec32 = new Vec3(this.parentEntity.m_5448_().m_20185_(), 0.0, this.parentEntity.m_5448_().m_20189_());
                if (vec3.m_82554_(vec32) < (double)this.parentEntity.attackTargetRunawayThreshold()) {
                    float dist = this.parentEntity.attackTargetRunawayDistance();
                    target = target.m_82520_(Math.random() * (double)dist / 2.0 - (double)dist, 0.0, Math.random() * (double)dist / 2.0 - (double)dist);
                }
                this.parentEntity.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
            }
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final BaseFlyingFactionMob<?> parentEntity;

        public LookAroundGoal(BaseFlyingFactionMob<?> parent) {
            this.parentEntity = parent;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 vector3d = this.parentEntity.m_20184_();
                this.parentEntity.m_146926_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
                this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
            } else {
                LivingEntity livingentity = this.parentEntity.m_5448_();
                if (livingentity.m_20280_(this.parentEntity) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.parentEntity.m_20185_();
                    double d2 = livingentity.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
        }
    }
}

