/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.manaweaving;

import com.mna.Registries;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.blocks.IManaweaveNotifiable;
import com.mna.api.cantrips.ICantrip;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.events.EventDispatcher;
import com.mna.items.ItemInit;
import com.mna.items.manaweaving.ItemManaweaveBottle;
import com.mna.network.ServerMessageDispatcher;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mna.tools.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;

public class Manaweave
extends Entity {
    private static final int MAX_AGE = 200;
    private static final EntityDataAccessor<CompoundTag> PATTERNS = SynchedEntityData.m_135353_(Manaweave.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Integer> CASTER_ID = SynchedEntityData.m_135353_(Manaweave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_PLAYER_ID = SynchedEntityData.m_135353_(Manaweave.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CASTER_TIER = SynchedEntityData.m_135353_(Manaweave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> CASTER_FACTION_ID = SynchedEntityData.m_135353_(Manaweave.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String NBT_ENTITY_AGE = "entity_age";
    private static final String NBT_PATTERN = "patterns";
    private static final String NBT_CASTER_ID = "caster_id";
    private static final String NBT_CASTER_UUID = "caster_uuid";
    private static final String NBT_CASTER_TIER = "caster_tier";
    private static final String NBT_CASTER_FACTION = "caster_faction";
    private static final String MANUALLY_DRAWN = "manually_drawn";
    private static final String MANA_REFUNDED = "mana_refunded";
    private static final String NBT_HAND = "hand";
    int age = 0;
    boolean isMerging = false;
    private ArrayList<IManaweavePattern> cachedPatterns;
    private InteractionHand hand;
    private boolean manuallyDrawn = false;
    private float manaRefunded = 0.0f;

    public Manaweave(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public Manaweave(Level world) {
        this((EntityType<? extends Entity>)((EntityType)EntityInit.MANAWEAVE_ENTITY.get()), world);
    }

    public void m_8119_() {
        if (!(this.getPatterns() != null && this.getPatterns().size() != 0 || this.m_9236_().m_5776_())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.age == 0 && !this.m_9236_().m_5776_() && !this.notifyNearbyBlocksAltars()) {
            this.mergeWithNearby(this.hand);
        }
        ++this.age;
        if (this.age >= 200 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void onRemovedFromWorld() {
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 50; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), -0.25 + Math.random() * 0.5, -0.25 + Math.random() * 0.5, -0.25 + Math.random() * 0.5);
            }
        }
        super.onRemovedFromWorld();
    }

    public void onAddedToWorld() {
        LivingEntity caster;
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_() && (caster = this.getCaster()) != null && caster instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)caster;
            if (this.getPatterns().size() == 1) {
                CustomAdvancementTriggers.DRAW_MANAWEAVE.trigger(player, this.getPatterns().get(0).getRegistryId());
            }
        }
    }

    public boolean isMerging() {
        return this.isMerging;
    }

    public void setMerging(boolean merging) {
        this.isMerging = merging;
    }

    public float getManaReturn(Player player) {
        if (this.manuallyDrawn) {
            return this.manaRefunded;
        }
        return 0.0f;
    }

    public boolean m_6097_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void setPattern(ResourceLocation pattern) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("count", 0);
        nbt.m_128359_("index_0", pattern.toString());
        this.f_19804_.m_135381_(PATTERNS, (Object)nbt);
        this.cachedPatterns = null;
    }

    public void addPattern(ResourceLocation pattern) {
        CompoundTag nbt = ((CompoundTag)this.f_19804_.m_135370_(PATTERNS)).m_6426_();
        int count = nbt.m_128451_("count") + 1;
        nbt.m_128405_("count", count);
        nbt.m_128359_("index_" + count, pattern.toString());
        this.f_19804_.m_135381_(PATTERNS, (Object)nbt);
        this.cachedPatterns = null;
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity e;
        Level level;
        Optional casterUUID = (Optional)this.f_19804_.m_135370_(CASTER_PLAYER_ID);
        if (casterUUID.isPresent() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Player serverPlayer = serverLevel.m_46003_((UUID)casterUUID.get());
            if (serverPlayer != null) {
                return serverPlayer;
            }
            FakePlayer fakePlayer = EntityUtil.getFakePlayer(serverLevel, (UUID)casterUUID.get());
            IPlayerProgression p = (IPlayerProgression)fakePlayer.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (p != null) {
                p.setTier((Integer)this.f_19804_.m_135370_(CASTER_TIER), null);
                IFaction faction = (IFaction)Registries.Factions.get().getValue(new ResourceLocation((String)this.f_19804_.m_135370_(CASTER_FACTION_ID)));
                p.setAlliedFaction(faction, null);
            }
            return fakePlayer;
        }
        int id = (Integer)this.f_19804_.m_135370_(CASTER_ID);
        if (id > -1 && (e = this.m_9236_().m_6815_(id)) instanceof LivingEntity) {
            return (LivingEntity)e;
        }
        return null;
    }

    public void setCaster(LivingEntity caster, InteractionHand hand) {
        if (caster != null) {
            this.f_19804_.m_135381_(CASTER_ID, (Object)caster.m_19879_());
            this.hand = hand;
            if (caster instanceof Player) {
                Player player = (Player)caster;
                this.f_19804_.m_135381_(CASTER_PLAYER_ID, Optional.of(player.m_36316_().getId()));
                IPlayerProgression p = (IPlayerProgression)caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                if (p != null) {
                    this.f_19804_.m_135381_(CASTER_TIER, (Object)p.getTier());
                    if (p.hasAlliedFaction()) {
                        this.f_19804_.m_135381_(CASTER_FACTION_ID, (Object)Registries.Factions.get().getKey((Object)p.getAlliedFaction()).toString());
                    }
                }
            } else {
                this.f_19804_.m_135381_(CASTER_PLAYER_ID, Optional.empty());
            }
        }
    }

    public void setManuallyDrawn() {
        this.manuallyDrawn = true;
    }

    public void setManaRefunded(int drawTicks) {
        this.manaRefunded = (float)drawTicks * 1.0f;
    }

    public void mergeWith(Manaweave other) {
        ArrayList<IManaweavePattern> otherPatterns = other.getPatterns();
        for (int i = otherPatterns.size() - 1; i >= 0; --i) {
            this.addPattern(otherPatterns.get(i).getRegistryId());
        }
        this.manuallyDrawn |= other.manuallyDrawn;
        this.manaRefunded += other.manaRefunded;
        other.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void mergeWithNearby(InteractionHand hand) {
        if (this.getCaster() == null) {
            return;
        }
        List mws = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(2.0), e -> e instanceof Manaweave && ((Manaweave)((Object)e)).getCaster() == this.getCaster());
        for (Entity e2 : mws) {
            this.mergeWith((Manaweave)e2);
        }
        if (this.getPatterns().size() > 1) {
            this.checkMergeRecipe(hand);
        }
    }

    private void checkMergeRecipe(InteractionHand hand) {
        LivingEntity caster = this.getCaster();
        if (caster == null || !(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return;
        }
        if (caster.m_20280_((Entity)this) > 25.0) {
            return;
        }
        ICantrip cantrip = magic.getCantripData().matchAndCastCantrip(player, hand, this.getPatterns().stream().map(r -> (Recipe)r).collect(Collectors.toList()));
        if (cantrip != null) {
            EventDispatcher.DispatchCantripCast(cantrip, player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerMessageDispatcher.sendCantripTimerMessage(cantrip.getId().toString(), cantrip.getDelay(), serverPlayer);
                CustomAdvancementTriggers.CANTRIP_CAST.trigger(serverPlayer, cantrip.getId(), cantrip.getTier());
            }
            if (cantrip.getSound() != null) {
                this.m_9236_().m_5594_(null, this.m_20183_(), cantrip.getSound(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nullable
    public ArrayList<IManaweavePattern> getPatterns() {
        CompoundTag nbt;
        if (this.cachedPatterns == null && (nbt = (CompoundTag)this.f_19804_.m_135370_(PATTERNS)).m_128441_("count")) {
            this.cachedPatterns = new ArrayList();
            int count = nbt.m_128451_("count");
            for (int i = 0; i <= count; ++i) {
                String key = "index_" + i;
                if (!nbt.m_128441_(key)) continue;
                String rLoc = nbt.m_128461_(key);
                ManaweavingPattern mwp = ManaweavingPatternHelper.GetManaweavingRecipe(this.m_9236_(), new ResourceLocation(rLoc));
                if (mwp == null) continue;
                this.cachedPatterns.add(0, mwp);
            }
        }
        return this.cachedPatterns;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == Items.f_42590_ && this.getPatterns().size() == 1) {
            if (!this.m_9236_().m_5776_()) {
                ItemStack captureStack = new ItemStack((ItemLike)ItemInit.MANAWEAVE_BOTTLE.get());
                ItemManaweaveBottle.setPattern(this.getPatterns().get(0), captureStack);
                player.m_21120_(hand).m_41774_(1);
                if (!player.m_36356_(captureStack)) {
                    player.m_19983_(captureStack);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PATTERNS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(CASTER_ID, (Object)-1);
        this.f_19804_.m_135372_(CASTER_PLAYER_ID, Optional.empty());
        this.f_19804_.m_135372_(CASTER_TIER, (Object)0);
        this.f_19804_.m_135372_(CASTER_FACTION_ID, (Object)"mna:none");
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(NBT_ENTITY_AGE)) {
            this.age = compound.m_128451_(NBT_ENTITY_AGE);
        }
        if (compound.m_128441_(NBT_PATTERN)) {
            this.f_19804_.m_135381_(PATTERNS, (Object)((CompoundTag)compound.m_128423_(NBT_PATTERN)));
        }
        if (compound.m_128441_(NBT_CASTER_ID)) {
            this.f_19804_.m_135381_(CASTER_ID, (Object)compound.m_128451_(NBT_CASTER_ID));
        }
        if (compound.m_128441_(NBT_HAND)) {
            this.hand = InteractionHand.values()[compound.m_128451_(NBT_HAND)];
        }
        if (compound.m_128441_(MANUALLY_DRAWN)) {
            this.manuallyDrawn = compound.m_128471_(MANUALLY_DRAWN);
        }
        if (compound.m_128441_(MANA_REFUNDED)) {
            this.manaRefunded = compound.m_128457_(MANA_REFUNDED);
        }
        if (compound.m_128441_(NBT_CASTER_UUID)) {
            this.f_19804_.m_135381_(CASTER_PLAYER_ID, Optional.of(compound.m_128342_(NBT_CASTER_UUID)));
        }
        if (compound.m_128441_(NBT_CASTER_TIER)) {
            this.f_19804_.m_135381_(CASTER_TIER, (Object)compound.m_128451_(NBT_CASTER_TIER));
        }
        if (compound.m_128441_(NBT_CASTER_FACTION)) {
            this.f_19804_.m_135381_(CASTER_FACTION_ID, (Object)compound.m_128461_(NBT_CASTER_FACTION));
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_(NBT_ENTITY_AGE, this.age);
        compound.m_128365_(NBT_PATTERN, (Tag)this.f_19804_.m_135370_(PATTERNS));
        compound.m_128405_(NBT_CASTER_ID, ((Integer)this.f_19804_.m_135370_(CASTER_ID)).intValue());
        compound.m_128405_(NBT_HAND, this.hand != null ? this.hand.ordinal() : 0);
        compound.m_128379_(MANUALLY_DRAWN, this.manuallyDrawn);
        compound.m_128350_(MANA_REFUNDED, this.manaRefunded);
        compound.m_128405_(NBT_CASTER_TIER, ((Integer)this.f_19804_.m_135370_(CASTER_TIER)).intValue());
        compound.m_128359_(NBT_CASTER_FACTION, (String)this.f_19804_.m_135370_(CASTER_FACTION_ID));
        Optional casterUUID = (Optional)this.f_19804_.m_135370_(CASTER_PLAYER_ID);
        if (casterUUID.isPresent()) {
            compound.m_128362_(NBT_CASTER_UUID, (UUID)casterUUID.get());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getAge() {
        return this.age;
    }

    private boolean notifyNearbyBlocksAltars() {
        ArrayList<IManaweavePattern> p = this.getPatterns();
        if (p == null || p.size() != 1) {
            return false;
        }
        LivingEntity caster = this.getCaster();
        BlockPos me = this.m_20183_();
        int radius = 3;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    IManaweaveNotifiable notifiable;
                    IManaweaveNotifiable notifiable2;
                    BlockPos test = me.m_7918_(i, j, k);
                    BlockState state = this.m_9236_().m_8055_(test);
                    Block block = state.m_60734_();
                    if (block instanceof IManaweaveNotifiable && (notifiable2 = (IManaweaveNotifiable)block).notify(this.m_9236_(), test, state, p, caster)) {
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                        return true;
                    }
                    BlockEntity be = this.m_9236_().m_7702_(test);
                    if (be == null || !(be instanceof IManaweaveNotifiable) || !(notifiable = (IManaweaveNotifiable)be).notify(this.m_9236_(), test, state, p, caster)) continue;
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return true;
                }
            }
        }
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key == PATTERNS) {
            this.cachedPatterns = null;
        }
        super.m_7350_(key);
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }
}

