/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public abstract class MAGeckoRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    protected boolean invisible;
    protected boolean hasEmissivePass = false;
    protected boolean emissivePass = false;

    protected MAGeckoRenderer(EntityRendererProvider.Context context, GeoModel<T> modelProvider) {
        super(context, modelProvider);
    }

    public MAGeckoRenderer<T> enableEmissive() {
        this.hasEmissivePass = true;
        return this;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            float curScale = entity.getPersistentData().m_128457_("mna_entity_scale");
            float prevScale = entity.getPersistentData().m_128457_("mna_entity_scale_prev");
            float scale = curScale + (curScale - prevScale) * partialTicks;
            if (!entity.isAddedToWorld()) {
                scale = 1.0f;
            }
            stack.m_85836_();
            stack.m_85841_(scale, scale, scale);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invisible = entity.m_20145_();
        super.m_7392_(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        try {
            stack.m_85849_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void defaultRender(PoseStack poseStack, T animatable, MultiBufferSource bufferSource, RenderType renderType, VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        Color renderColor = this.getRenderColor((GeoAnimatable)animatable, partialTick, packedLight);
        float red = renderColor.getRedFloat();
        float green = renderColor.getGreenFloat();
        float blue = renderColor.getBlueFloat();
        float alpha = renderColor.getAlphaFloat();
        int packedOverlay = this.getPackedOverlay((Entity)animatable, 0.0f);
        BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable));
        this.renderPass(poseStack, animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight, false, model, red, green, blue, alpha, packedOverlay);
        if (this.hasEmissivePass) {
            this.renderPass(poseStack, animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight, true, model, red, green, blue, alpha, packedOverlay);
        }
    }

    private void renderPass(PoseStack poseStack, T animatable, MultiBufferSource bufferSource, RenderType renderType, VertexConsumer buffer, float yaw, float partialTick, int packedLight, boolean emissive, BakedGeoModel model, float red, float green, float blue, float alpha, int packedOverlay) {
        this.emissivePass = emissive;
        if (renderType == null) {
            renderType = this.getRenderType(animatable, this.m_5478_((Entity)animatable), bufferSource, partialTick);
        }
        if (buffer == null) {
            buffer = bufferSource.m_6299_(renderType);
        }
        poseStack.m_85836_();
        this.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, packedLight, packedLight, packedOverlay);
            this.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.applyRenderLayers(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
        }
        poseStack.m_85849_();
        this.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        if (this.emissivePass) {
            return RenderType.m_110488_((ResourceLocation)texture);
        }
        return RenderType.m_110452_((ResourceLocation)texture);
    }
}

