/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers;

import com.mna.api.recipes.IManaweavePattern;
import com.mna.entities.manaweaving.Manaweave;
import com.mna.tools.math.MathUtils;
import com.mna.tools.math.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ManaweaveRenderer
extends EntityRenderer<Manaweave> {
    private static final ResourceLocation SPARKLE_TEXTURE = new ResourceLocation("mna", "textures/particle/sparkle.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110470_((ResourceLocation)SPARKLE_TEXTURE);

    public ManaweaveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Manaweave entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ArrayList<IManaweavePattern> patterns = entityIn.getPatterns();
        if (patterns == null) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.5, 0.0);
        for (IManaweavePattern p : patterns) {
            this.RenderPattern(p, matrixStackIn, bufferIn, entityIn.f_19797_, partialTicks);
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void RenderPattern(IManaweavePattern pattern, PoseStack matrixStackIn, MultiBufferSource bufferIn, int life, float partialTicks) {
        byte[][] points = pattern.get();
        float offsetX = (float)points.length / 2.0f;
        float offsetY = (float)points[0].length / 2.0f;
        Quaternionf cameraRotation = this.f_114476_.m_253208_();
        Quaternionf portalRotation = new Quaternionf(cameraRotation.x(), cameraRotation.y(), cameraRotation.z(), cameraRotation.w());
        float baseScale = 0.125f;
        float fadeInTicks = 5.0f;
        Vector3 colorA = new Vector3(153.0, 0.0, 247.0);
        Vector3 colorB = new Vector3(245.0, 66.0, 144.0);
        int a = (int)(MathUtils.clamp01((float)life / fadeInTicks) * 200.0f);
        float baseAlphaMod = ((float)life + partialTicks) / 9.0f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(portalRotation);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_85837_(-2.6 * (double)baseScale, -2.6 * (double)baseScale, 0.0);
        matrixStackIn.m_85841_(baseScale, baseScale, baseScale);
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RENDER_TYPE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                int index = i * j + j;
                float originX = offsetX - (float)j * 0.5f;
                float originY = offsetY - (float)i * 0.5f;
                double pct = Math.abs(Math.sin(baseAlphaMod + (float)index));
                int loopA = MathUtils.clamp((int)((double)a - 75.0 * pct), 0, 255);
                pct = 1.0 - Math.cos(pct * pct);
                Vector3 color = Vector3.lerp(colorA, colorB, (float)pct);
                int r = (int)color.x;
                int g = (int)color.y;
                int b = (int)color.z;
                ManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 1.0f, r, g, b, loopA);
                ManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 1.0f, 1.0f, r, g, b, loopA);
                ManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 1.0f, 0.0f, r, g, b, loopA);
                ManaweaveRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 0.0f, r, g, b, loopA);
            }
        }
        matrixStackIn.m_85849_();
    }

    private static void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float u, float v, int r, int g, int b, int a) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(Manaweave entity) {
        return SPARKLE_TEXTURE;
    }
}

