/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.living;

import com.mna.capabilities.entity.MAPFX;
import com.mna.capabilities.entity.MAPFXProvider;
import com.mna.spells.components.ComponentTrueInvisibility;
import com.mna.tools.EntityUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LivingRenderEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onLivingRenderPre(RenderLivingEvent.Pre<?, ?> event) {
        if (event.getEntity() == null) {
            return;
        }
        if (EntityUtil.shouldBeInvisible(event.getEntity())) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            return;
        }
        event.getEntity().getCapability(MAPFXProvider.MAPFX).ifPresent(pfx -> {
            if (pfx.getFlag(event.getEntity(), MAPFX.Flag.TRUE_INVISIBILITY) && !ComponentTrueInvisibility.IsDisabledFor(event.getEntity())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            } else if (pfx.getFlag(event.getEntity(), MAPFX.Flag.CANCEL_RENDER)) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        });
        try {
            float curScale = event.getEntity().getPersistentData().m_128457_("mna_entity_scale");
            float prevScale = event.getEntity().getPersistentData().m_128457_("mna_entity_scale_prev");
            if (curScale == 0.0f || prevScale == 0.0f) {
                curScale = 1.0f;
                prevScale = 1.0f;
            }
            float partial = event.getPartialTick();
            float scale = curScale + (curScale - prevScale) * partial;
            event.getPoseStack().m_85841_(scale, scale, scale);
            if (event.getEntity().m_20163_()) {
                event.getPoseStack().m_85837_(0.0, 0.125, 0.0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onLivingRenderPost(RenderLivingEvent.Post<?, ?> event) {
    }
}

