/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.sorcery;

import com.mna.ManaAndArtifice;
import com.mna.api.tools.RLoc;
import com.mna.entities.summon.Simulacrum;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fluids.FluidType;

public class SimulacrumRenderer
extends LivingEntityRenderer<Simulacrum, PlayerModel<Simulacrum>> {
    private static final ResourceLocation DEFAULT = RLoc.create("textures/entity/simulacrum.png");
    private PlayerModel<Simulacrum> slim = null;
    private PlayerModel<Simulacrum> normal = null;
    private int pass = 0;

    public SimulacrumRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.normal = new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false);
        this.slim = new PlayerModel(context.m_174023_(ModelLayers.f_171166_), true);
    }

    public void render(Simulacrum pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        String s;
        Player owner = pEntity.getOwner();
        this.f_115290_ = this.normal;
        if (owner != null && (s = ((AbstractClientPlayer)owner).m_108564_()) == "slim") {
            this.f_115290_ = this.slim;
        }
        if (owner instanceof AbstractClientPlayer) {
            AbstractClientPlayer acp = (AbstractClientPlayer)owner;
            this.setModelProperties(acp);
        }
        this.pass = 0;
        pPoseStack.m_85836_();
        super.m_7392_((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.m_85849_();
        this.pass = 1;
        pPoseStack.m_85836_();
        super.m_7392_((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.m_85849_();
        if (owner == ManaAndArtifice.instance.proxy.getClientPlayer()) {
            this.renderManaBar(pEntity, pEntityYaw, pPoseStack, pBuffer);
        }
    }

    private void renderManaBar(Simulacrum pEntity, float pEntityYaw, PoseStack pPoseStack, MultiBufferSource pBuffer) {
        float pct = pEntity.getManaPct();
        int color = Mth.m_14169_((float)(pct / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
        int r = FastColor.ARGB32.m_13665_((int)color) / 3 * 2;
        int g = FastColor.ARGB32.m_13667_((int)color) / 3 * 2;
        int b = FastColor.ARGB32.m_13669_((int)color) / 3 * 2;
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-pEntityYaw));
        pPoseStack.m_85837_(0.0, 2.5, 0.0);
        pPoseStack.m_85841_(1.5f, 0.05f, 1.0f);
        WorldRenderUtils.renderProgressBar(pPoseStack, pBuffer, pct, new int[]{r, g, b}, 255);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        WorldRenderUtils.renderProgressBar(pPoseStack, pBuffer, 1.0f - pct, new int[]{0, 0, 0}, 255);
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(Simulacrum entity) {
        if (this.pass == 0) {
            Player player;
            if (entity.getOwner() != null && (player = entity.getOwner()) instanceof AbstractClientPlayer) {
                AbstractClientPlayer player2 = (AbstractClientPlayer)player;
                return player2.m_108560_();
            }
            return DEFAULT;
        }
        return DEFAULT;
    }

    protected boolean shouldShowName(Simulacrum entity) {
        return false;
    }

    protected void renderNameTag(Simulacrum entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
    }

    public Vec3 getRenderOffset(Simulacrum pEntity, float pPartialTicks) {
        return pEntity.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)pEntity, pPartialTicks);
    }

    protected void scale(AbstractClientPlayer pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        pPoseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    protected void setupRotations(Simulacrum pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        Player owner = pEntityLiving.getOwner();
        if (owner instanceof AbstractClientPlayer) {
            AbstractClientPlayer acp = (AbstractClientPlayer)owner;
            float f = pEntityLiving.m_20998_(pPartialTicks);
            if (pEntityLiving.m_21255_()) {
                super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
                float f1 = (float)pEntityLiving.m_21256_() + pPartialTicks;
                float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                if (!pEntityLiving.m_21209_()) {
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - pEntityLiving.m_146909_())));
                }
                Vec3 vec3 = pEntityLiving.m_20252_(pPartialTicks);
                Vec3 vec31 = acp.m_272267_(pPartialTicks);
                double d0 = vec31.m_165925_();
                double d1 = vec3.m_165925_();
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                    double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                    pPoseStack.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
                }
            } else if (f > 0.0f) {
                super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
                float f3 = pEntityLiving.m_20069_() || pEntityLiving.isInFluidType((fluidType, height) -> pEntityLiving.canSwimInFluidType((FluidType)fluidType)) ? -90.0f - pEntityLiving.m_146909_() : -90.0f;
                float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(f4));
                if (pEntityLiving.m_6067_()) {
                    pPoseStack.m_252880_(0.0f, -1.0f, 0.3f);
                }
            } else {
                super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
            }
        }
    }

    private void setModelProperties(AbstractClientPlayer pClientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.m_7200_();
        if (pClientPlayer.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102809_.f_104207_ = pClientPlayer.m_36170_(PlayerModelPart.HAT);
            playermodel.f_103378_.f_104207_ = pClientPlayer.m_36170_(PlayerModelPart.JACKET);
            playermodel.f_103376_.f_104207_ = pClientPlayer.m_36170_(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.f_103377_.f_104207_ = pClientPlayer.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.f_103374_.f_104207_ = pClientPlayer.m_36170_(PlayerModelPart.LEFT_SLEEVE);
            playermodel.f_103375_.f_104207_ = pClientPlayer.m_36170_(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.f_102817_ = pClientPlayer.m_6047_();
            HumanoidModel.ArmPose humanoidmodel$armpose = SimulacrumRenderer.getArmPose(pClientPlayer, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose humanoidmodel$armpose1 = SimulacrumRenderer.getArmPose(pClientPlayer, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = pClientPlayer.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (pClientPlayer.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = humanoidmodel$armpose;
                playermodel.f_102815_ = humanoidmodel$armpose1;
            } else {
                playermodel.f_102816_ = humanoidmodel$armpose1;
                playermodel.f_102815_ = humanoidmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer pPlayer, InteractionHand pHand) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (pPlayer.m_7655_() == pHand && pPlayer.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && pHand == pPlayer.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useanim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useanim == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!pPlayer.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose((LivingEntity)pPlayer, pHand, itemstack)) != null) {
            return forgeArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

