/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.entities.EntityInit;
import com.mna.tools.BlockUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FlatLandsProjectile
extends Entity {
    private static final EntityDataAccessor<BlockPos> END = SynchedEntityData.m_135353_(FlatLandsProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    int age = 0;
    float interpPct = 0.0f;
    Player caster_reference;
    UUID casterID;
    int shotTime = 200;

    public FlatLandsProjectile(EntityType<? extends FlatLandsProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public FlatLandsProjectile(Level worldIn) {
        this((EntityType<? extends FlatLandsProjectile>)((EntityType)EntityInit.FLAT_LANDS_PROJECTILE.get()), worldIn);
    }

    public void m_8119_() {
        ++this.age;
        if (this.age > 200 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Player caster = this.getCaster();
        if (caster == null) {
            return;
        }
        if (!this.m_9236_().m_5776_() && this.age > this.shotTime) {
            BlockPos end = (BlockPos)this.f_19804_.m_135370_(END);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        BlockPos targetPos = end.m_7918_(i, j, k);
                        if (this.m_9236_().m_7702_(targetPos) != null || !BlockUtils.destroyBlock((LivingEntity)caster, this.m_9236_(), targetPos, true, (Tier)Tiers.IRON)) continue;
                        BlockUtils.updateBlockState(this.m_9236_(), targetPos);
                    }
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
    }

    private Player getCaster() {
        if (this.caster_reference == null && this.casterID != null) {
            this.caster_reference = this.m_9236_().m_46003_(this.casterID);
        }
        return this.caster_reference;
    }

    public Vec3 getCurrentEndPoint() {
        return Vec3.m_82512_((Vec3i)((Vec3i)this.f_19804_.m_135370_(END)));
    }

    public void setPoints(Vec3 start, BlockPos end) {
        this.m_146884_(start);
        this.f_19804_.m_135381_(END, (Object)end);
        this.shotTime = (int)start.m_82554_(Vec3.m_82512_((Vec3i)end));
    }

    public void setCaster(Player caster) {
        this.caster_reference = caster;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(END, (Object)this.m_20183_());
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (END.equals(pKey)) {
            Vec3 start = this.m_20182_();
            Vec3 end = Vec3.m_82512_((Vec3i)((Vec3i)this.f_19804_.m_135370_(END)));
            this.shotTime = (int)start.m_82554_(end);
            Vec3 delta = end.m_82546_(start).m_82541_();
            start = start.m_82549_(delta);
            int[] color = Affinity.EARTH.getColor();
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())).setMaxAge(this.shotTime).setColor(color[0], color[1], color[2]), start.m_7096_(), start.m_7098_(), start.m_7094_(), end.m_7096_(), end.m_7098_(), end.m_7094_());
        }
        super.m_7350_(pKey);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("end_x") && compound.m_128441_("end_y") && compound.m_128441_("end_z")) {
            this.f_19804_.m_135381_(END, (Object)new BlockPos(compound.m_128451_("end_x"), compound.m_128451_("end_y"), compound.m_128451_("end_z")));
        }
        if (compound.m_128441_("caster_uuid")) {
            try {
                this.casterID = UUID.fromString(compound.m_128461_("caster_uuid"));
            }
            catch (Exception e) {
                ManaAndArtifice.LOGGER.error("Error loading caster UUID for flat lands projectile!");
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("end_x", ((BlockPos)this.f_19804_.m_135370_(END)).m_123341_());
        compound.m_128405_("end_y", ((BlockPos)this.f_19804_.m_135370_(END)).m_123342_());
        compound.m_128405_("end_z", ((BlockPos)this.f_19804_.m_135370_(END)).m_123343_());
        compound.m_128359_("caster_uuid", this.caster_reference != null ? this.caster_reference.m_20148_().toString() : "");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }
}

