/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SpellEmber
extends Entity {
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(SpellEmber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<CompoundTag> SPELL_RECIPE = SynchedEntityData.m_135353_(SpellEmber.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Integer> ANGLE = SynchedEntityData.m_135353_(SpellEmber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(SpellEmber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> TARGET_DISTANCE = SynchedEntityData.m_135353_(SpellEmber.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> HOMING_STRENGTH = SynchedEntityData.m_135353_(SpellEmber.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private ISpellDefinition cachedRecipe;
    private LivingEntity cachedOwner;
    private LivingEntity target;
    private Vec3 movement;

    public SpellEmber(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SpellEmber(Level pLevel, LivingEntity owner, ISpellDefinition recipe, int angle) {
        super((EntityType)EntityInit.SPELL_EMBER.get(), pLevel);
        this.m_146884_(owner.m_20182_());
        this.f_19804_.m_135381_(OWNER_ID, (Object)owner.m_19879_());
        CompoundTag recipeCompound = new CompoundTag();
        recipe.writeToNBT(recipeCompound);
        this.f_19804_.m_135381_(SPELL_RECIPE, (Object)recipeCompound);
        this.f_19804_.m_135381_(ANGLE, (Object)angle);
        this.m_20242_(true);
        SummonUtils.addTrackedEntity(owner, this, "mna:ember_ids");
        SummonUtils.tagAsSummon(this, owner);
    }

    public void setHomingStrength(float strength) {
        this.f_19804_.m_135381_(HOMING_STRENGTH, (Object)Float.valueOf(MathUtils.clamp01(strength)));
    }

    public void setTargetDistance(byte distance) {
        this.f_19804_.m_135381_(TARGET_DISTANCE, (Object)distance);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.getOwner() == null || !this.getOwner().m_6084_() || this.getOwner().m_9236_() != this.m_9236_() || this.getSpell() == null || this.getTarget() != null && this.f_19797_ >= 60) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (this.getTarget() == null) {
                if (!this.m_9236_().m_5776_() && !SummonUtils.isTracked(this.getOwner(), this, "mna:ember_ids")) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                Vec3 desiredPos = this.getPositionAroundOwnerBasedOnLocation();
                this.m_146884_(desiredPos);
                if (this.m_9236_().m_46467_() % 20L == 0L && SummonUtils.isFirstTrackedEntity(this.getOwner(), "mna:ember_ids", this)) {
                    LivingEntity owner = this.getOwner();
                    if (owner instanceof Player) {
                        owner.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                            if (m.getEmberCooldown() == 0) {
                                this.target();
                            }
                            if (this.getTarget() != null) {
                                m.setEmberCooldown(20);
                            }
                        });
                    } else {
                        long last_ember = owner.getPersistentData().m_128454_("mna_last_ember_time");
                        long cur_time = this.m_9236_().m_46467_();
                        long last_ember_time = cur_time - last_ember;
                        if (last_ember_time >= 20L) {
                            this.target();
                            owner.getPersistentData().m_128356_("mna_last_ember_time", cur_time);
                        }
                    }
                }
            } else {
                if (!this.getTarget().m_6084_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                Vec3 myPos = this.m_20182_();
                Vec3 theirPos = this.getTarget().m_20182_().m_82520_(0.0, (double)(this.getTarget().m_20206_() / 2.0f), 0.0);
                if (this.movement == null) {
                    this.movement = theirPos.m_82546_(myPos).m_82541_();
                } else {
                    float tickTheta = 7.5f * MathUtils.clamp01(((Float)this.f_19804_.m_135370_(HOMING_STRENGTH)).floatValue());
                    if (tickTheta > 0.0f) {
                        Vec3 desiredHeading = theirPos.m_82546_(myPos).m_82541_();
                        this.movement = MathUtils.rotateTowards(this.movement, desiredHeading, tickTheta).m_82541_().m_82490_(0.5);
                    }
                }
                this.m_146884_(this.m_20182_().m_82549_(this.movement));
                if (!this.m_9236_().m_5776_()) {
                    SpellContext context = new SpellContext(this.m_9236_(), this.getSpell(), this);
                    SpellSource source = new SpellSource(this.getOwner(), InteractionHand.MAIN_HAND);
                    if (myPos.m_82554_(theirPos) < 0.5) {
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                        if (this.getSpell() != null && this.getOwner() != null) {
                            this.getSpell().iterateComponents(c -> SpellCaster.ApplyComponents(this.getSpell(), source, new SpellTarget((Entity)this.getTarget()), context));
                        }
                    }
                }
            }
        }
        if (this.m_9236_().m_5776_()) {
            block11: for (int i = 0; i < 2; ++i) {
                switch (this.getSpell().getHighestAffinity()) {
                    case EARTH: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case ENDER: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case FIRE: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case HELLFIRE: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case ICE: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case LIGHTNING: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() - 0.25 + Math.random() * 0.5, this.m_20186_() - 0.25 + Math.random() * 0.5, this.m_20189_() - 0.25 + Math.random() * 0.5);
                        continue block11;
                    }
                    case WATER: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case BLOOD: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setColor(182, 28, 28).setScale(0.1f).setGravity(0.0f).setMaxAge(5), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(0.025f).setScale(0.05f).setPhysics(true), this.m_20185_() + (double)MathUtils.RandomBetween(-0.25f, 0.25f), this.m_20186_(), this.m_20189_() + (double)MathUtils.RandomBetween(-0.25f, 0.25f), 0.0, 0.0, 0.0);
                        continue block11;
                    }
                    case WIND: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.05f).setColor(30, 30, 30), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.5, (double)0.001f, 0.05);
                        continue block11;
                    }
                    default: {
                        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        super.m_8119_();
    }

    private void target() {
        this.target = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)((Byte)this.f_19804_.m_135370_(TARGET_DISTANCE)).byteValue()), e -> {
            if (!EntitySelector.f_20406_.test(e)) {
                return false;
            }
            ClipContext ctx = new ClipContext(this.m_20182_(), e.m_20182_().m_82520_(0.0, (double)(e.m_20206_() / 2.0f), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
            if (this.m_9236_().m_45547_(ctx).m_6662_() == HitResult.Type.BLOCK) {
                return false;
            }
            return e.m_6084_() && e instanceof LivingEntity && !SummonUtils.isTargetFriendly(e, this.getOwner());
        }).stream().map(e -> (LivingEntity)e).findFirst().orElse(null);
        if (this.target != null) {
            this.f_19804_.m_135381_(TARGET_ID, (Object)this.target.m_19879_());
            this.f_19797_ = 0;
        }
    }

    public boolean m_7337_(Entity pEntity) {
        return this.getTarget() == pEntity;
    }

    private Vec3 getPositionAroundOwnerBasedOnLocation() {
        float angle = ManaAndArtifice.instance.proxy.getGameTicks() * 3L + (long)((Integer)this.f_19804_.m_135370_(ANGLE)).intValue();
        Vec3 targetPos = this.getOwner().m_20182_().m_82520_(0.0, (double)(this.getOwner().m_20206_() / 2.0f), 0.0);
        Vector3f offset = new Vector3f(1.0f, 0.0f, 0.0f);
        Quaternionf rotation = Axis.f_252436_.m_252977_(angle);
        offset.rotate((Quaternionfc)rotation);
        offset.normalize();
        return targetPos.m_82520_((double)offset.x(), (double)offset.y(), (double)offset.z());
    }

    @Nullable
    private LivingEntity getOwner() {
        if (this.cachedOwner == null) {
            int ownerID = (Integer)this.f_19804_.m_135370_(OWNER_ID);
            if (ownerID > -1) {
                Entity e = this.m_9236_().m_6815_(ownerID);
                if (e == null || !(e instanceof LivingEntity)) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return null;
                }
                this.cachedOwner = (LivingEntity)e;
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        return this.cachedOwner;
    }

    @Nullable
    private LivingEntity getTarget() {
        Entity e;
        if (this.target == null && (e = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ID)).intValue())) instanceof LivingEntity) {
            this.target = (LivingEntity)e;
        }
        return this.target;
    }

    public void setAngle(int angle) {
        this.f_19804_.m_135381_(ANGLE, (Object)angle);
    }

    private ISpellDefinition getSpell() {
        if (this.cachedRecipe == null) {
            CompoundTag spellTag = (CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE);
            if (spellTag == null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.cachedRecipe = SpellRecipe.fromNBT(spellTag);
                if (!this.cachedRecipe.isValid()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
        return this.cachedRecipe;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_ID, (Object)-1);
        this.f_19804_.m_135372_(SPELL_RECIPE, (Object)new CompoundTag());
        this.f_19804_.m_135372_(ANGLE, (Object)0);
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(HOMING_STRENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_DISTANCE, (Object)16);
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128441_("owner")) {
            this.f_19804_.m_135381_(OWNER_ID, (Object)pCompound.m_128451_("owner"));
        }
        if (pCompound.m_128425_("spell", 10)) {
            this.f_19804_.m_135381_(SPELL_RECIPE, (Object)((CompoundTag)pCompound.m_128423_("spell")));
        }
        if (pCompound.m_128441_("angle")) {
            this.f_19804_.m_135381_(ANGLE, (Object)pCompound.m_128451_("angle"));
        }
        if (pCompound.m_128441_("homingFactor")) {
            this.f_19804_.m_135381_(HOMING_STRENGTH, (Object)Float.valueOf(pCompound.m_128457_("homingFactor")));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        int ownerID = (Integer)this.f_19804_.m_135370_(OWNER_ID);
        if (ownerID > -1) {
            pCompound.m_128405_("owner", ownerID);
        }
        if (!((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE)).m_128456_()) {
            pCompound.m_128365_("spell", (Tag)this.f_19804_.m_135370_(SPELL_RECIPE));
        }
        pCompound.m_128405_("angle", ((Integer)this.f_19804_.m_135370_(ANGLE)).intValue());
        pCompound.m_128350_("homingFactor", ((Float)this.f_19804_.m_135370_(HOMING_STRENGTH)).floatValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

