/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.BlockUtils;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.LineSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpellWall
extends ChanneledSpellEntity {
    protected Vec3 forward;
    protected Vec3 perpendicular;

    public SpellWall(EntityType<? extends SpellWall> type, Level world) {
        super(type, world);
    }

    public SpellWall(LivingEntity caster, ISpellDefinition spell, Level world, boolean axisLock) {
        this((EntityType<? extends SpellWall>)((EntityType)EntityInit.SPELL_WALL.get()), caster, spell, world, axisLock);
    }

    protected SpellWall(EntityType<? extends SpellWall> entityType, LivingEntity caster, ISpellDefinition spell, Level world, boolean axisLock) {
        super(entityType, caster, spell, world);
        if (!axisLock) {
            this.m_146922_(caster.m_146908_());
            this.m_146926_(caster.m_146909_());
        } else {
            this.m_146922_(caster.m_6350_().m_122435_());
        }
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        float radius_h = this.getShapeAttributeByAge(Attribute.WIDTH);
        float radius_v = this.getShapeAttributeByAge(Attribute.HEIGHT);
        SpellSource source = new SpellSource(caster, caster.m_7655_());
        SpellContext context = new SpellContext((Level)world, recipe, this);
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities() && ((SpellEffect)c.getPart()).canBeChanneled())) {
            for (Entity e : this.targetEntities(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks() && ((SpellEffect)c.getPart()).canBeChanneled())) {
            for (BlockPos p : this.targetBlocks(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(p, null).doNotOffsetFace(), context);
            }
        }
    }

    protected BlockPos[] targetBlocks(float radius_h, float radius_v) {
        double radiusOffsetX = Math.cos(Math.toRadians(this.m_146908_())) * (double)radius_h;
        double radiusOffsetZ = Math.sin(Math.toRadians(this.m_146908_())) * (double)radius_h;
        Vec3 a = new Vec3(this.m_20185_() + radiusOffsetX, this.m_20186_(), this.m_20189_() + radiusOffsetZ);
        Vec3 b = new Vec3(this.m_20185_() - radiusOffsetX, this.m_20186_(), this.m_20189_() - radiusOffsetZ);
        return this.getAllBlockLocationsBetween(a, b, radius_v);
    }

    protected BlockPos[] getAllBlockLocationsBetween(Vec3 a, Vec3 b, float radius_v) {
        ArrayList allPoints = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(BlockUtils.Vector3dToBlockPosRound(a), BlockUtils.Vector3dToBlockPosRound(b), pos -> {
            int i = 0;
            while ((float)i < radius_v) {
                if (!allPoints.contains(pos.m_7918_(0, 1 + i, 0))) {
                    allPoints.add(pos.m_7918_(0, 1 + i, 0));
                }
                ++i;
            }
        });
        return allPoints.toArray(new BlockPos[0]);
    }

    protected List<Entity> targetEntities(float radius_h, float radius_v) {
        List possibleTargets = this.m_9236_().m_45976_(Entity.class, new AABB(this.m_20185_() - (double)radius_h, this.m_20186_(), this.m_20189_() - (double)radius_h, this.m_20185_() + (double)radius_h, this.m_20186_() + (double)radius_v, this.m_20189_() + (double)radius_h));
        ArrayList<Entity> targets = new ArrayList<Entity>();
        double dirX = Math.cos(Math.PI / 180 * (double)this.m_146909_());
        double dirZ = Math.sin(Math.PI / 180 * (double)this.m_146908_());
        Vec3 a = new Vec3(this.m_20185_() - dirX * (double)radius_h, this.m_20186_(), this.m_20189_() - dirZ * (double)radius_h);
        Vec3 b = new Vec3(this.m_20185_() - dirX * (double)(-radius_h), this.m_20186_(), this.m_20189_() - dirZ * (double)(-radius_h));
        LineSegment wallLine = new LineSegment(a, b);
        for (Entity e : possibleTargets) {
            if (e == this || e == this.getCaster() || !(e instanceof LivingEntity) || !e.m_6084_()) continue;
            Vec3 target = e.m_20182_();
            Vec3 closest = wallLine.closestPointOnLine(target);
            target = target.m_82492_(0.0, target.f_82480_, 0.0);
            closest = closest.m_82492_(0.0, closest.f_82480_, 0.0);
            double hDist = Math.abs(closest.m_82554_(target));
            double vDist = Math.abs(this.m_20186_() - e.m_20186_());
            if (!(hDist < 0.75) || !(vDist < (double)radius_v)) continue;
            targets.add(e);
        }
        return targets;
    }

    @Override
    public void m_8119_() {
        if (this.actAsChanneled()) {
            super.m_8119_();
            return;
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ >= this.getMaxAge()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        SpellRecipe recipe = this.getSpell();
        if (!this.m_9236_().m_5776_() && !recipe.isValid()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        LivingEntity caster = this.getCaster();
        if (caster == null) {
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ > 0 && (this.getApplicationRate() == 1 || this.f_19797_ % this.getApplicationRate() == 0)) {
                this.applyEffect(ItemStack.f_41583_, recipe, caster, (ServerLevel)this.m_9236_());
            }
        } else {
            this.spawnParticles();
            this.playSounds();
        }
    }

    protected boolean actAsChanneled() {
        return false;
    }

    @Override
    public void setCaster(LivingEntity player) {
        this.m_146926_(player.m_146909_());
        this.m_146922_(player.m_146908_());
        super.setCaster(player);
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.AIR_ORBIT.get()), new Vec3((double)0.3f, (double)0.02f, (double)0.3f), p -> p.setScale(0.2f).setColor(10, 10, 10));
    }

    @Override
    protected void spawnEarthParticles(SpellRecipe recipe) {
        this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.DUST.get()), new Vec3(0.0, (double)0.05f, 0.0), null);
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        if (!lightning) {
            this.spawnParticlesAlongRadius(recipe, hellfire ? (MAParticleType)((Object)ParticleInit.HELLFIRE.get()) : (MAParticleType)((Object)ParticleInit.FLAME.get()), new Vec3(0.0, (double)(this.getShapeAttributeByAge(Attribute.HEIGHT) / 30.0f), 0.0), null);
        } else {
            this.spawnLightningParticlesAlongRadius(recipe, new Vec3(-0.5 + Math.random(), Math.random(), -0.5 + Math.random()));
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean frost) {
        this.spawnParticlesAlongRadius(recipe, frost ? (MAParticleType)((Object)ParticleInit.FROST.get()) : (MAParticleType)((Object)ParticleInit.WATER.get()), new Vec3(0.0, (double)0.025f, 0.0), null);
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe, boolean blood) {
        if (blood) {
            this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.DROPLET.get()), new Vec3(0.0, (double)0.025f, 0.0), p -> {
                p.setColor(Affinity.BLOOD);
                p.setGravity(0.05f);
                p.setPhysics(true);
                p.setMaxAge(12);
            });
        } else {
            this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.ENDER_VELOCITY.get()), new Vec3(0.0, (double)0.025f, 0.0), null);
        }
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.ARCANE.get()), new Vec3(0.0, (double)0.025f, 0.0), null);
    }

    protected void spawnParticlesAlongRadius(SpellRecipe recipe, MAParticleType particleData, Vec3 motionData, Consumer<MAParticleType> particleAdjuster) {
        this.spawnParticlesAlongRadius(recipe, particleData, motionData, true, false, particleAdjuster);
    }

    protected void spawnParticlesAlongRadius(SpellRecipe recipe, MAParticleType particleData, Vec3 motionData, boolean randomY, boolean addPositionToMotionData, Consumer<MAParticleType> particleAdjuster) {
        if (this.forward == null) {
            float x = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float y = -Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float z = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            this.forward = new Vec3((double)x, (double)y, (double)z).m_82541_();
        }
        if (this.perpendicular == null) {
            this.perpendicular = this.forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        }
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        float height = this.getShapeAttributeByAge(Attribute.HEIGHT);
        int i = 0;
        while ((float)i < 20.0f * radius * (height / 2.0f)) {
            double radiusMid = Math.random() * (double)radius * 2.0 - (double)radius;
            Vec3 particleOrigin = new Vec3(me.f_82479_ - this.perpendicular.f_82479_ * radiusMid + (double)(MathUtils.RandomBetween((float)(-this.forward.f_82479_), (float)this.forward.f_82479_) / 2.0f), randomY ? me.f_82480_ + Math.random() * (double)height : me.f_82480_, me.f_82481_ - this.perpendicular.f_82481_ * radiusMid + (double)(MathUtils.RandomBetween((float)(-this.forward.f_82481_), (float)this.forward.f_82481_) / 2.0f));
            Vec3 particleMotion = addPositionToMotionData ? motionData.m_82549_(particleOrigin) : motionData;
            MAParticleType pfxAdj = new MAParticleType(particleData);
            if (particleAdjuster != null) {
                particleAdjuster.accept(pfxAdj);
            }
            recipe.colorParticle(pfxAdj, (Entity)this.getCaster());
            this.m_9236_().m_7106_((ParticleOptions)pfxAdj, particleOrigin.f_82479_, particleOrigin.f_82480_, particleOrigin.f_82481_, particleMotion.f_82479_, particleMotion.f_82480_, particleMotion.f_82481_);
            ++i;
        }
    }

    protected void spawnLightningParticlesAlongRadius(SpellRecipe recipe, Vec3 motionData) {
        if (this.forward == null) {
            float x = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float y = -Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float z = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            this.forward = new Vec3((double)x, (double)y, (double)z);
        }
        if (this.perpendicular == null) {
            this.perpendicular = this.forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        }
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        float height = this.getShapeAttributeByAge(Attribute.HEIGHT);
        int i = 0;
        while ((float)i < 2.0f * radius) {
            double radiusMid = Math.random() * (double)radius * 2.0 - (double)radius;
            Vec3 particleOrigin = new Vec3(me.f_82479_ - this.perpendicular.f_82479_ * radiusMid, me.f_82480_, me.f_82481_ - this.perpendicular.f_82481_ * radiusMid);
            Vec3 particleMotion = motionData.m_82549_(particleOrigin);
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getCaster()), particleOrigin.f_82479_, particleOrigin.f_82480_, particleOrigin.f_82481_, particleMotion.f_82479_, particleMotion.f_82480_ + (double)height, particleMotion.f_82481_);
            ++i;
        }
    }
}

