/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.summon;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.SpellCastingResult;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.entities.EntityInit;
import com.mna.spells.SpellCaster;
import com.mna.tools.math.MathUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class Simulacrum
extends Mob
implements OwnableEntity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(Simulacrum.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(Simulacrum.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MANA = SynchedEntityData.m_135353_(Simulacrum.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAX_MANA = SynchedEntityData.m_135353_(Simulacrum.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);
    private Player __owner;
    private ISpellDefinition currentSpell;

    public Simulacrum(Level pLevel, float mana, Player owner, float offset) {
        this((EntityType<? extends Mob>)((EntityType)EntityInit.SIMULACRUM.get()), pLevel);
        if (owner != null) {
            this.f_19804_.m_135381_(MAX_MANA, (Object)Float.valueOf(mana));
            this.f_19804_.m_135381_(MANA, (Object)Float.valueOf(mana));
            this.f_19804_.m_135381_(OWNER, Optional.of(owner.m_36316_().getId()));
            this.f_19804_.m_135381_(OFFSET, (Object)Float.valueOf(offset));
            this.copyTransformAndVelocityFromOwner();
        }
    }

    public Simulacrum(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        if (this.getOwner() == null || this.getOwner().m_21224_()) {
            this.m_146870_();
            return;
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.m_6117_() && this.m_21211_().m_41720_() instanceof ICanContainSpell && this.currentSpell != null) {
                this.consumeMana(this.currentSpell.getManaCost());
            }
            if (this.f_19797_ % 20 == 0) {
                this.consumeMana(1.0f);
            }
            if (this.getMana() <= 0.0f) {
                this.m_146870_();
            }
        } else {
            Vec3 fwd = this.m_20156_().m_82541_().m_82490_((double)0.4f);
            Vec3 side = this.m_20156_().m_82541_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82490_((double)0.9f);
            int particleCount = this.f_20911_ ? 5 : 1;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 particleVelocity = this.f_20911_ ? this.m_20156_().m_82520_(0.0, 0.25, 0.0) : Vec3.f_82478_;
                Vec3 particlePos = this.m_20182_().m_82520_((MathUtils.RandomBetween(-fwd.f_82479_, fwd.f_82479_) + MathUtils.RandomBetween(-side.f_82479_, side.f_82479_)) * this.m_20191_().m_82362_(), (double)MathUtils.RandomBetween(0.25f, 1.25f) * this.m_20191_().m_82376_(), (MathUtils.RandomBetween(-fwd.f_82481_, fwd.f_82481_) + MathUtils.RandomBetween(-side.f_82481_, side.f_82481_)) * this.m_20191_().m_82385_());
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(0.05f).setPhysics(true), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
            }
        }
    }

    public void m_7023_(Vec3 pTravelVector) {
        super.m_7023_(pTravelVector);
        if (this.getOwner() != null) {
            this.copyTransformAndVelocityFromOwner();
        }
    }

    private void copyTransformAndVelocityFromOwner() {
        Player owner = this.getOwner();
        if (owner == null) {
            return;
        }
        Vec3 side = Vec3.m_82503_((Vec2)new Vec2(0.0f, owner.m_146908_())).m_82541_().m_82537_(UP).m_82490_((double)((Float)this.f_19804_.m_135370_(OFFSET)).floatValue());
        this.m_146884_(owner.m_20182_().m_82549_(side).m_82520_(0.0, 0.25, 0.0));
        this.m_19915_(owner.m_146908_(), owner.m_146909_());
        this.m_20256_(owner.m_20184_());
        this.f_20911_ = owner.f_20911_;
        this.f_20912_ = owner.f_20912_;
        this.f_20913_ = owner.f_20913_;
    }

    public void castSpell(ItemStack stack, ISpellDefinition spell, InteractionHand hand) {
        if (this.f_19797_ == 0) {
            return;
        }
        SpellCastingResult res = SpellCaster.Affect(stack.m_41777_(), spell, this.m_9236_(), new SpellSource((LivingEntity)this, hand), null, new SpellContext(this.m_9236_(), spell));
        if (res.getCode().isConsideredSuccess()) {
            this.consumeMana(spell.getManaCost());
            this.currentSpell = spell;
        }
    }

    public float getMana() {
        return ((Float)this.f_19804_.m_135370_(MANA)).floatValue();
    }

    public void setMana(float mana) {
        this.f_19804_.m_135381_(MANA, (Object)Float.valueOf(mana));
    }

    public void consumeMana(float amount) {
        this.setMana(this.getMana() - amount);
    }

    public float getManaPct() {
        return Mth.m_14036_((float)(((Float)this.f_19804_.m_135370_(MANA)).floatValue() / Math.max(((Float)this.f_19804_.m_135370_(MAX_MANA)).floatValue(), 1.0f)), (float)0.0f, (float)1.0f);
    }

    public ItemStack m_21120_(InteractionHand pHand) {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_21120_(pHand);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_6844_(pSlot);
        }
        return ItemStack.f_41583_;
    }

    public InteractionHand m_7655_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_7655_();
        }
        return InteractionHand.MAIN_HAND;
    }

    public ItemStack m_21211_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_21211_();
        }
        return ItemStack.f_41583_;
    }

    public int m_21212_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_21212_();
        }
        return 0;
    }

    public int m_21252_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_21252_();
        }
        return 0;
    }

    public boolean m_6117_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_6117_();
        }
        return false;
    }

    public boolean m_20143_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_20143_();
        }
        return false;
    }

    public boolean m_6067_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_6067_();
        }
        return false;
    }

    public boolean m_21255_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_21255_();
        }
        return false;
    }

    public Pose m_20089_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_20089_();
        }
        return Pose.STANDING;
    }

    public float m_20998_(float pPartialTicks) {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_20998_(pPartialTicks);
        }
        return 0.0f;
    }

    public boolean m_6047_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_6047_();
        }
        return false;
    }

    public Vec3 m_20184_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_20184_();
        }
        return Vec3.f_82478_;
    }

    public float m_21324_(float pPartialTick) {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_21324_(pPartialTick);
        }
        return 0.0f;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_7337_(Entity pEntity) {
        return !(pEntity instanceof LivingEntity);
    }

    protected boolean m_196406_(Vec3 pDeltaMovement) {
        return false;
    }

    public boolean m_271807_() {
        return true;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public void m_7334_(Entity pEntity) {
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 100; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLOOD.get())), this.m_20185_() + MathUtils.RandomBetween(-0.25, 0.25), this.m_20186_() + (double)MathUtils.RandomBetween(0.0f, 2.0f), this.m_20189_() + MathUtils.RandomBetween(-0.25, 0.25), MathUtils.RandomBetween(-0.05, 0.05), MathUtils.RandomBetween(0.02, 0.08), MathUtils.RandomBetween(-0.05, 0.05));
            }
        } else {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Entity.BloodGolem.DEATH, this.m_5720_(), 1.0f, MathUtils.RandomBetween(0.9f, 1.1f));
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 200; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET_LERP.get())).setColor(Affinity.BLOOD).setMaxAge(10 + (int)(Math.random() * 5.0)), this.m_20185_() + MathUtils.RandomBetween(-2.25, 2.25), this.m_20186_(), this.m_20189_() + MathUtils.RandomBetween(-2.25, 2.25), this.m_20185_(), this.m_20186_() + (double)MathUtils.RandomBetween(0.0f, 2.0f), this.m_20189_());
            }
        } else {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Entity.BloodGolem.SUMMON, this.m_5720_(), 1.0f, MathUtils.RandomBetween(0.9f, 1.1f));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, Optional.empty());
        this.f_19804_.m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MANA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAX_MANA, (Object)Float.valueOf(0.0f));
    }

    public UUID m_21805_() {
        Optional ownerID = (Optional)this.f_19804_.m_135370_(OWNER);
        if (ownerID.isPresent()) {
            return (UUID)ownerID.get();
        }
        return null;
    }

    public Player getOwner() {
        LivingEntity resolved;
        if (this.__owner == null && (resolved = super.m_269323_()) instanceof Player) {
            Player player;
            this.__owner = player = (Player)resolved;
        }
        return this.__owner;
    }
}

