/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.spells.crafting.SpellRecipe;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class SpellFX
extends Entity {
    private static final EntityDataAccessor<CompoundTag> SPELL_RECIPE = SynchedEntityData.m_135353_(SpellFX.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Integer> SFX = SynchedEntityData.m_135353_(SpellFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CASTER_ID = SynchedEntityData.m_135353_(SpellFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private SpellRecipe _cachedRecipe;
    private int age = 0;
    private boolean playedSound = false;

    public SpellFX(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void m_8119_() {
        if (!this.playedSound) {
            this.getRecipe().iterateComponents(c -> {
                if (((SpellEffect)c.getPart()).SoundEffect() != null) {
                    this.m_9236_().m_245803_((Entity)this.getCaster(this.m_9236_()), this.m_20183_(), ((SpellEffect)c.getPart()).SoundEffect(), SoundSource.PLAYERS, ((SpellEffect)c.getPart()).getSoundVolume(), (float)((double)0.9f + Math.random() * (double)0.1f));
                }
            });
            this.playedSound = true;
        }
        if (this.m_9236_().m_5776_() && this.getRecipe() != null) {
            this.getRecipe().iterateComponents(c -> ((SpellEffect)c.getPart()).SpawnParticles(this.m_9236_(), this.m_20182_(), this.m_20184_(), this.age, this.getCaster(this.m_9236_()), this.getRecipe()));
        }
        ++this.age;
        if (this.age >= 100) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SFX, (Object)-1);
        this.f_19804_.m_135372_(CASTER_ID, (Object)-1);
        this.f_19804_.m_135372_(SPELL_RECIPE, (Object)new CompoundTag());
    }

    public void setRecipe(ISpellDefinition recipe) {
        CompoundTag nbt = new CompoundTag();
        recipe.writeToNBT(nbt);
        this.f_19804_.m_135381_(SPELL_RECIPE, (Object)nbt);
    }

    @Nullable
    private SpellRecipe getRecipe() {
        if (this._cachedRecipe == null) {
            CompoundTag nbt = (CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE);
            this._cachedRecipe = SpellRecipe.fromNBT(nbt);
        }
        return this._cachedRecipe;
    }

    public void setCaster(@Nullable LivingEntity caster) {
        if (caster != null) {
            this.f_19804_.m_135381_(CASTER_ID, (Object)caster.m_19879_());
        }
    }

    @Nullable
    public LivingEntity getCaster(Level world) {
        int id = (Integer)this.f_19804_.m_135370_(CASTER_ID);
        try {
            Entity e = world.m_6815_(id);
            if (e instanceof LivingEntity) {
                return (LivingEntity)e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

