/*
 * Decompiled with CFR 0.152.
 */
package com.mna.events;

import com.mna.ManaAndArtifice;
import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.IChunkMagic;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.DamageHelper;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.tools.MATags;
import com.mna.blocks.BlockInit;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.capabilities.chunkdata.ChunkMagicProvider;
import com.mna.capabilities.particles.ParticleAuraProvider;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.effects.beneficial.EffectCamouflage;
import com.mna.effects.interfaces.INoCreeperLingering;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.boss.PigDragon;
import com.mna.entities.constructs.animated.Construct;
import com.mna.factions.Factions;
import com.mna.gui.containers.item.ContainerPractitionersPouch;
import com.mna.gui.containers.providers.NamedGuideBook;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.items.armor.CouncilArmorItem;
import com.mna.items.armor.DemonArmorItem;
import com.mna.items.artifice.EnderguardAmulet;
import com.mna.items.artifice.charms.ContingencyCharm;
import com.mna.items.artifice.curio.TrickeryBracelet;
import com.mna.items.relic.CrystallizedWind;
import com.mna.items.ritual.PractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.runes.ItemRuneMarking;
import com.mna.items.sorcery.MagicStaff;
import com.mna.network.ServerMessageDispatcher;
import com.mna.spells.components.ComponentTrueInvisibility;
import com.mna.tools.EntityUtil;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.StructureUtils;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_() && event.getItemStack().m_41720_() == Items.f_42454_) {
            CommonEventHandler.handleRightClick_Leather(player, event);
        }
    }

    private static void handleRightClick_Leather(Player player, PlayerInteractEvent.RightClickItem event) {
        BlockState state;
        ItemStack activestack = player.m_21120_(event.getHand());
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        BlockHitResult raytraceresult = player.m_9236_().m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK && (state = player.m_9236_().m_8055_(raytraceresult.m_82425_())) == Blocks.f_49990_.m_49966_()) {
            ItemStack vellum = new ItemStack((ItemLike)ItemInit.VELLUM.get());
            if (!event.getEntity().m_36356_(vellum)) {
                event.getEntity().m_36176_(vellum, true);
            }
            activestack.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!GeneralConfigValues.SummonInteractions && event.getEntity() instanceof LivingEntity && SummonUtils.isSummon((Entity)event.getEntity())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        ItemStack bookStack;
        BlockEntity te;
        if (!CommonEventHandler.handleWardBlockEvent(event.getLevel(), event.getPos(), event.getEntity())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        Level world = event.getLevel();
        if (!world.f_46443_ && world.m_8055_(event.getPos()).m_60734_() == Blocks.f_50624_ && (te = world.m_7702_(event.getPos())) instanceof LecternBlockEntity && (bookStack = ((LecternBlockEntity)te).m_59566_()).m_41720_() == ItemInit.GUIDE_BOOK.get()) {
            event.setCanceled(true);
            if (event.getEntity().m_6144_()) {
                ((LecternBlockEntity)te).m_59536_(ItemStack.f_41583_);
                LecternBlock.m_269306_((Entity)event.getEntity(), (Level)world, (BlockPos)event.getPos(), (BlockState)world.m_8055_(event.getPos()), (boolean)false);
                if (!event.getEntity().m_36356_(bookStack)) {
                    event.getEntity().m_19983_(bookStack);
                }
            } else if (!ManaAndArtificeMod.checkMagicUnlock((ServerLevel)world, event.getEntity())) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)event.getEntity()), (MenuProvider)new NamedGuideBook());
            }
            return;
        }
        Map map = EnchantmentHelper.m_44831_((ItemStack)event.getItemStack());
        if (map.containsKey(EnchantmentInit.RETURNING.get()) && (state = event.getLevel().m_8055_(event.getPos())).m_60734_() != BlockInit.RUNIC_ANVIL.get()) {
            event.setCanceled(true);
        }
    }

    private static boolean handleWardBlockEvent(Level world, BlockPos pos, @Nullable Player player) {
        if (player != null && player.m_7500_()) {
            return true;
        }
        LevelChunk chunkAccess = world.m_46745_(pos);
        LazyOptional chunkmagic = chunkAccess.getCapability(ChunkMagicProvider.MAGIC);
        if (chunkmagic.isPresent() && ((IChunkMagic)chunkmagic.resolve().get()).blockInteractionFor(pos, player)) {
            if (!player.m_9236_().m_5776_()) {
                if (player.getPersistentData().m_128451_("warded_notification_cooldown") == 0) {
                    player.m_213846_((Component)Component.m_237115_((String)"helptip.mna.block_warded").m_130940_(ChatFormatting.AQUA));
                    player.getPersistentData().m_128405_("warded_notification_cooldown", 10);
                }
                ServerMessageDispatcher.sendRenderWard((ServerPlayer)player, pos.m_121878_());
            }
            return false;
        }
        return true;
    }

    private static void handleBossArenaBlockEvent(Level world, BlockEvent event, @Nullable Player player) {
        if (GeneralConfigValues.DisableBossArenaProtection || player != null && player.m_7500_()) {
            return;
        }
        if (event.getState().m_60734_() instanceof ChalkRuneBlock) {
            return;
        }
        if (world instanceof ServerLevel && StructureUtils.isPointInAnyStructure((ServerLevel)world, event.getPos(), MATags.Structures.BOSS_ARENAS)) {
            int bosses;
            if (player != null && (bosses = world.m_6249_((Entity)player, new AABB(event.getPos()).m_82400_(64.0), e -> e.m_6084_() && e instanceof BossMonster).size()) == 0 && player.getPersistentData().m_128451_("boss_arena_notification_cooldown") == 0) {
                player.m_213846_((Component)Component.m_237115_((String)"helptip.mna.boss_break_denied").m_130940_(ChatFormatting.AQUA));
                player.getPersistentData().m_128405_("boss_arena_notification_cooldown", 1200);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        Level world = event.getLevel();
        for (int i = 0; i < 7; ++i) {
            BlockPos pos;
            BlockPos blockPos = pos = i == 0 ? BlockPos.m_274446_((Position)event.getExplosion().getPosition()) : CommonEventHandler.getExplosionExtent(event.getExplosion(), Direction.values()[i - 1]);
            if (!(world instanceof ServerLevel) || !StructureUtils.isPointInAnyStructure((ServerLevel)world, pos, MATags.Structures.BOSS_ARENAS)) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level world = (Level)event.getLevel();
        CommonEventHandler.handleBossArenaBlockEvent(world, (BlockEvent)event, event.getPlayer());
        if (!CommonEventHandler.handleWardBlockEvent(world, event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onVanillaGameEvent(VanillaGameEvent event) {
        if (event.getVanillaEvent() == GameEvent.f_157794_) {
            BlockPos pos = BlockPos.m_274446_((Position)event.getEventPosition());
            LevelChunk chunkAccess = event.getLevel().m_46745_(pos);
            chunkAccess.getCapability(ChunkMagicProvider.MAGIC).ifPresent(c -> c.removeBlockWard(pos));
        }
    }

    @SubscribeEvent
    public static void onFluidPlace(BlockEvent.FluidPlaceBlockEvent event) {
        CommonEventHandler.handleBossArenaBlockEvent((Level)event.getLevel(), (BlockEvent)event, null);
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        CommonEventHandler.handleBossArenaBlockEvent((Level)event.getLevel(), (BlockEvent)event, event.getEntity() instanceof Player ? (Player)event.getEntity() : null);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Optional trickery;
        int wardCD;
        int breakCD;
        Player player = event.player;
        if (player.getPersistentData().m_128441_("mna:flung")) {
            boolean flingEffect;
            long flingtime = player.getPersistentData().m_128454_("mna:fling_time");
            boolean bl = flingEffect = player.m_9236_().m_46467_() - flingtime >= 3L;
            if (player.m_20069_() || player.m_20096_()) {
                if (flingEffect) {
                    player.getPersistentData().m_128473_("mna:flung");
                }
            } else if (player.f_19862_) {
                if (!CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), (LivingEntity)player, SlotTypePreset.RING) && !CrystallizedWind.FindOn((LivingEntity)player) && flingEffect) {
                    player.m_6469_(player.m_269291_().m_269515_(), player.getPersistentData().m_128457_("mna:flung") * 3.0f);
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SFX.Entity.Spellbreaker.SHIELD_BASH, SoundSource.PLAYERS, 0.3f, 1.0f);
                }
                player.getPersistentData().m_128473_("mna:flung");
            }
        }
        if ((breakCD = player.getPersistentData().m_128451_("boss_arena_notification_cooldown")) > 0) {
            player.getPersistentData().m_128405_("boss_arena_notification_cooldown", --breakCD);
        }
        if ((wardCD = player.getPersistentData().m_128451_("warded_notification_cooldown")) > 0) {
            player.getPersistentData().m_128405_("warded_notification_cooldown", --wardCD);
        }
        if (player.getPersistentData().m_128441_("mna_remove_flight")) {
            int remaining = player.getPersistentData().m_128451_("mna_remove_flight") - 1;
            ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
            if (remaining == 0) {
                player.getPersistentData().m_128473_("mna_remove_flight");
            } else {
                player.getPersistentData().m_128405_("mna_remove_flight", remaining);
            }
        }
        if (!player.m_20096_() && player.m_20184_().f_82480_ < 0.0 && player.f_19789_ > 4.0f && player instanceof ServerPlayer && !player.m_21023_(MobEffects.f_19591_) && (double)CommonEventHandler.getDistanceToGround(player) <= Math.abs(player.m_20184_().f_82480_ * 10.0)) {
            ContingencyCharm.CheckAndConsumeCharmCharge((ServerPlayer)player, ContingencyCharm.ContingencyEvent.FALL);
        }
        if ((trickery = CuriosApi.getCuriosHelper().findCurios((LivingEntity)event.player, (Item)ItemInit.TRICKERY_BRACELET.get()).stream().findFirst()).isPresent()) {
            boolean crouching = event.player.m_6144_();
            if (crouching) {
                TrickeryBracelet.ApplyMoveSpeed(player);
            } else {
                TrickeryBracelet.RemoveMoveSpeed(player);
            }
            player.m_6842_(crouching || EntityUtil.shouldBeInvisible((LivingEntity)player));
        } else {
            TrickeryBracelet.RemoveMoveSpeed(player);
        }
        if (!event.player.m_9236_().m_5776_() && event.player.m_20069_() && event.player.m_21023_((MobEffect)EffectInit.MIST_FORM.get()) && event.player.m_9236_().m_46467_() % 20L == 0L) {
            event.player.m_6469_(DamageHelper.forType(DamageHelper.DISPERSE, event.player.m_9236_().m_9598_()), 5.0f);
        }
        if (event.player.m_21023_((MobEffect)EffectInit.POSSESSION.get()) && event.player.getPersistentData().m_128441_("posessed_entity_id")) {
            int id = event.player.getPersistentData().m_128451_("posessed_entity_id");
            Entity e = event.player.m_9236_().m_6815_(id);
            if (e == null || !(e instanceof Mob) || !e.m_6084_()) {
                event.player.getPersistentData().m_128473_("posessed_entity_id");
                event.player.m_21195_((MobEffect)EffectInit.POSSESSION.get());
            }
        }
        event.player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getAlliedFaction() == Factions.UNDEAD) {
                MobEffectInstance existing;
                int frostWalkerLevelOH;
                int frostWalkerLevelMH;
                int frostWalkerLevel;
                if (CommonEventHandler.isPlayerInDaylight(event.player) && !event.player.m_20071_() && !event.player.m_21023_((MobEffect)EffectInit.SOAKED.get())) {
                    if (event.player.m_21033_(EquipmentSlot.HEAD)) {
                        if (event.player.m_9236_().m_213780_().m_188501_() < 0.05f) {
                            ItemStack headslot = event.player.m_6844_(EquipmentSlot.HEAD);
                            headslot.m_41622_(1, (LivingEntity)event.player, e -> {});
                        }
                    } else {
                        event.player.m_20254_(8);
                    }
                } else if (event.player.m_20069_() && event.player.m_21124_(MobEffects.f_19608_) == null) {
                    event.player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 1, false, false, true));
                }
                if (!((frostWalkerLevel = Math.max(frostWalkerLevelMH = player.m_21205_().m_41720_() instanceof MagicStaff ? player.m_21205_().getEnchantmentLevel(Enchantments.f_44974_) : 0, frostWalkerLevelOH = player.m_21206_().m_41720_() instanceof MagicStaff ? player.m_21206_().getEnchantmentLevel(Enchantments.f_44974_) : 0)) <= 0 || event.player.m_9236_().m_5776_() || (existing = player.m_21124_((MobEffect)EffectInit.AURA_OF_FROST.get())) != null && existing.m_19557_() >= 20)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.AURA_OF_FROST.get(), 201, frostWalkerLevel));
                }
            }
        });
        if (((CouncilArmorItem)ItemInit.COUNCIL_ARMOR__CHEST.get()).isSetEquipped((LivingEntity)event.player)) {
            CouncilArmorItem.tickReflectCharges(event.player);
        }
        if (event.player.m_9236_().m_5776_()) {
            event.player.getCapability(ParticleAuraProvider.AURA).ifPresent(a -> {
                a.requestIfNeeded(player);
                Minecraft m = Minecraft.m_91087_();
                if (!m.f_91066_.m_92176_().m_90612_() || a.showInFirstPerson()) {
                    a.spawn(event.player.m_9236_(), event.player.m_20182_(), Vec3.m_82503_((Vec2)new Vec2(event.player.m_146909_(), event.player.f_20883_)));
                }
            });
            if (event.player.f_20938_ > 0 && event.player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == ItemInit.HELLFIRE_TRIDENT.get()) {
                Vec3 vel = event.player.m_20184_();
                for (int i = 0; i < 5; ++i) {
                    event.player.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), event.player.m_20185_() + Math.random() * vel.f_82479_, event.player.m_20186_() + Math.random() * vel.f_82480_, event.player.m_20189_() + Math.random() * vel.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupItem(EntityItemPickupEvent event) {
        ItemStack invStack;
        Optional<SlotResult> curioSlot;
        ItemStack pickedUpItem = event.getItem().m_32055_();
        int originalQty = pickedUpItem.m_41613_();
        Inventory inv = event.getEntity().m_150109_();
        boolean modifiedCollection = false;
        int openSlot = -1;
        AbstractContainerMenu abstractContainerMenu = event.getEntity().f_36096_;
        if (abstractContainerMenu instanceof ContainerPractitionersPouch) {
            ContainerPractitionersPouch cpp = (ContainerPractitionersPouch)abstractContainerMenu;
            openSlot = event.getEntity().m_150109_().f_35977_;
        }
        if ((curioSlot = CuriosInterop.GetSingleItem((LivingEntity)event.getEntity(), (Item)ItemInit.PRACTITIONERS_POUCH.get(), (Item)ItemInit.MITHIONS_MAGNIFICENT_MBAG.get())).isPresent() && !(invStack = curioSlot.get().stack()).m_41619_() && invStack.m_41720_() instanceof PractitionersPouch) {
            PractitionersPouch pouchItem = (PractitionersPouch)invStack.m_41720_();
            if (pouchItem.getPatchLevel(invStack, PractitionersPouchPatches.COLLECTION) > 0 && pouchItem.hasRoomForItem(invStack, pickedUpItem)) {
                boolean bl = modifiedCollection = originalQty != (pickedUpItem = pouchItem.insertItem(invStack, pickedUpItem)).m_41613_();
            }
            if (pickedUpItem.m_41619_()) {
                event.getEntity().m_7938_((Entity)event.getItem(), originalQty);
                event.setCanceled(true);
                event.getItem().m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (pouchItem.getPatchLevel(invStack, PractitionersPouchPatches.VOID) > 0 && pouchItem.shouldVoidItem(invStack, pickedUpItem)) {
                event.getEntity().m_7938_((Entity)event.getItem(), originalQty);
                event.setCanceled(true);
                event.getItem().m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        if (!pickedUpItem.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack invStack2;
                if (openSlot == i || (invStack2 = inv.m_8020_(i)).m_41619_() || !(invStack2.m_41720_() instanceof PractitionersPouch)) continue;
                PractitionersPouch pouchItem = (PractitionersPouch)invStack2.m_41720_();
                if (pouchItem.getPatchLevel(invStack2, PractitionersPouchPatches.COLLECTION) > 0 && pouchItem.hasRoomForItem(invStack2, pickedUpItem)) {
                    boolean bl = modifiedCollection = originalQty != (pickedUpItem = pouchItem.insertItem(invStack2, pickedUpItem)).m_41613_();
                }
                if (pickedUpItem.m_41619_()) {
                    event.getEntity().m_7938_((Entity)event.getItem(), originalQty);
                    event.setCanceled(true);
                    event.getItem().m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                if (pouchItem.getPatchLevel(invStack2, PractitionersPouchPatches.VOID) <= 0 || !pouchItem.shouldVoidItem(invStack2, pickedUpItem)) continue;
                event.getEntity().m_7938_((Entity)event.getItem(), originalQty);
                event.setCanceled(true);
                event.getItem().m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        if (modifiedCollection && !pickedUpItem.m_41619_()) {
            event.setCanceled(true);
            event.getItem().m_32045_(pickedUpItem);
            ForgeEventFactory.onItemPickup((ItemEntity)event.getItem(), (Player)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        MobEffectInstance effect;
        LivingEntity living = event.getEntity();
        if (living.getPersistentData().m_128441_("mna_remove_ginvis")) {
            int remaining = living.getPersistentData().m_128451_("mna_remove_ginvis") - 1;
            EntityUtil.removeInvisibility(living);
            if (remaining == 0) {
                living.getPersistentData().m_128473_("mna_remove_ginvis");
            } else {
                living.getPersistentData().m_128405_("mna_remove_ginvis", remaining);
            }
        }
        if (living.getPersistentData().m_128441_("mna:flung")) {
            if (living.m_20069_()) {
                living.getPersistentData().m_128473_("mna:flung");
            } else if (living.f_19862_) {
                if (!living.m_20096_()) {
                    long flingtime = living.getPersistentData().m_128454_("mna:fling_time");
                    if (living.m_9236_().m_46467_() - flingtime >= 3L) {
                        living.m_6469_(DamageHelper.createSourcedType((ResourceKey<DamageType>)DamageTypes.f_268576_, living.m_9236_().m_9598_(), (Entity)living), living.getPersistentData().m_128457_("mna:flung") * 3.0f);
                        living.m_9236_().m_6263_(null, living.m_20182_().f_82479_, living.m_20182_().f_82480_, living.m_20182_().f_82481_, SFX.Entity.Spellbreaker.SHIELD_BASH, SoundSource.HOSTILE, 0.3f, 1.0f);
                    }
                }
                living.getPersistentData().m_128473_("mna:flung");
            }
        }
        boolean isInWater = living.m_20069_();
        boolean isWet = living.m_20071_();
        if (living.m_21124_((MobEffect)EffectInit.WATERY_GRAVE.get()) != null && isInWater) {
            living.m_5997_(0.0, -0.2, 0.0);
        }
        if (!(living.m_21124_((MobEffect)EffectInit.GRAVITY_WELL.get()) == null || living.m_20096_() || isInWater || living.m_20077_())) {
            living.m_5997_(0.0, -0.2, 0.0);
        }
        if (!living.m_21023_((MobEffect)EffectInit.SOAKED.get())) {
            Player player;
            if (!(!isWet || living instanceof Player && (player = (Player)living).m_5833_())) {
                living.m_7292_(new MobEffectInstance((MobEffect)EffectInit.SOAKED.get(), 300, 0));
            }
        } else if (living.m_6060_()) {
            living.m_7311_(0);
        }
        if (living instanceof Mob) {
            Mob monster = (Mob)living;
            LivingEntity target = monster.m_5448_();
            if (target != null) {
                Construct construct;
                MobEffectInstance effect2 = target.m_21124_((MobEffect)EffectInit.GREATER_INVISIBILITY.get());
                boolean clearTarget = false;
                if (effect2 != null && !ComponentTrueInvisibility.IsDisabledFor(target) && monster.m_20280_((Entity)target) > 3.0) {
                    clearTarget = true;
                }
                if ((effect2 = target.m_21124_(MobEffects.f_19609_)) != null && monster.m_20280_((Entity)target) > 16.0) {
                    clearTarget = true;
                }
                if ((effect2 = target.m_21124_((MobEffect)EffectInit.CAMOUFLAGE.get())) != null) {
                    float camoPercent = EffectCamouflage.getCamoflagePercent(target);
                    float disengageDistance = Mth.m_14179_((float)camoPercent, (float)8.0f, (float)50.0f);
                    if (monster.m_20280_((Entity)target) > (double)disengageDistance) {
                        clearTarget = true;
                    }
                }
                if ((effect2 = target.m_21124_((MobEffect)EffectInit.POSSESSION.get())) != null && effect2.m_19564_() == 2) {
                    clearTarget = true;
                }
                if (target instanceof Construct && (construct = (Construct)target).isDefeated()) {
                    clearTarget = true;
                }
                if (clearTarget) {
                    monster.m_6710_(null);
                }
            }
            if (SummonUtils.isSummon((Entity)monster) && SummonUtils.getSummoner((LivingEntity)monster) == null) {
                monster.m_6074_();
            }
        }
        if (living.m_9236_().m_5776_() && living.m_21255_()) {
            int count;
            BlockPos pos = living.m_20183_();
            BlockState state = living.m_9236_().m_8055_(pos);
            for (count = 0; state.m_60734_() != Blocks.f_49990_ && count < 3; ++count) {
                pos = pos.m_7495_();
                state = living.m_9236_().m_8055_(pos);
            }
            if (count < 3) {
                Vec3 c = Vec3.m_82512_((Vec3i)pos).m_82520_(-0.1, 0.5, -0.1);
                for (int i = 0; i < 5; ++i) {
                    Vec3 tempPos = c.m_82520_(Math.random() * 0.2, 0.0, Math.random() * 0.2);
                    living.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, tempPos.f_82479_, tempPos.f_82480_, tempPos.f_82481_, 0.0, 0.25, 0.0);
                }
            }
        }
        float desiredScale = 1.0f;
        CompoundTag tag = living.getPersistentData();
        float actualScale = tag.m_128457_("mna_entity_scale");
        float prevScale = tag.m_128457_("mna_entity_scale_prev");
        if (actualScale <= 0.0f) {
            actualScale = 1.0f;
        }
        if ((effect = living.m_21124_((MobEffect)EffectInit.REDUCE.get())) != null) {
            desiredScale -= 0.1f * (float)(effect.m_19564_() + 1);
        }
        if ((effect = living.m_21124_((MobEffect)EffectInit.ENLARGE.get())) != null) {
            Player player;
            desiredScale += 0.1f * (float)(effect.m_19564_() + 1);
            if (living instanceof Player && (player = (Player)living).m_36316_() != null && player.m_36316_().getId() != null && player.m_36316_().getId().toString() == "c10026c1-3b38-401a-8e4a-590cba8037b4") {
                desiredScale += 0.5f * (float)(effect.m_19564_() + 1);
            }
        }
        if (desiredScale < 0.2f) {
            desiredScale = 0.2f;
        } else if (desiredScale > 5.0f) {
            desiredScale = 5.0f;
        }
        if (desiredScale != actualScale) {
            float delta;
            float f = delta = desiredScale < actualScale ? -0.1f : 0.1f;
            if (Math.abs(desiredScale - actualScale) < 0.1f) {
                actualScale = desiredScale;
                delta = 0.0f;
            }
            tag.m_128350_("mna_entity_scale_prev", actualScale);
            tag.m_128350_("mna_entity_scale", actualScale + delta);
            living.m_6210_();
        } else if (actualScale != prevScale) {
            tag.m_128350_("mna_entity_scale_prev", actualScale);
            tag.m_128350_("mna_entity_scale", actualScale);
            living.m_6210_();
        }
    }

    @SubscribeEvent
    public static void onEntityChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (target != null && entity instanceof Mob) {
            Construct construct;
            Mob monster = (Mob)entity;
            boolean clearTarget = false;
            MobEffectInstance effect = target.m_21124_((MobEffect)EffectInit.GREATER_INVISIBILITY.get());
            if (effect != null && !ComponentTrueInvisibility.IsDisabledFor(event.getEntity()) && monster.m_20280_((Entity)target) > 3.0) {
                clearTarget = true;
            }
            if ((effect = target.m_21124_(MobEffects.f_19609_)) != null && monster.m_20280_((Entity)target) > 16.0) {
                clearTarget = true;
            }
            if ((effect = target.m_21124_((MobEffect)EffectInit.CAMOUFLAGE.get())) != null) {
                float camoPercent = EffectCamouflage.getCamoflagePercent(target);
                float disengageDistance = Mth.m_14179_((float)camoPercent, (float)8.0f, (float)50.0f);
                if (monster.m_20280_((Entity)target) > (double)disengageDistance) {
                    clearTarget = true;
                }
            }
            if (target instanceof Construct && (construct = (Construct)target).isDefeated()) {
                clearTarget = true;
            }
            if (clearTarget) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySizeChange(EntityEvent.Size event) {
        LivingEntity living;
        float scale;
        if (event.getEntity().isAddedToWorld() && event.getEntity() instanceof LivingEntity && (scale = (living = (LivingEntity)event.getEntity()).getPersistentData().m_128457_("mna_entity_scale")) != 1.0f) {
            event.setNewSize(event.getNewSize().m_20388_(scale));
            event.setNewEyeHeight(event.getNewEyeHeight() * scale);
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        MobEffectInstance enlorj;
        if (event.getEntity().m_21124_((MobEffect)EffectInit.PILGRIM.get()) != null) {
            event.getEntity().m_5997_((double)((float)(event.getEntity().m_20184_().f_82479_ * 0.15)), 0.25, (double)((float)(event.getEntity().m_20184_().f_82481_ * 0.15)));
        }
        if ((enlorj = event.getEntity().m_21124_((MobEffect)EffectInit.ENLARGE.get())) != null) {
            int amp = enlorj.m_19564_() + 1;
            event.getEntity().m_5997_((double)((float)(event.getEntity().m_20184_().f_82479_ * (0.1 * (double)amp))), 0.05 * (double)amp, (double)((float)(event.getEntity().m_20184_().f_82481_ * (0.1 * (double)amp))));
        }
        if (event.getEntity() instanceof Player) {
            int frostWalkerLevelOH;
            int frostWalkerLevelMH;
            int frostWalkerLevel;
            MobEffectInstance jumpEffect;
            Player player = (Player)event.getEntity();
            if (!((DemonArmorItem)ItemInit.DEMON_ARMOR_BOOTS.get()).handlePlayerJump(player) && GeneralConfigValues.FixJumpBoost && (jumpEffect = event.getEntity().m_21124_(MobEffects.f_19603_)) != null) {
                float multiplier = (float)event.getEntity().m_21133_(Attributes.f_22279_) * (float)jumpEffect.m_19564_();
                event.getEntity().m_5997_((double)((float)(event.getEntity().m_20184_().f_82479_ * (double)multiplier)), 0.0, (double)((float)(event.getEntity().m_20184_().f_82481_ * (double)multiplier)));
            }
            if (player.m_6047_() && !player.m_9236_().f_46443_ && (frostWalkerLevel = Math.max(frostWalkerLevelMH = player.m_21205_().m_41720_() instanceof MagicStaff ? player.m_21205_().getEnchantmentLevel(Enchantments.f_44974_) : 0, frostWalkerLevelOH = player.m_21206_().m_41720_() instanceof MagicStaff ? player.m_21206_().getEnchantmentLevel(Enchantments.f_44974_) : 0)) > 0) {
                player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                    if (p.getAlliedFaction() == Factions.UNDEAD) {
                        player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MIST_FORM.get(), 80 * frostWalkerLevel, 1));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().m_21124_((MobEffect)EffectInit.CHRONO_ANCHOR.get()) != null) {
            event.getEntity().m_21195_((MobEffect)EffectInit.CHRONO_ANCHOR.get());
        }
        SummonUtils.getSummons((LivingEntity)event.getEntity(), (Level)event.getEntity().m_20194_().m_129880_(event.getFrom())).forEach(s -> s.m_6074_());
        event.getEntity().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            m.setSyncGrimoire();
            m.setSyncRote();
            m.getCantripData().setNeedsSync();
            m.getCastingResource().setNeedsSync();
            m.forceSync();
        });
        ServerMessageDispatcher.sendWellspringPowerNetworkSyncMessage((ResourceKey<Level>)event.getTo(), (ServerPlayer)event.getEntity(), true);
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerWakeUpEvent event) {
        BlockPos bp = event.getEntity().m_20183_();
        BlockState bedState = event.getEntity().m_9236_().m_8055_(bp);
        if (bedState.m_60734_() == BlockInit.COFFIN.get()) {
            Player player = event.getEntity();
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                if (p.getAlliedFaction() == Factions.UNDEAD) {
                    long lastRestTime = player.getPersistentData().m_128454_("last_coffin_boost");
                    long curTime = player.m_9236_().m_46467_();
                    float pct = MathUtils.clamp01((float)(curTime - lastRestTime) / (float)GeneralConfigValues.UndeadCoffinSoulsDelay);
                    event.getEntity().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                        m.getCastingResource().restore((float)((double)m.getCastingResource().getMaxAmount() * GeneralConfigValues.UndeadCoffinSoulsRestored * (double)pct));
                        player.getPersistentData().m_128356_("last_coffin_boost", curTime);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent event) {
        Creeper creeper;
        Optional player;
        Entity entity = event.getExplosion().m_253049_();
        if (entity instanceof Creeper && (player = (creeper = (Creeper)entity).m_9236_().m_6443_(Player.class, creeper.m_20191_().m_82400_(5.0), p -> ((EnderguardAmulet)ItemInit.ENDERGUARD_AMULET.get()).isEquippedAndHasMana((LivingEntity)p, 50.0f, false)).stream().findFirst()).isPresent()) {
            CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player.get(), (Item)ItemInit.ENDERGUARD_AMULET.get()).ifPresent(t -> {
                if (((EnderguardAmulet)ItemInit.ENDERGUARD_AMULET.get()).consumeMana(t.stack(), 50.0f, (Player)player.get())) {
                    int count = 0;
                    while (count++ < 50) {
                        double z;
                        double y;
                        double x = creeper.m_20185_() + (creeper.m_217043_().m_188500_() - 0.5) * 32.0;
                        Vec3 newPos = new Vec3(x, y = Mth.m_14008_((double)(creeper.m_20186_() + (double)(creeper.m_217043_().m_188503_(16) - 8)), (double)0.0, (double)(creeper.m_9236_().m_141928_() - 1)), z = creeper.m_20189_() + (creeper.m_217043_().m_188500_() - 0.5) * 32.0);
                        if (!(newPos.m_82557_(((Player)player.get()).m_20182_()) >= 36.0) || !creeper.m_20984_(x, y, z, true)) continue;
                        event.setCanceled(true);
                        float f = creeper.m_7090_() ? 2.0f : 1.0f;
                        creeper.m_9236_().m_254849_(null, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), 3.0f * f, Level.ExplosionInteraction.MOB);
                        creeper.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                        break;
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Entity mount = event.getEntity().m_20202_();
        if (mount != null && mount instanceof Construct) {
            ((Construct)mount).soundHorn();
        }
    }

    @SubscribeEvent
    public static void onPlayerSize(EntityEvent.Size event) {
        MobEffectInstance mistForm;
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).m_21221_() != null && (mistForm = player.m_21124_((MobEffect)EffectInit.MIST_FORM.get())) != null && mistForm.m_19557_() > 5) {
            event.setNewSize(EntityDimensions.m_20398_((float)0.5f, (float)0.5f));
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof PathfinderMob && SummonUtils.isSummon((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityDropXP(LivingExperienceDropEvent event) {
        if (event.getEntity() instanceof PathfinderMob && SummonUtils.isSummon((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupXP(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            int enchantMagnitude;
            if (p.getAlliedFaction() == Factions.UNDEAD && (enchantMagnitude = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentInit.XP_TO_SOULS.get()), (LivingEntity)player)) > 0) {
                event.setCanceled(true);
                ExperienceOrb orb = event.getOrb();
                player.f_36101_ = 2;
                player.m_7938_((Entity)orb, 1);
                int souls = orb.f_20770_ * 5 * enchantMagnitude;
                orb.f_20770_ /= 2;
                if (orb.f_20770_ > 0) {
                    player.m_6756_(orb.f_20770_);
                }
                orb.m_142687_(Entity.RemovalReason.KILLED);
                player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().restore(souls));
            }
        });
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof AreaEffectCloud && ((AreaEffectCloud)event.getEntity()).f_19685_.stream().anyMatch(e -> e.m_19544_() instanceof INoCreeperLingering)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof LivingEntity) {
            event.getEntity().getPersistentData().m_128350_("mna_entity_scale", 1.0f);
            event.getEntity().getPersistentData().m_128350_("mna_entity_scale_prev", 1.0f);
        }
    }

    @SubscribeEvent
    public static void canEntityContinueSleeping(SleepingTimeCheckEvent event) {
        MobEffectInstance e = event.getEntity().m_21124_((MobEffect)EffectInit.COLD_DARK.get());
        if (e != null) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity owner;
        if (!event.getProjectile().m_9236_().m_5776_() && event.getProjectile() instanceof AbstractArrow && event.getProjectile().getPersistentData().m_128441_("return_on_next_arrow_shot") && (owner = ((AbstractArrow)event.getProjectile()).m_19749_()) != null && owner instanceof Player) {
            if (((AbstractArrow)event.getProjectile()).f_36705_ == AbstractArrow.Pickup.CREATIVE_ONLY && !((Player)owner).m_7500_()) {
                return;
            }
            if (((AbstractArrow)event.getProjectile()).f_36705_ == AbstractArrow.Pickup.DISALLOWED) {
                return;
            }
            ItemStack returnStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)event.getProjectile().getPersistentData().m_128423_("return_stack")));
            if (!returnStack.m_41619_() && !((Player)owner).m_7500_()) {
                boolean drop = true;
                if (event.getProjectile().getPersistentData().m_128471_("cannon_shot")) {
                    drop = !(returnStack = InventoryUtilities.mergeToPlayerInvPrioritizeOffhand((Player)owner, returnStack)).m_41619_();
                } else {
                    boolean bl = drop = !((Player)owner).m_36356_(returnStack);
                }
                if (drop) {
                    ((Player)owner).m_36176_(returnStack, true);
                }
            }
            event.getProjectile().m_146870_();
        }
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        ItemStack itemstack;
        if (event.hasAmmo() && event.getEntity() instanceof Player && !(itemstack = event.getEntity().m_6298_(event.getBow())).m_41619_() && itemstack.getEnchantmentLevel((Enchantment)EnchantmentInit.RETURNING.get()) > 0) {
            event.getEntity().getPersistentData().m_128379_("return_on_next_arrow_shot", true);
            ItemStack toReturn = itemstack.m_41777_();
            toReturn.m_41764_(1);
            event.getEntity().getPersistentData().m_128365_("return_stack", (Tag)toReturn.m_41739_(new CompoundTag()));
            return;
        }
        event.getEntity().getPersistentData().m_128473_("return_on_next_arrow_shot");
    }

    @SubscribeEvent
    public static void onEntityAddedToWorld(EntityJoinLevelEvent event) {
        EnderDragon dragon;
        EndDragonFight fight;
        AbstractArrow arrow;
        if (event.getEntity() instanceof AbstractArrow && (arrow = (AbstractArrow)event.getEntity()).m_19749_() != null && arrow.m_19749_().getPersistentData().m_128441_("return_on_next_arrow_shot")) {
            arrow.getPersistentData().m_128379_("return_on_next_arrow_shot", true);
            if (arrow.m_19749_().getPersistentData().m_128441_("return_stack")) {
                arrow.getPersistentData().m_128365_("return_stack", arrow.m_19749_().getPersistentData().m_128423_("return_stack"));
            }
            arrow.m_19749_().getPersistentData().m_128473_("return_on_next_arrow_shot");
            arrow.m_19749_().getPersistentData().m_128473_("return_stack");
        }
        if (!event.getEntity().m_9236_().m_5776_() && event.getEntity() instanceof EnderDragon && (fight = (dragon = (EnderDragon)event.getEntity()).m_31158_()) != null && fight.m_64099_()) {
            AABB search = dragon.m_20191_().m_82400_(256.0);
            List items = dragon.m_9236_().m_6249_((Entity)dragon, search, e -> e instanceof ItemEntity).stream().map(e -> (ItemEntity)e).collect(Collectors.toList());
            boolean foundChop = items.stream().anyMatch(e -> e.m_32055_().m_41720_() == Items.f_42485_ || e.m_32055_().m_41720_() == Items.f_42486_);
            boolean foundCookie = items.stream().anyMatch(e -> e.m_32055_().m_41720_() == Items.f_42572_);
            if (foundChop && foundCookie) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                PigDragon pd = new PigDragon(dragon.m_9236_());
                pd.m_146884_(dragon.m_20182_());
                dragon.m_9236_().m_7967_((Entity)pd);
                dragon.m_142687_(Entity.RemovalReason.DISCARDED);
                fight.m_64085_(dragon);
            } else {
                dragon.m_9236_().m_45955_(new TargetingConditions(false).m_26893_().m_148355_().m_26883_(256.0), null, search).stream().forEach(p -> p.m_213846_((Component)Component.m_237115_((String)"helptip.mna.pigdragon").m_130940_(ChatFormatting.AQUA)));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingGearChange(LivingEquipmentChangeEvent event) {
        int newLoyalty = event.getFrom().getEnchantmentLevel(Enchantments.f_44955_);
        SummonUtils.setBonusSummons(event.getEntity(), newLoyalty);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getEntity();
        Player original = event.getOriginal();
        CompoundTag soulbound_inventory = original.getPersistentData().m_128469_("mna_soulbound_inventory");
        CompoundTag soulbound_curios = original.getPersistentData().m_128469_("mna_soulbound_curios");
        CompoundTag last_death_data = original.getPersistentData().m_128469_("mna_last_death_data");
        for (int i = 0; i < original.m_150109_().m_6643_(); ++i) {
            if (!soulbound_inventory.m_128441_("slot_" + i)) continue;
            CompoundTag itemTag = soulbound_inventory.m_128469_("slot_" + i);
            ItemStack soulboundStack = ItemStack.m_41712_((CompoundTag)itemTag);
            player.m_150109_().m_6836_(i, soulboundStack);
        }
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(c -> c.getCurios().forEach((identifier, stackHandler) -> {
            if (soulbound_curios.m_128441_(identifier)) {
                CompoundTag tagForIdentifier = soulbound_curios.m_128469_(identifier);
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (!tagForIdentifier.m_128441_("slot_" + i)) continue;
                    CompoundTag itemTag = tagForIdentifier.m_128469_("slot_" + i);
                    ItemStack soulboundStack = ItemStack.m_41712_((CompoundTag)itemTag);
                    stackHandler.getStacks().setStackInSlot(i, soulboundStack);
                }
            }
        }));
        player.getPersistentData().m_128365_("mna_last_death_data", (Tag)last_death_data);
        player.getPersistentData().m_128473_("mna_soulbound_inventory");
        player.getPersistentData().m_128473_("mna_soulbound_curios");
    }

    public static void onCalculatingVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectInit.CAMOUFLAGE.get())) {
            float camoPercent = 1.0f - 0.6f * EffectCamouflage.getCamoflagePercent(event.getEntity());
            event.modifyVisibility((double)camoPercent);
        }
        if (event.getEntity().m_21023_((MobEffect)EffectInit.GREATER_INVISIBILITY.get()) && !ComponentTrueInvisibility.IsDisabledFor(event.getEntity())) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public static void onAdvancementComplete(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ServerMessageDispatcher.sendAdvancementUnlocked(sp, event.getAdvancement());
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level world = living.m_9236_();
            world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                if (m.isInterdicted(living, event.getPrev(), event.getTarget())) {
                    event.setCanceled(true);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        player.m_213846_((Component)Component.m_237115_((String)"gui.mna.interdicted"));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack outputStack = event.getCrafting();
        Container inventory = event.getInventory();
        ItemStack inputRune = ItemStack.f_41583_;
        int itemCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack ingredient = inventory.m_8020_(i);
            if (!ingredient.m_41619_()) {
                ++itemCount;
            }
            if (!(ingredient.m_41720_() instanceof ItemRuneMarking)) continue;
            inputRune = ingredient;
        }
        if (itemCount == 1 && outputStack.m_41720_() instanceof ItemRuneMarking) {
            ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).m_41115_(outputStack, ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).m_41121_(inputRune));
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.level.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().resetDiminishing());
            int chunkRadius = 5;
            float decayRate = 0.01f;
            HashSet<Long> tickedChunks = new HashSet<Long>();
            for (Player player : event.level.m_6907_()) {
                ChunkPos chunkPos = player.m_146902_();
                for (int i = -chunkRadius; i <= chunkRadius; ++i) {
                    for (int j = -chunkRadius; j <= chunkRadius; ++j) {
                        long currentChunkCoord;
                        if (!event.level.m_7232_(chunkPos.f_45578_ + i, chunkPos.f_45579_ + j) || tickedChunks.contains(currentChunkCoord = new ChunkPos(chunkPos.f_45578_ + i, chunkPos.f_45579_ + j).m_45588_())) continue;
                        tickedChunks.add(currentChunkCoord);
                        LevelChunk chunkData = event.level.m_6325_(chunkPos.f_45578_ + i, chunkPos.f_45579_ + j);
                        IChunkMagic chunkMagic = (IChunkMagic)chunkData.getCapability(ChunkMagicProvider.MAGIC).orElse(null);
                        if (chunkMagic == null || !(chunkMagic.getResidualMagic() > 0.0f)) continue;
                        chunkMagic.removeResidualMagic(decayRate);
                    }
                }
            }
        }
    }

    private static float getDistanceToGround(Player player) {
        float distance = 0.0f;
        BlockPos pos = player.m_20183_();
        while (pos.m_123342_() > player.m_9236_().m_141937_() && !player.m_9236_().m_8055_(pos).m_60638_((BlockGetter)player.m_9236_(), pos, (Entity)player, Direction.UP)) {
            distance += 1.0f;
            pos = pos.m_7495_();
        }
        return distance;
    }

    private static boolean isPlayerInDaylight(Player player) {
        if (player.m_9236_().m_46461_() && !player.m_9236_().m_5776_()) {
            BlockPos blockpos;
            float f = player.m_213856_();
            BlockPos blockPos = blockpos = player.m_20202_() instanceof Boat ? BlockPos.m_274561_((double)player.m_20185_(), (double)Math.round(player.m_20186_()), (double)player.m_20189_()).m_7494_() : BlockPos.m_274561_((double)player.m_20185_(), (double)Math.round(player.m_20186_()), (double)player.m_20189_());
            if (f > 0.5f && player.m_9236_().f_46441_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f && player.m_9236_().m_45527_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    private static BlockPos getExplosionExtent(Explosion explosion, Direction dir) {
        BlockPos pos = BlockPos.m_274446_((Position)explosion.getPosition());
        Vec3i offset = dir.m_122436_().m_142393_((int)Math.ceil(explosion.f_46017_));
        return pos.m_121955_(offset);
    }
}

