/*
 * Decompiled with CFR 0.152.
 */
package com.mna.events;

import com.mna.ManaAndArtifice;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.resource.CastingResourceIDs;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.DamageHelper;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.events.BonefeatherCharmUsedEvent;
import com.mna.api.events.CoalfeatherCharmUsedEvent;
import com.mna.api.events.ReedfeatherCharmUsedEvent;
import com.mna.api.items.ChargeableItem;
import com.mna.api.sound.SFX;
import com.mna.blocks.tileentities.pylon.RechargePylonTile;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.config.GeneralConfig;
import com.mna.effects.EffectInit;
import com.mna.effects.beneficial.EffectManaShield;
import com.mna.entities.boss.WitherLich;
import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.summon.BloodGolem;
import com.mna.entities.utility.DisplayDamage;
import com.mna.factions.Factions;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.items.armor.CouncilArmorItem;
import com.mna.items.armor.DemonArmorItem;
import com.mna.items.armor.FeyArmorItem;
import com.mna.items.artifice.WardingAmulet;
import com.mna.items.artifice.WitherguardAmulet;
import com.mna.items.artifice.charms.ContingencyCharm;
import com.mna.items.artifice.curio.EmberglowBracelet;
import com.mna.items.artifice.curio.FortifyingAmulet;
import com.mna.items.relic.CrystallizedWind;
import com.mna.items.sorcery.CrystalPhylactery;
import com.mna.items.sorcery.ItemSpell;
import com.mna.items.sorcery.PhylacteryStaff;
import com.mna.items.sorcery.bound.BoundShield;
import com.mna.spells.components.ComponentShacklesOfPain;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.BlockUtils;
import com.mna.tools.EntityUtil;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.ProjectileHelper;
import com.mna.tools.SummonUtils;
import com.mna.tools.TeleportHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageEventHandler {
    @SubscribeEvent(receiveCanceled=true)
    public static void onLivingFallAlways(LivingFallEvent event) {
        event.getEntity().getPersistentData().m_128473_("mna:flung");
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_21023_((MobEffect)EffectInit.MIST_FORM.get()) || CrystallizedWind.FindOn(event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        if (living.m_21023_((MobEffect)EffectInit.PILGRIM.get()) || living.m_21023_((MobEffect)EffectInit.ENLARGE.get()) || living.m_21023_((MobEffect)EffectInit.REDUCE.get())) {
            event.setDistance(event.getDistance() - 2.0f);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            Entity entity = player.m_20202_();
            if (entity instanceof Construct) {
                Construct ridingConstruct = (Construct)entity;
                event.setCanceled(true);
                return;
            }
            if (((DemonArmorItem)ItemInit.DEMON_ARMOR_BOOTS.get()).handlePlayerMeteorJumpImpact(player, event.getDistance())) {
                event.setCanceled(true);
                return;
            }
            if (player.m_21124_((MobEffect)EffectInit.GRAVITY_WELL.get()) != null) {
                event.setDistance(event.getDistance() * 2.0f);
            }
            if (player.m_150109_().m_8020_(EquipmentSlot.CHEST.m_20749_()).m_41720_() == ItemInit.SPECTRAL_ELYTRA.get()) {
                event.setDistance(event.getDistance() - 5.0f);
            }
            if (!event.isCanceled()) {
                DamageEventHandler.checkAndConsumeBonefeather(event, player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        LivingEntity living = event.getEntity();
        if (living == null || source == null) {
            return;
        }
        if (source.m_276093_(DamageTypes.f_268612_) && (living.m_21023_((MobEffect)EffectInit.MIST_FORM.get()) || living.m_21023_((MobEffect)EffectInit.ELDRIN_FLIGHT.get()) || living.m_21023_((MobEffect)EffectInit.POSSESSION.get()) && living.m_21124_((MobEffect)EffectInit.POSSESSION.get()).m_19564_() == 2)) {
            event.setCanceled(true);
            return;
        }
        if (living instanceof Player) {
            if (DamageEventHandler.checkAndConsumeReedfeather(event, (Player)living)) {
                return;
            }
            if (DamageEventHandler.checkAndConsumeCoalfeather(event, (Player)living)) {
                return;
            }
        }
        if (!(!living.m_21023_((MobEffect)EffectInit.FORTIFICATION.get()) || source.m_269533_(DamageTypeTags.f_268549_) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268724_) || source.m_269533_(DamageTypeTags.f_268630_))) {
            event.setCanceled(true);
            living.m_6469_(DamageHelper.createSourcedType((ResourceKey<DamageType>)DamageTypes.f_268724_, living.m_9236_().m_9598_(), source.m_7639_()), (float)GeneralConfigValues.FossilizeDamage);
            return;
        }
        if (source.m_7640_() instanceof Projectile) {
            boolean shouldReflect = false;
            boolean shouldReflectAtShooter = false;
            Entity sourceEntity = source.m_7639_();
            if (living.m_21023_((MobEffect)EffectInit.WIND_WALL.get()) && (sourceEntity == null || sourceEntity.m_6072_())) {
                shouldReflect = true;
                MobEffectInstance windWall = living.m_21124_((MobEffect)EffectInit.WIND_WALL.get());
                if (windWall != null) {
                    shouldReflectAtShooter = windWall.m_19564_() > 0;
                }
            } else if (event.getEntity() instanceof Player) {
                Player player = (Player)event.getEntity();
                if (((CouncilArmorItem)ItemInit.COUNCIL_ARMOR__CHEST.get()).isSetEquipped(living)) {
                    shouldReflect = CouncilArmorItem.consumeReflectCharget(player);
                    shouldReflectAtShooter = true;
                } else if (((FeyArmorItem)ItemInit.FEY_ARMOR_CHEST.get()).isSetEquipped(living)) {
                    shouldReflect = FeyArmorItem.randomReflectChance();
                    shouldReflectAtShooter = true;
                }
            }
            if (shouldReflect) {
                event.setCanceled(true);
                ProjectileHelper.ReflectProjectile(living, (Projectile)source.m_7640_(), shouldReflectAtShooter, 10.0f);
                return;
            }
        }
        if (!source.m_269533_(DamageTypeTags.f_268524_) && source.m_7639_() != null && source.m_7639_() instanceof LivingEntity && source.m_7639_().m_20280_((Entity)event.getEntity()) < GeneralConfigValues.MeleeDistance && ((FeyArmorItem)ItemInit.FEY_ARMOR_CHEST.get()).isSetEquipped(living) && FeyArmorItem.randomTeleportChance() && TeleportHelper.randomTeleport((LivingEntity)source.m_7639_(), 16.0f, 10)) {
            event.setCanceled(true);
            return;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            if (((DemonArmorItem)ItemInit.DEMON_ARMOR_CHEST.get()).isSetEquipped(living)) {
                event.setCanceled(true);
                return;
            }
            if (((EmberglowBracelet)ItemInit.EMBERGLOW_BRACELET.get()).isEquippedAndHasMana(living, 1.0f, true)) {
                event.setCanceled(true);
                return;
            }
        }
        if (source.m_269533_(DamageTypeTags.f_268415_) && ((DemonArmorItem)ItemInit.DEMON_ARMOR_CHEST.get()).isSetEquipped(living)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        LivingEntity hurtEntity = event.getEntity();
        if ((event.getSource().m_269533_(DamageTypeTags.f_268549_) || event.getSource().m_276093_(DamageTypes.f_268576_)) && CrystallizedWind.FindOn(hurtEntity)) {
            event.setCanceled(true);
            return;
        }
        if (source != null && source instanceof LivingEntity) {
            double dist;
            boolean retaliate;
            int amplifier;
            LivingEntity sourceLiving = (LivingEntity)source;
            if (event.getSource().m_269533_(DamageTypeTags.f_268731_)) {
                if (hurtEntity.m_21023_((MobEffect)EffectInit.AMPLIFY_MAGIC.get())) {
                    amplifier = hurtEntity.m_21124_((MobEffect)EffectInit.AMPLIFY_MAGIC.get()).m_19564_() + 1;
                    event.setAmount(event.getAmount() * (1.0f + (float)amplifier * 0.1f));
                }
                if (hurtEntity.m_21023_((MobEffect)EffectInit.DAMPEN_MAGIC.get())) {
                    amplifier = hurtEntity.m_21124_((MobEffect)EffectInit.DAMPEN_MAGIC.get()).m_19564_() + 1;
                    event.setAmount(event.getAmount() * (1.0f - (float)amplifier * 0.1f));
                }
            }
            if (hurtEntity.m_21023_((MobEffect)EffectInit.FRAILTY.get())) {
                amplifier = hurtEntity.m_21124_((MobEffect)EffectInit.FRAILTY.get()).m_19564_() + 1;
                event.setAmount(event.getAmount() * (1.0f + (float)amplifier * 0.2f));
            }
            boolean bl = retaliate = (dist = hurtEntity.m_20280_((Entity)sourceLiving)) <= 25.0;
            if (retaliate && hurtEntity.m_21211_().m_41720_() == ItemInit.BOUND_SHIELD.get() && DamageEventHandler.canEntityBlock(event.getSource(), hurtEntity)) {
                SpellRecipe recipe = ((BoundShield)ItemInit.BOUND_SHIELD.get()).getRecipe(hurtEntity.m_21211_());
                if (hurtEntity instanceof Player) {
                    Player player = (Player)hurtEntity;
                    if (!player.m_36335_().m_41519_((Item)ItemInit.BOUND_SHIELD.get())) {
                        ((BoundShield)ItemInit.BOUND_SHIELD.get()).affectTarget(recipe, hurtEntity, sourceLiving, hurtEntity.m_7655_());
                        player.m_36335_().m_41524_((Item)ItemInit.BOUND_SHIELD.get(), recipe.getCooldown((LivingEntity)player));
                    }
                } else {
                    ((BoundShield)ItemInit.BOUND_SHIELD.get()).affectTarget(recipe, hurtEntity, sourceLiving, hurtEntity.m_7655_());
                }
            }
        }
        boolean reduce = !event.getSource().m_269533_(DamageTypeTags.f_268738_) && !event.getSource().m_269533_(DamageTypeTags.f_268549_) && !event.getSource().m_276093_(DamageTypes.f_268612_) && !event.getSource().m_276093_(DamageTypes.f_268441_) && !event.getSource().m_269533_(DamageTypeTags.f_268581_) && !event.getSource().m_276093_(DamageTypes.f_268613_) && !event.getSource().m_269533_(DamageTypeTags.f_268630_);
        MobEffectInstance mana_shield = hurtEntity.m_21124_((MobEffect)EffectInit.MANA_SHIELD.get());
        if (mana_shield != null && reduce && event.getSource().m_7639_() != null) {
            Player mana_shield_source = DamageEventHandler.resolveManaShieldSource((Entity)hurtEntity);
            if (mana_shield_source != null) {
                float reduction = mana_shield.m_19564_() + 1;
                float reductionCost = ((EffectManaShield)EffectInit.MANA_SHIELD.get()).getReductionCost(mana_shield.m_19564_() + 1);
                mana_shield_source.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    float amountReduced = reduction;
                    if (m.getCastingResource().getAmount() <= amountReduced * reductionCost) {
                        amountReduced = m.getCastingResource().getAmount() / reductionCost;
                    }
                    m.getCastingResource().consume((LivingEntity)mana_shield_source, amountReduced * reductionCost);
                    m.forceSync(1);
                    if (m.getCastingResource().getAmount() <= 0.0f) {
                        hurtEntity.m_21195_((MobEffect)EffectInit.MANA_SHIELD.get());
                    }
                    event.setAmount(event.getAmount() - amountReduced);
                });
            } else {
                hurtEntity.m_21195_((MobEffect)EffectInit.MANA_SHIELD.get());
            }
            if (event.getAmount() == 0.0f) {
                event.setCanceled(true);
                return;
            }
        }
        if (source instanceof Player) {
            Player sourcePlayer = (Player)source;
            if (!(event.getSource().m_269533_(DamageTypeTags.f_268731_) || event.getSource().m_269533_(DamageTypeTags.f_268524_) || event.getSource().m_269533_(DamageTypeTags.f_268745_) || event.getSource().m_269533_(DamageTypeTags.f_268415_) || event.getSource().m_269533_(DamageTypeTags.f_268549_) || !((double)source.m_20270_((Entity)hurtEntity) <= GeneralConfigValues.MeleeDistance))) {
                IPlayerMagic magic;
                boolean offhandIsSword;
                ItemStack mainHand = sourcePlayer.m_21205_();
                ItemStack offHand = sourcePlayer.m_21206_();
                boolean mainHandIsSword = mainHand.m_41720_() instanceof SwordItem || mainHand.m_41720_() == ItemInit.ASTRO_BLADE.get() || mainHand.m_41720_() == ItemInit.BONE_SCYTHE.get();
                boolean bl = offhandIsSword = offHand.m_41720_() instanceof SwordItem || offHand.m_41720_() == ItemInit.ASTRO_BLADE.get() || offHand.m_41720_() == ItemInit.BONE_SCYTHE.get();
                if ((mainHandIsSword && offHand.m_41720_() instanceof ItemSpell || offhandIsSword && mainHand.m_41720_() instanceof ItemSpell) && CuriosInterop.IsItemInCurioSlot((Item)ItemInit.BATTLEMAGE_AMULET.get(), (LivingEntity)sourcePlayer, SlotTypePreset.NECKLACE) && (magic = (IPlayerMagic)sourcePlayer.getCapability(PlayerMagicProvider.MAGIC).orElse(null)) != null) {
                    float pct = 1.0f - magic.getCastingResource().getAmount() / magic.getCastingResource().getMaxAmount();
                    event.setAmount(event.getAmount() + 5.0f * pct);
                }
            }
        }
        if (event.getAmount() > 0.0f) {
            MobEffectInstance lev;
            Player player;
            if (hurtEntity instanceof Player && !CrystallizedWind.FindOn((LivingEntity)(player = (Player)hurtEntity)) && (lev = hurtEntity.m_21124_((MobEffect)EffectInit.LEVITATION.get())) != null) {
                Player target = (Player)event.getEntity();
                boolean wasFlying = target.m_150110_().f_35935_;
                int amplifier = lev.m_19564_();
                int duration = lev.m_267577_() ? 1200 : lev.m_19557_();
                target.m_21195_((MobEffect)EffectInit.LEVITATION.get());
                if ((duration /= 2) > 100) {
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectInit.LEVITATION.get(), duration, amplifier));
                    ManaAndArtifice.instance.proxy.setFlightEnabled(target, true);
                    target.m_150110_().f_35935_ = wasFlying;
                }
            }
            if (hurtEntity.m_21023_((MobEffect)EffectInit.BIND_WOUNDS.get())) {
                hurtEntity.m_21195_((MobEffect)EffectInit.BIND_WOUNDS.get());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity living;
        Entity source;
        boolean reduce;
        MobEffectInstance fire_shield = event.getEntity().m_21124_((MobEffect)EffectInit.FIRE_SHIELD.get());
        MobEffectInstance briar_shield = event.getEntity().m_21124_((MobEffect)EffectInit.BRIARTHORN_BARRIER.get());
        MobEffectInstance life_tap = event.getEntity().m_21124_((MobEffect)EffectInit.LIFE_TAP.get());
        boolean bl = reduce = !event.getSource().m_269533_(DamageTypeTags.f_268738_) && !event.getSource().m_269533_(DamageTypeTags.f_268549_) && !event.getSource().m_276093_(DamageTypes.f_268612_) && !event.getSource().m_276093_(DamageTypes.f_268441_) && !event.getSource().m_269533_(DamageTypeTags.f_268581_) && !event.getSource().m_276093_(DamageTypes.f_268613_) && !event.getSource().m_269533_(DamageTypeTags.f_268630_);
        if (event.getSource().m_276093_(DamageTypes.f_268493_) && ((WitherguardAmulet)ItemInit.WITHERGUARD_AMULET.get()).isEquippedAndHasMana(event.getEntity(), 1.0f, true)) {
            event.setCanceled(true);
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getPersistentData().m_128471_("hellfiretrident")) {
                if (player.f_20938_ > 0 && event.getSource().m_19385_() == "player") {
                    event.setAmount(event.getAmount() * 2.0f);
                }
                player.getPersistentData().m_128379_("hellfiretrident", false);
            }
            EntityUtil.suppressInvisibilityEffects((LivingEntity)player);
        }
        if (reduce && event.getSource().m_269533_(DamageTypeTags.f_268731_) && ((WardingAmulet)ItemInit.WARDING_AMULET.get()).isEquippedAndHasMana(event.getEntity(), 1.0f, true)) {
            event.setAmount(event.getAmount() - event.getAmount() * 0.2f);
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268745_) && fire_shield != null && reduce) {
            float reduction = event.getAmount() * 0.1f * (float)(fire_shield.m_19564_() + 1);
            event.setAmount(event.getAmount() - reduction);
        }
        if ((source = event.getSource().m_7639_()) != null && source instanceof LivingEntity) {
            LivingEntity sourceLiving = (LivingEntity)source;
            if (source != event.getEntity()) {
                boolean retaliate;
                living = event.getEntity();
                double dist = living.m_20280_((Entity)sourceLiving);
                boolean bl2 = retaliate = dist <= 25.0;
                if (retaliate && event.getEntity().m_21211_().m_41720_() == ItemInit.BOUND_SHIELD.get() && DamageEventHandler.canEntityBlock(event.getSource(), living)) {
                    SpellRecipe recipe = ((BoundShield)ItemInit.BOUND_SHIELD.get()).getRecipe(living.m_21211_());
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        if (!player.m_36335_().m_41519_((Item)ItemInit.BOUND_SHIELD.get())) {
                            ((BoundShield)ItemInit.BOUND_SHIELD.get()).affectTarget(recipe, living, sourceLiving, living.m_7655_());
                            player.m_36335_().m_41524_((Item)ItemInit.BOUND_SHIELD.get(), recipe.getCooldown((LivingEntity)player));
                        }
                    } else {
                        ((BoundShield)ItemInit.BOUND_SHIELD.get()).affectTarget(recipe, living, sourceLiving, living.m_7655_());
                    }
                }
                if (briar_shield != null) {
                    if (event.getSource().m_19385_().equals("thorns") || event.getSource().m_19385_().equals("poison") || event.getSource().m_19385_().equals("sting") || event.getSource().m_19385_().equals("cactus") || event.getSource().m_19385_().equals("sweetBerryBush")) {
                        float reduction = event.getAmount() * 0.1f * (float)(briar_shield.m_19564_() + 1);
                        event.setAmount(event.getAmount() - reduction);
                    }
                    if (retaliate) {
                        float damage = (briar_shield.m_19564_() + 1) * 2;
                        sourceLiving.m_6469_(DamageHelper.forType(DamageHelper.BRIARS, sourceLiving.m_9236_().m_9598_()), damage * GeneralConfig.getDamageMultiplier());
                    }
                }
                if (fire_shield != null && retaliate) {
                    float damage = (fire_shield.m_19564_() + 1) * 2;
                    sourceLiving.m_6469_(sourceLiving.m_269291_().m_269387_(), damage * GeneralConfig.getDamageMultiplier());
                }
                if (life_tap != null) {
                    float pct = 0.05f;
                    if (sourceLiving.getPersistentData().m_128441_("life_tap_pct")) {
                        pct = sourceLiving.getPersistentData().m_128457_("life_tap_pct");
                    }
                    float healing = event.getAmount() * pct * (float)(life_tap.m_19564_() + 1);
                    sourceLiving.m_5634_(healing);
                }
                if (source instanceof Player) {
                    Player sourcePlayer = (Player)source;
                    ItemStack mhStack = sourcePlayer.m_21205_();
                    ItemStack ohStack = sourcePlayer.m_21206_();
                    if (!event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
                        CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)sourcePlayer, (Item)ItemInit.EMBERGLOW_BRACELET.get()).ifPresent(t -> {
                            if (living.m_20280_(source) < 4.0) {
                                living.m_20254_(4);
                            }
                            t.stack().m_41622_(1, living, damager -> CuriosApi.getCuriosHelper().onBrokenCurio(t.slotContext()));
                        });
                    }
                    if (sourcePlayer.m_6144_() && sourcePlayer.m_21205_().m_41619_()) {
                        CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)sourcePlayer, (Item)ItemInit.TRICKERY_BRACELET.get()).ifPresent(t -> {
                            living.m_147240_(5.0, sourcePlayer.m_20185_() - living.m_20185_(), sourcePlayer.m_20189_() - living.m_20189_());
                            t.stack().m_41622_(1, living, damager -> CuriosApi.getCuriosHelper().onBrokenCurio(t.slotContext()));
                        });
                    }
                    sourcePlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                        int ohThorns;
                        int mhThorns;
                        int appliedThorns;
                        if (p.getAlliedFaction() == Factions.UNDEAD) {
                            float souls;
                            if (sourcePlayer.getPersistentData().m_128471_("bone_armor_set_bonus") && (souls = EntityUtil.getSoulsRestored(sourcePlayer, (Entity)living)) > 0.0f) {
                                sourcePlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                                    m.getCastingResource().restore(souls * 0.1f);
                                    m.getCastingResource().setNeedsSync();
                                });
                            }
                            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)sourcePlayer, (Item)ItemInit.COWL_OF_CONSUMPTION.get()) != null && event.getAmount() >= 10.0f) {
                                sourcePlayer.m_36324_().m_38707_(1, 0.1f);
                            }
                        }
                        if (p.getAlliedFaction() == Factions.FEY && (appliedThorns = Math.max(mhThorns = mhStack.getEnchantmentLevel(Enchantments.f_44972_), ohThorns = ohStack.getEnchantmentLevel(Enchantments.f_44972_))) > 0) {
                            living.m_7292_(new MobEffectInstance((MobEffect)EffectInit.WRITHING_BRAMBLES.get(), 100, appliedThorns));
                        }
                    });
                    if (living instanceof Mob) {
                        int mhLure = mhStack.getEnchantmentLevel(Enchantments.f_44954_);
                        int ohLure = ohStack.getEnchantmentLevel(Enchantments.f_44954_);
                        int appliedLure = Math.max(mhLure, ohLure);
                        if (Math.random() < 0.15 * (double)appliedLure) {
                            ((Mob)living).m_6710_((LivingEntity)sourcePlayer);
                        }
                    }
                }
            }
        }
        if (event.getAmount() <= 0.0f) {
            event.setCanceled(true);
        } else if (event.getEntity().getPersistentData().m_128471_("bone_armor_set_bonus") && !event.getSource().m_269533_(DamageTypeTags.f_268738_) && event.getEntity().m_21223_() > 1.0f && event.getAmount() > event.getEntity().m_21223_()) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)EffectInit.MIST_FORM.get(), 200, 0, true, true));
            event.getEntity().m_21153_(1.0f);
            event.setCanceled(true);
        }
        living = event.getEntity();
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            if (!event.isCanceled()) {
                MobEffectInstance effect;
                if (player.m_21223_() <= player.m_21233_() * 0.25f) {
                    ContingencyCharm.CheckAndConsumeCharmCharge(player, ContingencyCharm.ContingencyEvent.LOW_HEALTH);
                } else if (event.getSource().m_276093_(DamageTypes.f_268612_) || event.getSource().m_269533_(DamageTypeTags.f_268581_)) {
                    ContingencyCharm.CheckAndConsumeCharmCharge(player, ContingencyCharm.ContingencyEvent.SUFFOCATION);
                } else {
                    ContingencyCharm.CheckAndConsumeCharmCharge(player, ContingencyCharm.ContingencyEvent.DAMAGE);
                }
                LivingEntity shackledTo = ComponentShacklesOfPain.getShackleTarget((Player)player);
                if (shackledTo != null && shackledTo != player && (effect = shackledTo.m_21124_((MobEffect)EffectInit.SHACKLES_OF_PAIN.get())) != null) {
                    int amplifier = effect.m_19564_() + 1;
                    shackledTo.m_6469_(shackledTo.m_269291_().m_269425_(), event.getAmount() * (float)amplifier);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        Player playerCause;
        Entity causeOfDeath = event.getSource().m_7639_();
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Optional curio = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ItemInit.CRIT_IMMUNITY_AMULET.get());
            if (curio.isPresent() && !player.m_36335_().m_41519_((Item)ItemInit.CRIT_IMMUNITY_AMULET.get()) && ((FortifyingAmulet)ItemInit.CRIT_IMMUNITY_AMULET.get()).consumeMana(((SlotResult)curio.get()).stack(), 250.0f, player)) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Spell.Buff.ARCANE, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_((Item)ItemInit.CRIT_IMMUNITY_AMULET.get(), 12000);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 4));
                if (player.m_21223_() < 1.0f) {
                    player.m_21153_(1.0f);
                }
                event.setCanceled(true);
                return;
            }
            if (player.m_21124_((MobEffect)EffectInit.CHRONO_ANCHOR.get()) != null) {
                player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    if (m.getChronoAnchorData().canRevert(player)) {
                        event.setCanceled(true);
                        player.m_21195_((MobEffect)EffectInit.CHRONO_ANCHOR.get());
                    }
                });
            } else {
                SummonUtils.getSummons((LivingEntity)player).forEach(s -> s.m_146870_());
            }
            if (player.m_21023_((MobEffect)EffectInit.LIFT.get())) {
                player.m_21195_((MobEffect)EffectInit.LIFT.get());
            }
            if (player.m_21023_((MobEffect)EffectInit.MIND_VISION.get())) {
                player.m_21195_((MobEffect)EffectInit.MIND_VISION.get());
            }
            if (player.m_21023_((MobEffect)EffectInit.POSSESSION.get())) {
                player.m_21195_((MobEffect)EffectInit.POSSESSION.get());
            }
            if (player instanceof ServerPlayer) {
                ContingencyCharm.CheckAndConsumeCharmCharge((ServerPlayer)player, ContingencyCharm.ContingencyEvent.DEATH);
            }
            CompoundTag deathData = new CompoundTag();
            deathData.m_128356_("position", player.m_20183_().m_7494_().m_121878_());
            deathData.m_128359_("dimension", player.m_9236_().m_46472_().m_135782_().toString());
            player.getPersistentData().m_128365_("mna_last_death_data", (Tag)deathData);
        } else {
            LivingEntity player = event.getEntity();
            if (player instanceof Mob) {
                Mob mob = (Mob)player;
                boolean isSummon = SummonUtils.isSummon((Entity)mob);
                if (isSummon && !(mob instanceof BloodGolem)) {
                    event.setCanceled(true);
                    event.getEntity().m_21153_(1.0f);
                    event.getEntity().m_146870_();
                    return;
                }
                if (causeOfDeath != null && causeOfDeath instanceof Player) {
                    LivingEntity summoner;
                    Player playerCause2 = (Player)causeOfDeath;
                    if (!isSummon && !(event.getEntity() instanceof Construct)) {
                        ItemStack mainHand = playerCause2.m_21205_();
                        ItemStack offHand = playerCause2.m_21206_();
                        boolean added = false;
                        EntityType type = event.getEntity().m_6095_();
                        int amount = playerCause2.m_7500_() ? 100 : 1;
                        Level level = causeOfDeath.m_9236_();
                        IPlayerProgression progression = (IPlayerProgression)playerCause2.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                        if (progression != null && progression.getAlliedFaction() == Factions.UNDEAD) {
                            amount *= 5;
                        }
                        if (mainHand.m_41720_() == ItemInit.STAFF_PHYLACTERY.get()) {
                            added = PhylacteryStaff.addToPhylactery(mainHand, (EntityType<? extends Mob>)type, amount, level);
                        }
                        if (!added && offHand.m_41720_() == ItemInit.STAFF_PHYLACTERY.get()) {
                            added = PhylacteryStaff.addToPhylactery(offHand, (EntityType<? extends Mob>)type, amount, level);
                        }
                        if (!added) {
                            ItemStack backPhylactery = ItemStack.f_41583_;
                            List results = CuriosApi.getCuriosHelper().findCurios((LivingEntity)((Player)causeOfDeath), is -> is.m_41720_() == ItemInit.STAFF_PHYLACTERY.get() || is.m_41720_() == ItemInit.CRYSTAL_PHYLACTERY.get());
                            for (SlotResult sr : results) {
                                if (sr.stack().m_41619_()) continue;
                                backPhylactery = sr.stack();
                                break;
                            }
                            if (!backPhylactery.m_41619_()) {
                                added = PhylacteryStaff.addToPhylactery(backPhylactery, (EntityType<? extends Mob>)type, amount, level);
                            }
                            if (!added) {
                                CrystalPhylactery.addToPhylactery((Container)playerCause2.m_150109_(), (EntityType<? extends Mob>)type, (float)amount, level, true);
                            }
                        }
                    }
                    if (GeneralConfigValues.FactionMobKillIre && event.getEntity() instanceof IFactionEnemy) {
                        playerCause2.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> p.incrementFactionAggro(((IFactionEnemy)event.getEntity()).getFaction(), 0.025f, 0.05f));
                    }
                    SummonUtils.getSummons(event.getEntity()).forEach(s -> s.m_146870_());
                    if (SummonUtils.isSummon((Entity)event.getEntity()) && (summoner = SummonUtils.getSummoner(event.getEntity())) != null && summoner instanceof WitherLich) {
                        ((WitherLich)summoner).decrementSummons();
                    }
                }
            }
        }
        Player soulRecipient = causeOfDeath instanceof Player ? (playerCause = (Player)causeOfDeath) : null;
        float soulsMultiplier = 1.0f;
        if (causeOfDeath instanceof LivingEntity) {
            LivingEntity livingCause = (LivingEntity)causeOfDeath;
            if (SummonUtils.isSummon((Entity)livingCause)) {
                soulRecipient = SummonUtils.getSummonerAsPlayer(livingCause);
            } else if (livingCause instanceof Construct) {
                Construct construct = (Construct)livingCause;
                soulRecipient = construct.getOwner();
                soulsMultiplier = (float)construct.getConstructData().getPartsForMaterial(ConstructMaterial.BONE).size() * 0.2f;
            }
        }
        if (soulRecipient != null && soulsMultiplier > 0.0f) {
            float soulsRestored = EntityUtil.getSoulsRestored(soulRecipient, (Entity)event.getEntity()) * soulsMultiplier;
            soulRecipient.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getCastingResource().getRegistryName().equals((Object)CastingResourceIDs.SOULS)) {
                    m.getCastingResource().restore(soulsRestored);
                    m.getCastingResource().setNeedsSync();
                }
            });
            if (event.getEntity().m_21023_((MobEffect)EffectInit.SOUL_TRAP.get())) {
                int restored = Math.max((int)Math.ceil(soulsRestored / 500.0f), 50);
                soulRecipient.m_150109_().f_35975_.forEach(is -> RechargePylonTile.rechargeItem(is, restored));
                soulRecipient.m_150109_().f_35974_.forEach(is -> RechargePylonTile.rechargeItem(is, restored));
                soulRecipient.m_150109_().f_35976_.forEach(is -> RechargePylonTile.rechargeItem(is, restored));
                CuriosApi.getCuriosInventory((LivingEntity)soulRecipient).ifPresent(handler -> handler.findCurios(is -> is.m_41720_() instanceof ChargeableItem).forEach(slotResult -> RechargePylonTile.rechargeItem(slotResult.stack(), restored)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackTarget(AttackEntityEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectInit.MIST_FORM.get())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        } else {
            EntityUtil.suppressInvisibilityEffects((LivingEntity)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDamage_Insight(LivingDamageEvent event) {
        float insightRange = 16.0f;
        if (!event.getEntity().m_9236_().m_5776_()) {
            boolean shouldSpawn;
            boolean bl = shouldSpawn = event.getEntity().m_9236_().m_45955_(TargetingConditions.m_148353_().m_148355_().m_26893_().m_26883_((double)insightRange).m_26888_(le -> le.m_21023_((MobEffect)EffectInit.INSIGHT.get())), event.getEntity(), event.getEntity().m_20191_().m_82400_((double)insightRange)).stream().map(p -> (ServerPlayer)p).toList().size() > 0;
            if (shouldSpawn) {
                Vec3 pos = event.getEntity().m_146892_().m_82549_(new Vec3(-0.5 + Math.random(), 0.0, -0.5 + Math.random()));
                float amount = Math.max(event.getAmount(), 0.0f);
                DisplayDamage edd = new DisplayDamage(event.getEntity().m_9236_(), event.getSource(), amount);
                edd.m_146884_(pos);
                event.getEntity().m_9236_().m_7967_((Entity)edd);
            }
        }
    }

    public static void onCriticalHit(CriticalHitEvent event) {
        if (event.getTarget() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)event.getTarget();
            Optional curio = CuriosApi.getCuriosHelper().findFirstCurio(living, (Item)ItemInit.CRIT_IMMUNITY_AMULET.get());
            if (curio.isPresent()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        if (event.getEntity() instanceof Construct) {
            ((Construct)event.getEntity()).onShieldBlock();
        }
    }

    @SubscribeEvent
    public static void onLivingHealed(LivingHealEvent event) {
        if (event.getEntity().m_21023_((MobEffect)EffectInit.CURSE_OF_AGONY.get()) && event.getAmount() > 1.0f) {
            event.getEntity().m_21195_((MobEffect)EffectInit.CURSE_OF_AGONY.get());
        }
    }

    private static boolean canEntityBlock(DamageSource damageSource, LivingEntity living) {
        Vec3 vector3d2;
        AbstractArrow abstractarrowentity;
        Entity entity = damageSource.m_7640_();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (abstractarrowentity = (AbstractArrow)entity).m_36796_() > 0) {
            flag = true;
        }
        if (!damageSource.m_269533_(DamageTypeTags.f_268490_) && living.m_21254_() && !flag && (vector3d2 = damageSource.m_7270_()) != null) {
            Vec3 vector3d = living.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(living.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            if (vector3d1.m_82526_(vector3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static int calculateFallDamage(LivingEntity entity, float distance, float damageMult) {
        MobEffectInstance effectinstance = entity.m_21124_(MobEffects.f_19603_);
        float f = effectinstance == null ? 0.0f : (float)(effectinstance.m_19564_() + 1);
        return Mth.m_14167_((float)((distance - 3.0f - f) * damageMult));
    }

    private static void checkAndConsumeBonefeather(LivingFallEvent event, Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        int damage = DamageEventHandler.calculateFallDamage((LivingEntity)player, event.getDistance(), event.getDamageMultiplier());
        if ((float)damage > player.m_21223_()) {
            ItemStack charmStack = new ItemStack((ItemLike)ItemInit.FALL_CHARM.get());
            boolean consumed_fall_charm = false;
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.FALL_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM)) {
                consumed_fall_charm = true;
                CuriosInterop.DamageCurioInSlot((Item)ItemInit.FALL_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM, 999);
            } else if (InventoryUtilities.removeItemFromInventory(charmStack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_()))) {
                consumed_fall_charm = true;
            }
            if (consumed_fall_charm) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
                BonefeatherCharmUsedEvent bfe = new BonefeatherCharmUsedEvent(player);
                MinecraftForge.EVENT_BUS.post((Event)bfe);
                if (player instanceof ServerPlayer) {
                    CustomAdvancementTriggers.USE_CHARM.trigger((ServerPlayer)player, charmStack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ItemInit.FALL_CHARM.get())));
                    CustomAdvancementTriggers.SHAMAN.trigger((ServerPlayer)player);
                }
            }
        }
    }

    private static boolean checkAndConsumeReedfeather(LivingAttackEvent event, Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return false;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268581_)) {
            ItemStack charmStack = new ItemStack((ItemLike)ItemInit.DROWN_CHARM.get());
            boolean consumed_charm = false;
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.DROWN_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM)) {
                consumed_charm = true;
                CuriosInterop.DamageCurioInSlot((Item)ItemInit.DROWN_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM, 999);
            } else if (InventoryUtilities.removeItemFromInventory(charmStack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_()))) {
                consumed_charm = true;
            }
            if (consumed_charm) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
                ReedfeatherCharmUsedEvent bfe = new ReedfeatherCharmUsedEvent(player);
                MinecraftForge.EVENT_BUS.post((Event)bfe);
                if (player instanceof ServerPlayer) {
                    CustomAdvancementTriggers.USE_CHARM.trigger((ServerPlayer)player, charmStack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ItemInit.DROWN_CHARM.get())));
                    CustomAdvancementTriggers.SHAMAN.trigger((ServerPlayer)player);
                }
                player.m_20301_(player.m_6062_());
                if (!player.m_9236_().m_5776_()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 1, 40));
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkAndConsumeCoalfeather(LivingAttackEvent event, Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return false;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268745_) || event.getSource().m_276093_(DamageTypes.f_268546_)) {
            boolean consumed_charm = false;
            ItemStack charmStack = new ItemStack((ItemLike)ItemInit.BURN_CHARM.get());
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.BURN_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM)) {
                consumed_charm = true;
                CuriosInterop.DamageCurioInSlot((Item)ItemInit.BURN_CHARM.get(), (LivingEntity)player, SlotTypePreset.CHARM, 999);
            } else if (InventoryUtilities.removeItemFromInventory(charmStack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_()))) {
                consumed_charm = true;
            }
            if (consumed_charm) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
                CoalfeatherCharmUsedEvent bfe = new CoalfeatherCharmUsedEvent(player);
                MinecraftForge.EVENT_BUS.post((Event)bfe);
                if (player instanceof ServerPlayer) {
                    CustomAdvancementTriggers.USE_CHARM.trigger((ServerPlayer)player, charmStack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ItemInit.BURN_CHARM.get())));
                    CustomAdvancementTriggers.SHAMAN.trigger((ServerPlayer)player);
                }
                player.m_20095_();
                int radius = 3;
                BlockUtils.IterateBlocksInCube(radius, player.m_20183_(), pos -> {
                    BlockState state = player.m_9236_().m_8055_(pos);
                    if (state.m_60734_() instanceof BaseFireBlock) {
                        player.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    } else if (state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
                        player.m_9236_().m_7731_(pos, Blocks.f_50080_.m_49966_(), 3);
                    } else if (state.m_60819_().m_192917_((Fluid)Fluids.f_76194_)) {
                        player.m_9236_().m_7731_(pos, Blocks.f_50652_.m_49966_(), 3);
                    }
                });
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Player resolveManaShieldSource(Entity target) {
        int id = target.getPersistentData().m_128451_("mana_shield_source_id");
        Entity res = target.m_9236_().m_6815_(id);
        if (res != null && res instanceof Player) {
            float maxDist = target.getPersistentData().m_128457_("mana_shield_range");
            if (res.m_20270_(target) <= maxDist) {
                return (Player)res;
            }
        }
        return null;
    }
}

