/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.item;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.gui.SingleItemSlot;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.gui.containers.ContainerInit;
import com.mna.gui.containers.slots.BaseSlot;
import com.mna.items.ItemInit;
import com.mna.items.base.IBagItem;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerGrimoire
extends AbstractContainerMenu {
    private IItemHandler inventory;
    private int bagHash;
    private ItemStack bagStack;

    public ContainerGrimoire(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, ((IPlayerMagic)playerInventory.f_35978_.getCapability(PlayerMagicProvider.MAGIC).orElse(null)).getGrimoireInventory());
    }

    public ContainerGrimoire(int i, Inventory playerInv, SimpleContainer grimoireInv) {
        super((MenuType)ContainerInit.GRIMOIRE.get(), i);
        this.inventory = new InvWrapper((Container)grimoireInv);
        this.bagStack = playerInv.m_8020_(playerInv.f_35977_);
        this.bagHash = this.bagStack.hashCode();
        this.initializeSlots(playerInv);
    }

    protected void initializeSlots(Inventory playerInv) {
        for (int k = 0; k < this.slotsPerRow(); ++k) {
            for (int j = 0; j < this.numRows(); ++j) {
                if (k % this.slotsPerRow() == 0) {
                    this.m_38897_((Slot)this.slot(this.inventory, k + j * this.slotsPerRow(), 18 + k * 18, 7 + j * 18));
                    continue;
                }
                this.m_38897_((Slot)this.slot(this.inventory, k + j * this.slotsPerRow(), 107 + k * 26, 7 + j * 18));
            }
        }
        int i = (this.numRows() - 4) * 18;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInv, j1 + l * 9 + 9, 48 + j1 * 18, 102 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInv, i1, 48 + i1 * 18, 160 + i));
        }
    }

    public BaseSlot slot(IItemHandler inv, int index, int x, int y) {
        return new SingleItemSlot(inv, index, x, y, (Item)ItemInit.SPELL.get());
    }

    protected int slotsPerRow() {
        return 2;
    }

    protected int numRows() {
        return 8;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        try {
            if (this.m_38853_(slotId).m_7993_().hashCode() == this.bagHash) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.m_9236_().m_5776_()) {
            playerIn.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.setSyncGrimoire();
                m.forceSync();
            });
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        ItemStack held = player.m_21205_();
        return held == this.bagStack && !this.bagStack.m_41619_() && held.hashCode() == this.bagHash && held.m_41720_() instanceof IBagItem;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.numRows() * this.slotsPerRow() ? !this.m_38903_(itemstack1, this.numRows() * this.slotsPerRow(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.numRows() * this.slotsPerRow(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

