/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.entity;

import com.mna.gui.GuiTextures;
import com.mna.gui.base.SearchableGui;
import com.mna.gui.containers.entity.ContainerWanderingWizard;
import com.mna.network.ClientMessageDispatcher;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiWanderingWizard
extends SearchableGui<ContainerWanderingWizard> {
    private boolean hasinitialized = false;
    private ItemStack tooltipStack = ItemStack.f_41583_;
    private WanderingWizardOffersList list;
    private int selectedRecipeIndex = -1;

    public GuiWanderingWizard(ContainerWanderingWizard screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
    }

    @Override
    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.tooltipStack = ItemStack.f_41583_;
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int x, int y) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280163_(GuiTextures.Entities.WANDERING_WIZARD, i, j, 0.0f, 0.0f, this.f_97726_, 193, this.f_97726_, this.f_97727_);
        pGuiGraphics.m_280163_(GuiTextures.Entities.WANDERING_WIZARD, i + 40, j + 193, 40.0f, 193.0f, 176, 63, this.f_97726_, this.f_97727_);
        if (this.list != null) {
            this.list.m_88315_(pGuiGraphics, x, y, partialTicks);
        }
        if (this.searchBox != null) {
            RenderSystem.disableDepthTest();
            this.searchBox.m_88315_(pGuiGraphics, x, y, partialTicks);
            RenderSystem.enableDepthTest();
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int x, int y) {
        if (!this.hasinitialized && ((ContainerWanderingWizard)this.f_97732_).isFinalized()) {
            this.initialize();
        }
        if (!this.tooltipStack.m_41619_()) {
            pGuiGraphics.m_280153_(this.f_96547_, this.tooltipStack, x - this.f_97735_, y - this.f_97736_);
        }
    }

    @Override
    protected void searchTermChanged(String newTerm) {
        this.currentSearchTerm = newTerm;
        this.list.clear();
        this.list.reInit(this.currentSearchTerm);
        this.list.m_93410_(0.0);
    }

    private void initialize() {
        this.hasinitialized = true;
        this.list = new WanderingWizardOffersList(((ContainerWanderingWizard)this.f_97732_).getOffers());
        this.m_7787_((GuiEventListener)this.list);
        int tbWidth = 130;
        int x = this.f_97735_ + 6;
        int y = this.f_97736_ + 6;
        this.initSearch(x, y, tbWidth, 16);
    }

    private void OnItemClicked(MerchantOffer offer, int index) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.selectedRecipeIndex = index = ((ContainerWanderingWizard)this.f_97732_).calculateIndexFor(offer, index, this.currentSearchTerm);
        ((ContainerWanderingWizard)this.f_97732_).setCurrentRecipeIndex(this.selectedRecipeIndex);
        ((ContainerWanderingWizard)this.f_97732_).setCurrentTradeRecipeItems(this.selectedRecipeIndex);
        ClientMessageDispatcher.sendTradeSelected(index);
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.list != null && this.list._scrolling) {
            return this.list.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class WanderingWizardOffersList
    extends ObjectSelectionList<ItemStackEntry> {
        private boolean _scrolling;
        public boolean _active;
        private final Collection<MerchantOffer> initialOffers;

        public WanderingWizardOffersList(MerchantOffers merchantOffers) {
            super(GuiWanderingWizard.this.f_96541_, 244, 141, GuiWanderingWizard.this.f_97736_ + 26, GuiWanderingWizard.this.f_97736_ + 167, 20);
            this._scrolling = false;
            this._active = true;
            this.m_93471_(false);
            this.m_93473_(false, 20);
            this.f_93393_ = GuiWanderingWizard.this.f_97735_ - 2;
            this.f_93392_ = this.f_93393_ + 250;
            this.initialOffers = merchantOffers;
            this.reInit("");
        }

        private void addItems(Collection<MerchantOffer> offers, BiConsumer<MerchantOffer, Integer> clickHandler) {
            ArrayList<MerchantOffer> segment = new ArrayList<MerchantOffer>();
            int index = 0;
            for (MerchantOffer part : offers) {
                segment.add(part);
                if (segment.size() != 3) continue;
                this.m_7085_((AbstractSelectionList.Entry)new ItemStackEntry(segment, clickHandler, index));
                index += segment.size();
                segment.clear();
            }
            if (segment.size() > 0) {
                this.m_7085_((AbstractSelectionList.Entry)new ItemStackEntry(segment, clickHandler, index));
            }
        }

        public void clear() {
            this.m_93516_();
        }

        public void reInit(String searchTerm) {
            this.addItems(this.initialOffers.stream().filter(o -> searchTerm == "" || o.m_45368_().m_41651_((Player)this.f_93386_.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_).stream().anyMatch(l -> l.toString().toLowerCase().contains(searchTerm.toLowerCase()))).collect(Collectors.toList()), (o, i) -> GuiWanderingWizard.this.OnItemClicked((MerchantOffer)o, (int)i));
        }

        public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (!this._active) {
                return;
            }
            int scrollBarStartX = this.m_5756_();
            this.m_6702_().forEach(c -> {
                c.isHovered = false;
            });
            ItemStackEntry hov = this.getEntryAtPos(mouseX, mouseY);
            if (hov != null) {
                hov.isHovered = true;
            }
            this.getEntryAtPos(mouseX, mouseY);
            this.m_239227_(pGuiGraphics, mouseX, mouseY, partialTicks);
            if (this.m_93518_() > 0) {
                int scrollBarHeight = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
                scrollBarHeight = Mth.m_14045_((int)scrollBarHeight, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
                int top = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - scrollBarHeight) / this.m_93518_() + this.f_93390_;
                if (top < this.f_93390_) {
                    top = this.f_93390_;
                }
                pGuiGraphics.m_280163_(new ResourceLocation("textures/gui/container/villager2.png"), scrollBarStartX, top, 25.0f, 20.0f, 3, scrollBarHeight, 512, 256);
            }
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            int i = GuiWanderingWizard.this.f_97735_;
            int j = GuiWanderingWizard.this.f_97736_;
            pGuiGraphics.m_280218_(GuiTextures.Entities.WANDERING_WIZARD, i, j, 0, 0, GuiWanderingWizard.this.f_97726_, 26);
            pGuiGraphics.m_280218_(GuiTextures.Entities.WANDERING_WIZARD, i, j + 167, 0, 167, GuiWanderingWizard.this.f_97726_, 26);
            RenderSystem.enableDepthTest();
        }

        @Nullable
        protected final ItemStackEntry getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.m_5747_();
            int upperXBound = lowerXBound + this.m_5759_();
            int adjustedY = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) + (int)this.m_93517_();
            int index = adjustedY / this.f_93387_;
            if (mouseX < (double)this.f_93393_ || mouseX > (double)this.f_93392_ || mouseY < (double)this.f_93390_ || mouseY > (double)this.f_93391_) {
                return null;
            }
            if (index >= 0 && adjustedY >= 0 && index < this.m_5773_() && mouseX < (double)this.m_5756_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (ItemStackEntry)((Object)this.m_6702_().get(index));
            }
            return null;
        }

        protected int m_5756_() {
            return this.m_5747_() + this.m_5759_() + 2;
        }

        protected int m_7610_(int p_getRowTop_1_) {
            return this.f_93390_ - (int)this.m_93517_() + p_getRowTop_1_ * this.f_93387_;
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected void m_93481_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.m_93481_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.m_5756_() && p_updateScrollingState_1_ < (double)(this.m_5756_() + 6);
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (!this._active) {
                return false;
            }
            this.m_93481_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.m_5953_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            ItemStackEntry e = this.getEntryAtPos(p_mouseClicked_1_, p_mouseClicked_3_);
            if (e != null) {
                if (e.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                    e.m_93692_(true);
                    return true;
                }
            } else if (p_mouseClicked_5_ == 0) {
                this.m_7897_(true);
                return true;
            }
            return this._scrolling;
        }

        public int m_93518_() {
            return Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_ - 4));
        }

        public void setSelected(@Nullable ItemStackEntry selected) {
            super.m_6987_((AbstractSelectionList.Entry)selected);
        }

        @OnlyIn(value=Dist.CLIENT)
        public class ItemStackEntry
        extends ObjectSelectionList.Entry<ItemStackEntry> {
            private Collection<MerchantOffer> items;
            private int spacing = 83;
            private MerchantOffer _hoveredComponent;
            private BiConsumer<MerchantOffer, Integer> _clickHandler;
            private int index;
            private int hoveredIndex;
            protected boolean isHovered;

            public ItemStackEntry(Collection<MerchantOffer> parts, BiConsumer<MerchantOffer, Integer> clickHandler, int index) {
                this.items = new ArrayList<MerchantOffer>(parts);
                this._hoveredComponent = null;
                this.index = index;
                this._clickHandler = clickHandler;
            }

            public void m_6311_(GuiGraphics pGuiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                for (MerchantOffer part : this.items) {
                    if (part == null) continue;
                    int x = 7 + left + i++ * this.spacing;
                    int y = top + 4;
                    pGuiGraphics.m_280218_(GuiTextures.Entities.WANDERING_WIZARD, x, y, 16, 238, 18, 18);
                    pGuiGraphics.m_280218_(GuiTextures.Entities.WANDERING_WIZARD, x + 18, y, 16, 238, 18, 18);
                    pGuiGraphics.m_280218_(GuiTextures.Entities.WANDERING_WIZARD, x + 37, y + 3, 0, 246, 16, 10);
                    pGuiGraphics.m_280218_(GuiTextures.Entities.WANDERING_WIZARD, x + 54, y, 16, 238, 18, 18);
                    pGuiGraphics.m_280480_(part.m_45352_(), x + 1, y + 1);
                    pGuiGraphics.m_280480_(part.m_45364_(), x + 19, y + 1);
                    pGuiGraphics.m_280480_(part.m_45368_(), x + 55, y + 1);
                    if (!this.isHovered || mouseX < x || mouseX > x + this.spacing) continue;
                    GuiWanderingWizard.this.tooltipStack = part.m_45368_();
                    this._hoveredComponent = part;
                    this.hoveredIndex = i - 1;
                }
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                WanderingWizardOffersList.this.setSelected(this);
                if (this._clickHandler != null && this._hoveredComponent != null) {
                    this._clickHandler.accept(this._hoveredComponent, this.index + this.hoveredIndex);
                }
                return true;
            }

            public Component m_142172_() {
                return Component.m_237115_((String)"");
            }
        }
    }
}

