/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mna.ManaAndArtifice;
import com.mna.api.guidebook.IGuideBookRegistry;
import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.guidebook.RegisterGuidebooksEvent;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.guide.EntryCategory;
import com.mna.guide.GuidebookEntry;
import com.mna.guide.RelatedRecipe;
import com.mna.guide.recipe.init.RecipeRenderers;
import com.mna.guide.sections.TextSection;
import com.mna.network.ClientMessageDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GuideBookEntries
implements IGuideBookRegistry {
    public static final GuideBookEntries INSTANCE = new GuideBookEntries();
    private Map<String, GuidebookEntry> _entries;
    private List<ResourceLocation> guidebookPaths;
    private boolean hasLoaded = false;
    private String lastLanguage = "";
    private boolean lastUnicode = false;
    ResourceLocation _default = new ResourceLocation("mna", "guide/en_us.json");
    ResourceLocation _default_packadds = new ResourceLocation("mna", "guide/pack_adds/en_us.json");

    private GuideBookEntries() {
        this.guidebookPaths = new ArrayList<ResourceLocation>();
        this._entries = new HashMap<String, GuidebookEntry>();
        this.guidebookPaths.add(new ResourceLocation("mna", "guide"));
        MinecraftForge.EVENT_BUS.post((Event)new RegisterGuidebooksEvent(this));
    }

    public GuidebookEntry getEntry(String id) {
        return this._entries.get(id);
    }

    private boolean playerHasAdvancement(ResourceLocation advancementID, LocalPlayer player) {
        if (advancementID == null) {
            return true;
        }
        try {
            ClientAdvancements clientAdvancements = player.f_108617_.m_105145_();
            Advancement adv = clientAdvancements.m_104396_().m_139337_(advancementID);
            if (adv == null) {
                return false;
            }
            AdvancementProgress advProgress = (AdvancementProgress)clientAdvancements.f_104390_.get(adv);
            if (advProgress != null) {
                return advProgress.m_8193_();
            }
        }
        catch (Exception ex) {
            ManaAndArtifice.LOGGER.warn("GuideBookEntries >> Error checking advancement completion on client!");
        }
        return true;
    }

    public Collection<GuidebookEntry> getEntries(EntryCategory category) {
        ArrayList<GuidebookEntry> matches = new ArrayList<GuidebookEntry>();
        for (GuidebookEntry e : this._entries.values()) {
            if (e.getCategory() != category || !this.playerHasAdvancement(e.getRequiredAdvancement(), Minecraft.m_91087_().f_91074_)) continue;
            matches.add(e);
        }
        return matches;
    }

    public List<Map.Entry<String, GuidebookEntry>> getAllEntries() {
        return this._entries.entrySet().stream().filter(e -> this.playerHasAdvancement(((GuidebookEntry)e.getValue()).getRequiredAdvancement(), Minecraft.m_91087_().f_91074_)).collect(Collectors.toList());
    }

    public List<GuidebookSearchResult> searchEntries(String query, int tier, int limit) {
        String lowerQuery = query.toLowerCase();
        Minecraft m = Minecraft.m_91087_();
        List matchingContents = this._entries.values().stream().filter(e -> e.getTier() <= tier && this.playerHasAdvancement(e.getRequiredAdvancement(), m.f_91074_)).filter(e -> e.getSections().stream().anyMatch(s -> s instanceof TextSection && ((TextSection)s).getRawText().toLowerCase().contains(lowerQuery))).collect(Collectors.toList());
        HashMap relatedRecipes = new HashMap();
        this._entries.values().forEach(e -> e.getRelatedRecipes().stream().filter(r -> r.getTier() <= tier).forEach(r -> {
            block0: for (ItemStack is : r.getOutputItems((Level)m.f_91073_)) {
                if (is.m_41619_()) continue;
                if (is.m_41793_()) {
                    Map map = EnchantmentHelper.m_44831_((ItemStack)is);
                    for (Map.Entry ench : map.entrySet()) {
                        if (!((Enchantment)ench.getKey()).m_44700_(((Integer)ench.getValue()).intValue()).getString().toLowerCase().contains(lowerQuery)) continue;
                        relatedRecipes.put(r, is);
                        continue block0;
                    }
                    continue;
                }
                if (!is.m_41786_().getString().toLowerCase().contains(lowerQuery)) continue;
                relatedRecipes.put(r, is);
                break;
            }
        }));
        List results = relatedRecipes.entrySet().stream().map(r -> new GuidebookSearchResult((RelatedRecipe)r.getKey(), (ItemStack)r.getValue())).collect(Collectors.toList());
        results.addAll(matchingContents.stream().map(e -> new GuidebookSearchResult((GuidebookEntry)e)).collect(Collectors.toList()));
        return results.stream().filter(this.distinctByKey(GuidebookSearchResult::toString)).limit(limit).collect(Collectors.toList());
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private void readEntries(ResourceManager resourceManager, ResourceLocation rLoc) {
        try {
            BufferedReader reader;
            InputStream in;
            Optional res = resourceManager.m_213713_(rLoc);
            if (res.isPresent() && (in = ((Resource)res.get()).m_215507_()) != null && (reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8))) != null) {
                JsonElement obj = JsonParser.parseReader((Reader)reader);
                if (obj != null && obj.isJsonObject()) {
                    this.parseJSON(obj.getAsJsonObject(), rLoc.m_135827_());
                }
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException ex) {
            ManaAndArtifice.LOGGER.catching((Throwable)ex);
        }
    }

    private void parseJSON(JsonObject obj, String modid) {
        for (Map.Entry elem : obj.getAsJsonObject().entrySet()) {
            if (!((JsonElement)elem.getValue()).isJsonObject()) continue;
            this._entries.put((String)elem.getKey(), new GuidebookEntry(((JsonElement)elem.getValue()).getAsJsonObject(), (String)elem.getKey(), modid));
        }
    }

    private void readAndParseGuidebooks(ResourceManager resourceManager) {
        Minecraft mc = Minecraft.m_91087_();
        for (ResourceLocation rLoc : this.guidebookPaths) {
            if (!mc.f_91066_.f_92075_.equalsIgnoreCase("en_us")) {
                ResourceLocation rLoc_localized = new ResourceLocation(rLoc.m_135827_(), rLoc.m_135815_() + "/en_us.json");
                this.readEntries(resourceManager, rLoc_localized);
                ResourceLocation rLoc_packAdds = new ResourceLocation(rLoc.m_135827_(), rLoc.m_135815_() + "/pack_adds/en_us.json");
                this.readEntries(resourceManager, rLoc_packAdds);
            }
            String guidebook_localized = String.format("%s.json", mc.f_91066_.f_92075_);
            ResourceLocation rLoc_localized = new ResourceLocation(rLoc.m_135827_(), rLoc.m_135815_() + "/" + guidebook_localized);
            this.readEntries(resourceManager, rLoc_localized);
            ResourceLocation rLoc_packAdds = new ResourceLocation(rLoc.m_135827_(), rLoc.m_135815_() + "/pack_adds/" + guidebook_localized);
            this.readEntries(resourceManager, rLoc_packAdds);
        }
    }

    public void reload() {
        Minecraft mc = Minecraft.m_91087_();
        if (this.hasLoaded && this.lastLanguage == mc.f_91066_.f_92075_ && mc.m_91390_() == this.lastUnicode) {
            return;
        }
        ResourceManager resourceManager = mc.m_91098_();
        this._entries.clear();
        this.readAndParseGuidebooks(resourceManager);
        this.hasLoaded = true;
        this.lastLanguage = mc.f_91066_.f_92075_;
        this.lastUnicode = mc.m_91390_();
    }

    public void updateUnlockedEntries(@Nullable ResourceLocation unlockedAdvancementID) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> {
            int lastCount = progression == null ? 0 : progression.unlockedEntryCount();
            List unlocked = this._entries.entrySet().stream().filter(e -> {
                if (unlockedAdvancementID == null) {
                    return this.playerHasAdvancement(((GuidebookEntry)e.getValue()).getRequiredAdvancement(), mc.f_91074_);
                }
                return ((GuidebookEntry)e.getValue()).getRequiredAdvancement() == null || unlockedAdvancementID.equals((Object)((GuidebookEntry)e.getValue()).getRequiredAdvancement());
            }).map(e -> (String)e.getKey()).collect(Collectors.toList());
            if (unlocked.size() > lastCount) {
                long[] entryHashes = new long[unlocked.size()];
                int count = 0;
                for (String s : unlocked) {
                    entryHashes[count++] = s.hashCode();
                }
                ClientMessageDispatcher.updateCodexEntryUnlocks(entryHashes);
                ManaAndArtifice.instance.proxy.showCodexEntriesUnlocked();
            }
        });
    }

    @Override
    public void addGuidebookPath(ResourceLocation resourceLocation) {
        this.guidebookPaths.add(resourceLocation);
    }

    @Override
    public void registerRecipeRenderer(String recipe_type, Class<? extends RecipeRendererBase> clazz) {
        RecipeRenderers.registerRecipeRenderer(recipe_type, clazz);
    }

    @Override
    public void registerGuidebookCategory(String id, ResourceLocation icon) {
        EntryCategory.Register(id, icon);
    }

    public class GuidebookSearchResult {
        private GuidebookEntry _entry;
        private RelatedRecipe _recipe;
        private ItemStack _output;

        public GuidebookSearchResult(GuidebookEntry entry) {
            this._entry = entry;
            this._output = ItemStack.f_41583_;
        }

        public GuidebookSearchResult(RelatedRecipe recipe, ItemStack output) {
            this._recipe = recipe;
            this._output = output;
        }

        @Nullable
        public GuidebookEntry getEntry() {
            return this._entry;
        }

        public boolean isEntry() {
            return this._entry != null;
        }

        @Nullable
        public RelatedRecipe getRecipe() {
            return this._recipe;
        }

        public ItemStack getOutputStack() {
            return this._output;
        }

        public boolean isRecipe() {
            return this._recipe != null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GuidebookSearchResult) {
                GuidebookSearchResult other = (GuidebookSearchResult)obj;
                if (this.isEntry() && other.isEntry()) {
                    return this.getEntry().equals(other.getEntry());
                }
                if (this.isRecipe() && other.isRecipe()) {
                    return this.getRecipe().equals(other.getRecipe());
                }
            }
            return false;
        }

        public String toString() {
            if (this.isEntry()) {
                return this._entry.toString();
            }
            return this._recipe.toString();
        }
    }
}

