/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.affinity.Affinity;
import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.guide.recipe.ICyclingRecipeRenderer;
import com.mna.recipes.eldrin.FumeFilterRecipe;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeFumeFilter
extends RecipeRendererBase
implements ICyclingRecipeRenderer<RecipeFumeFilter> {
    private FumeFilterRecipe[] patterns;

    public RecipeFumeFilter(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<FumeFilterRecipe> patternList = new ArrayList<FumeFilterRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional<Recipe<?>> pattern = this.resolveRecipe(rLoc);
            if (!pattern.isPresent() || !(pattern.get() instanceof FumeFilterRecipe)) continue;
            patternList.add((FumeFilterRecipe)pattern.get());
        }
        this.patterns = patternList.toArray(new FumeFilterRecipe[0]);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional<Recipe<?>> pattern = this.resolveRecipe(recipeLocation);
        this.patterns = pattern.isPresent() && pattern.get() instanceof FumeFilterRecipe ? new FumeFilterRecipe[]{(FumeFilterRecipe)pattern.get()} : null;
    }

    private Optional<? extends Recipe<?>> resolveRecipe(ResourceLocation recipeLocation) {
        if (recipeLocation.m_135827_().equals("mna") && !recipeLocation.m_135815_().startsWith("fume_filter/")) {
            recipeLocation = new ResourceLocation(recipeLocation.m_135827_(), "fume_filter/" + recipeLocation.m_135815_());
        }
        return this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.FUME_FILTER;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int index = this.getIndex();
        if (this.patterns.length == 0) {
            return;
        }
        FumeFilterRecipe pattern = this.patterns[index];
        if (pattern == null) {
            return;
        }
        int cX = this.m_252754_() + (int)((float)(this.f_93618_ / 2 - 77) * this.scale);
        int affY = this.m_252907_() + (int)(82.0f * this.scale);
        Font fr = this.minecraft.f_91062_;
        ItemStack output = pattern.getGuiRepresentationStack();
        this.renderItemStack(pGuiGraphics, output, cX, this.m_252907_() + (int)(88.0f * this.scale), this.scale);
        String vText = String.format("%.0f", Float.valueOf(pattern.getTotalGeneration() * 0.02f));
        int strLen = fr.m_92895_(vText);
        int affPosX = this.m_252754_() + (int)((float)(this.f_93618_ - 70 - strLen / 2) * this.scale);
        Affinity a = pattern.getAffinity();
        ItemStack guiStack = GuiTextures.affinityIcons.get((Object)a);
        int rY = affY;
        this.renderItemStack(pGuiGraphics, guiStack, affPosX, rY - 4, this.scale);
        if (a == Affinity.WIND) {
            pGuiGraphics.m_280056_(fr, vText, (int)((float)(affPosX + 16) / this.scale), (int)((float)rY / this.scale), FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0), false);
        } else {
            pGuiGraphics.m_280056_(fr, vText, (int)((float)(affPosX + 16) / this.scale), (int)((float)rY / this.scale), FastColor.ARGB32.m_13660_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]), false);
        }
        int tier = pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)"gui.mna.jei.eldrin_fume.generation");
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        int stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)name);
        int textX = x + this.f_93618_ / 2 - stringWidth / 2;
        int textY = y + 5;
        pGuiGraphics.m_280614_(fr, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(fr, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + 15, color, false);
        if (pattern.getFactionRequirement() != null) {
            int xPadding = 3;
            this.renderFactionIcon(pGuiGraphics, pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        if (this.patterns == null) {
            return 1;
        }
        int minTier = 5;
        for (FumeFilterRecipe pattern : this.patterns) {
            if (pattern.getTier() >= minTier) continue;
            minTier = pattern.getTier();
        }
        return minTier;
    }

    @Override
    public int countRecipes() {
        return this.patterns.length;
    }
}

