/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.constructs;

import com.mna.ManaAndArtifice;
import com.mna.api.blocks.FillerBlock;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.items.TieredItem;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mna.blocks.BlockInit;
import com.mna.blocks.artifice.LodestarBlock;
import com.mna.blocks.tileentities.OffsetBlockTile;
import com.mna.entities.constructs.ai.ConstructChop;
import com.mna.entities.constructs.ai.ConstructCollectFluid;
import com.mna.entities.constructs.ai.ConstructCommandFollowAndGuard;
import com.mna.entities.constructs.ai.ConstructCommandFollowLodestar;
import com.mna.entities.constructs.ai.ConstructCommandReturnToTable;
import com.mna.entities.constructs.ai.ConstructHarvest;
import com.mna.entities.constructs.ai.ConstructWearItem;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.entities.constructs.animated.Construct;
import com.mna.items.base.IRadialInventorySelect;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BellOfBidding
extends TieredItem
implements IRadialInventorySelect {
    private static final String NBT_COMMANDING_ENTITY = "commanding_entity";
    private static final String NBT_COMMAND_TYPE = "command";

    public BellOfBidding() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        AABB box;
        ItemStack stack = player.m_21120_(hand);
        Vec3 playerPos = player.m_146892_();
        double range = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        range *= range;
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 clipEnd = playerPos.m_82520_(viewVec.f_82479_ * range, viewVec.f_82480_ * range, viewVec.f_82481_ * range);
        EntityHitResult res = ProjectileUtil.m_37287_((Entity)player, (Vec3)playerPos, (Vec3)clipEnd, (AABB)(box = player.m_20191_().m_82369_(viewVec.m_82490_(range)).m_82377_(1.0, 1.0, 1.0)), e -> e.m_6084_(), (double)range);
        if (res != null && res.m_6662_() == HitResult.Type.ENTITY) {
            Entity e2 = res.m_82443_();
            Commands cmd = this.getCommand(stack);
            if (e2 instanceof Construct) {
                Construct construct = (Construct)e2;
                if (player.m_6047_()) {
                    this.setCommandingEntity(construct, stack);
                    if (!player.m_9236_().m_5776_()) {
                        player.m_213846_((Component)Component.m_237115_((String)"item.mna.bell_of_bidding.bound"));
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                if (cmd == Commands.DIAGNOSTICS) {
                    return this.issueDiagnosticsCommand(stack, player, (LivingEntity)construct, hand);
                }
                if (cmd == Commands.STAY) {
                    return this.issueStayCommand(stack, player, (LivingEntity)construct, hand);
                }
                if (cmd == Commands.FOLLOW) {
                    return this.issueFollowCommand(stack, player, (LivingEntity)construct, hand, false);
                }
                if (cmd == Commands.GUARD) {
                    return this.issueFollowCommand(stack, player, (LivingEntity)construct, hand, true);
                }
                if (cmd == Commands.EAT) {
                    return this.issueEatCommand(stack, player, construct, hand);
                }
            } else if (e2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e2;
                if (cmd == Commands.ATTACK) {
                    return this.issueAttackCommand(stack, player, living, hand);
                }
                if (cmd == Commands.GUARD) {
                    return this.issueFollowCommand(stack, player, living, hand, true);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        if (context.m_43723_().m_6047_()) {
            if (world.f_46443_) {
                return InteractionResult.PASS;
            }
            this.clearCommandingEntity(stack);
            context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.bell_of_bidding.cleared"));
            return InteractionResult.SUCCESS;
        }
        Commands cmd = this.getCommand(stack);
        if (cmd == Commands.MOVE) {
            return this.issueMoveCommand(stack, context);
        }
        if (cmd == Commands.INTERACT) {
            return this.issueInteractCommand(stack, context);
        }
        if (cmd == Commands.WEAR) {
            return this.issueWearCommand(stack, context);
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void m_7373_(ItemStack p_41421_, Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        IRadialInventorySelect.super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
    }

    private Commands getCommand(ItemStack stack) {
        return Commands.values()[this.getIndex(stack)];
    }

    public static void setCommand(ItemStack stack, Commands option) {
        if (!(stack.m_41720_() instanceof BellOfBidding)) {
            return;
        }
        stack.m_41784_().m_128405_(NBT_COMMAND_TYPE, option.ordinal());
    }

    private void setCommandingEntity(Construct construct, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(NBT_COMMANDING_ENTITY, construct != null ? construct.m_19879_() : -1);
        stack.m_41751_(tag);
    }

    private void clearCommandingEntity(ItemStack stack) {
        this.setCommandingEntity(null, stack);
    }

    private Construct getCommandedEntity(Level world, ItemStack stack) {
        Entity e = world.m_6815_(stack.m_41784_().m_128451_(NBT_COMMANDING_ENTITY));
        if (e instanceof Construct) {
            return (Construct)e;
        }
        return null;
    }

    private List<Construct> getCommandingEntities(Level world, Player player, ItemStack stack) {
        Construct commandedEntity = this.getCommandedEntity(world, stack);
        if (commandedEntity != null) {
            return Arrays.asList(commandedEntity);
        }
        return world.m_45976_(Construct.class, player.m_20191_().m_82400_(32.0)).stream().filter(c -> c.isFollowing(player)).toList();
    }

    private void ding(Player player) {
        if (!player.m_9236_().m_5776_()) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private InteractionResultHolder<ItemStack> issueWearCommand(ItemStack stack, Player player, ItemEntity target, InteractionHand hand) {
        this.getCommandingEntities(player.m_9236_(), player, stack).forEach(construct -> {
            ConstructWearItem task = (ConstructWearItem)ConstructTasks.WEAR_ITEM.instantiateTask((IConstruct<?>)construct);
            task.setTarget(target);
            task.setOneOff(player);
            if (construct.setCurrentCommand(player, task)) {
                this.ding(player);
            }
        });
        this.ding(player);
        return InteractionResultHolder.m_19092_((Object)stack, (!player.m_9236_().m_5776_() ? 1 : 0) != 0);
    }

    private InteractionResultHolder<ItemStack> issueAttackCommand(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        this.getCommandingEntities(player.m_9236_(), player, stack).forEach(construct -> {
            ConstructCommandFollowAndGuard task = (ConstructCommandFollowAndGuard)ConstructTasks.FOLLOW_DEFEND.instantiateTask((IConstruct<?>)construct);
            task.setFollowTarget((LivingEntity)player);
            task.setShouldGuard(true);
            construct.m_6710_(target);
        });
        this.ding(player);
        return InteractionResultHolder.m_19092_((Object)stack, (!player.m_9236_().m_5776_() ? 1 : 0) != 0);
    }

    private InteractionResultHolder<ItemStack> issueEatCommand(ItemStack stack, Player player, Construct target, InteractionHand hand) {
        if (!player.m_9236_().m_5776_()) {
            target.eatItem(player);
        }
        this.ding(player);
        return InteractionResultHolder.m_19092_((Object)stack, (!player.m_9236_().m_5776_() ? 1 : 0) != 0);
    }

    private InteractionResultHolder<ItemStack> issuePickupCommand(ItemStack stack, Player player, BlockPos target, InteractionHand hand) {
        this.getCommandingEntities(player.m_9236_(), player, stack).forEach(construct -> construct.pickupItem(target, player));
        return InteractionResultHolder.m_19092_((Object)stack, (!player.m_9236_().m_5776_() ? 1 : 0) != 0);
    }

    private InteractionResultHolder<ItemStack> issueDiagnosticsCommand(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.m_9236_().m_5776_() && target instanceof Construct) {
            ManaAndArtifice.instance.proxy.openConstructDiagnostics((Construct)target);
        }
        this.ding(player);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> issueFollowCommand(ItemStack stack, Player player, LivingEntity target, InteractionHand hand, boolean guard) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (target instanceof Construct) {
            Construct construct = (Construct)target;
            ConstructCommandFollowAndGuard task = (ConstructCommandFollowAndGuard)ConstructTasks.FOLLOW_DEFEND.instantiateTask(construct);
            task.setFollowTarget((LivingEntity)player);
            task.setShouldGuard(guard);
            if (!guard) {
                construct.m_6710_(null);
            }
            if (construct.setCurrentCommand(player, task)) {
                this.ding(player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        this.getCommandingEntities(player.m_9236_(), player, stack).forEach(commandedEntity -> {
            ConstructCommandFollowAndGuard task = (ConstructCommandFollowAndGuard)ConstructTasks.FOLLOW_DEFEND.instantiateTask((IConstruct<?>)commandedEntity);
            task.setFollowTarget(target);
            task.setShouldGuard(guard);
            commandedEntity.setCurrentCommand(player, task);
        });
        this.ding(player);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> issueChopCommand(ItemStack stack, Player player, LivingEntity target, BlockPos pos, InteractionHand hand) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (target instanceof Construct) {
            Construct construct = (Construct)target;
            ConstructChop task = (ConstructChop)ConstructTasks.CHOP.instantiateTask(construct);
            task.setAreaManually(pos, pos);
            task.setOneOff(player);
            if (construct.setCurrentCommand(player, task)) {
                this.ding(player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> issueHarvestCommand(ItemStack stack, Player player, LivingEntity target, BlockPos pos, InteractionHand hand) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (target instanceof Construct) {
            Construct construct = (Construct)target;
            ConstructHarvest task = (ConstructHarvest)ConstructTasks.HARVEST.instantiateTask(construct);
            task.setAreaManually(pos, pos);
            task.setOneOff(player);
            if (construct.setCurrentCommand(player, task)) {
                this.ding(player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> issueCollectFluidCommand(ItemStack stack, Player player, LivingEntity target, BlockPos pos, InteractionHand hand) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (target instanceof Construct) {
            Construct construct = (Construct)target;
            ConstructCollectFluid task = (ConstructCollectFluid)ConstructTasks.GATHER_FLUID.instantiateTask(construct);
            task.setAreaManually(pos, pos);
            task.setOneOff(player);
            if (construct.setCurrentCommand(player, task)) {
                this.ding(player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> issueStayCommand(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (target instanceof Construct) {
            Construct construct = (Construct)target;
            if (construct.setCurrentCommand(player, ConstructTasks.STAY.instantiateTask(construct))) {
                this.ding(player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResult issueInteractCommand(ItemStack stack, UseOnContext context) {
        BlockEntity be;
        BlockPos clickPos = context.m_8083_();
        BlockPos offsetPos = clickPos.m_121955_(context.m_43719_().m_122436_());
        BlockState block = context.m_43725_().m_8055_(context.m_8083_());
        BlockState offsetBlock = context.m_43725_().m_8055_(offsetPos);
        if (block.m_60734_() instanceof FillerBlock && (be = context.m_43725_().m_7702_(context.m_8083_())) != null && be instanceof OffsetBlockTile) {
            clickPos = context.m_8083_().m_121955_((Vec3i)((OffsetBlockTile)be).getOffset());
            offsetPos = clickPos.m_121955_(context.m_43719_().m_122436_());
            block = context.m_43725_().m_8055_(clickPos);
            offsetBlock = context.m_43725_().m_8055_(offsetPos);
        }
        BlockState adjBlock = block;
        BlockState adjOffsetBlock = offsetBlock;
        BlockPos adjOffsetPos = offsetPos;
        BlockPos adjClickPos = clickPos;
        this.getCommandingEntities(context.m_43725_(), context.m_43723_(), stack).forEach(commandedEntity -> {
            if (adjBlock.m_60734_() == BlockInit.CONSTRUCT_WORKBENCH.get()) {
                ConstructCommandReturnToTable modify = (ConstructCommandReturnToTable)ConstructTasks.MODIFY.instantiateTask((IConstruct<?>)commandedEntity);
                modify.setTablePos(adjClickPos);
                commandedEntity.setCurrentCommand(context.m_43723_(), modify);
            } else if (adjBlock.m_60734_() instanceof LodestarBlock) {
                ConstructCommandFollowLodestar lodestar = (ConstructCommandFollowLodestar)ConstructTasks.LODESTAR.instantiateTask((IConstruct<?>)commandedEntity);
                lodestar.setTileEntity(adjClickPos, Direction.DOWN);
                if (commandedEntity.setCurrentCommand(context.m_43723_(), lodestar)) {
                    MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(context.m_43723_(), ProgressionEventIDs.CONSTRUCT_LODESTAR_ASSIGNED));
                    Player patt16154$temp = context.m_43723_();
                    if (patt16154$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt16154$temp;
                        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, adjClickPos, stack);
                    }
                }
            } else if (context.m_43725_().m_45976_(ItemEntity.class, new AABB(adjClickPos.m_7494_())).size() > 0) {
                this.issuePickupCommand(stack, context.m_43723_(), adjClickPos.m_7494_(), context.m_43724_());
            } else if (!adjOffsetBlock.m_60819_().m_76178_()) {
                this.issueCollectFluidCommand(stack, context.m_43723_(), (LivingEntity)commandedEntity, adjOffsetPos, context.m_43724_());
            } else if (MATags.isBlockIn(adjBlock.m_60734_(), new ResourceLocation("logs"))) {
                this.issueChopCommand(stack, context.m_43723_(), (LivingEntity)commandedEntity, adjClickPos, context.m_43724_());
            } else if (ConstructHarvest.validBlock(adjBlock)) {
                this.issueHarvestCommand(stack, context.m_43723_(), (LivingEntity)commandedEntity, adjClickPos, context.m_43724_());
            }
        });
        this.ding(context.m_43723_());
        return InteractionResult.SUCCESS;
    }

    private InteractionResult issueWearCommand(ItemStack stack, UseOnContext context) {
        BlockEntity be;
        BlockPos clickPos = context.m_8083_();
        BlockState block = context.m_43725_().m_8055_(context.m_8083_());
        if (block.m_60734_() instanceof FillerBlock && (be = context.m_43725_().m_7702_(context.m_8083_())) != null && be instanceof OffsetBlockTile) {
            clickPos = context.m_8083_().m_121955_((Vec3i)((OffsetBlockTile)be).getOffset());
            block = context.m_43725_().m_8055_(clickPos);
        }
        BlockPos adjClickPos = clickPos;
        this.getCommandingEntities(context.m_43725_(), context.m_43723_(), stack).forEach(commandedEntity -> {
            List entities = context.m_43725_().m_45976_(ItemEntity.class, new AABB(adjClickPos.m_7494_()));
            if (entities.size() > 0) {
                this.issueWearCommand(stack, context.m_43723_(), (ItemEntity)entities.get(0), context.m_43724_());
            }
        });
        this.ding(context.m_43723_());
        return InteractionResult.SUCCESS;
    }

    private InteractionResult issueMoveCommand(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        this.getCommandingEntities(world, context.m_43723_(), stack).forEach(construct -> construct.moveTo(context.m_43720_(), context.m_43723_()));
        this.ding(context.m_43723_());
        return InteractionResult.SUCCESS;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public int getIndex(ItemStack stack) {
        if (!stack.m_41782_() || !(stack.m_41720_() instanceof BellOfBidding)) {
            return 0;
        }
        int type = stack.m_41783_().m_128451_("index");
        Commands[] values = Commands.values();
        if (type < 0 || type >= values.length) {
            return 0;
        }
        return values[type].ordinal();
    }

    @Override
    public void setIndex(ItemStack stack, int index) {
        if (!(stack.m_41720_() instanceof BellOfBidding)) {
            return;
        }
        stack.m_41784_().m_128405_("index", index);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_COMMANDING_ENTITY) && stack.m_41783_().m_128451_(NBT_COMMANDING_ENTITY) != -1;
    }

    public static enum Commands {
        FOLLOW,
        GUARD,
        INTERACT,
        MOVE,
        STAY,
        DIAGNOSTICS,
        EAT,
        ATTACK,
        WEAR;

        private final ResourceLocation iconTexture = RLoc.create("textures/gui/construct/command_icons/" + this.toString().toLowerCase() + ".png");

        public ResourceLocation getIcon() {
            return this.iconTexture;
        }
    }
}

