/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.constructs.parts.base;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.items.IShowHud;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public abstract class ChargeableConstructPart
extends ItemConstructPart
implements IShowHud {
    public ChargeableConstructPart(ConstructMaterial material, ConstructSlot slot, int modelTypeMutex) {
        super(material, slot, modelTypeMutex);
    }

    public abstract float getChargeCost();

    public int getChargeDuration(ItemStack stack) {
        return 25;
    }

    public abstract void onChargeReleased(ItemStack var1, Level var2, LivingEntity var3);

    private final float getTickChargeCost(ItemStack stack) {
        return this.getChargeCost() / (float)this.getChargeDuration(stack);
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (m.getCastingResource().hasEnough((LivingEntity)player, this.getChargeCost())) {
                player.m_6672_(hand);
            }
        });
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int ticksRemaining) {
        if (ticksRemaining < 2 || !(living instanceof Player)) {
            if (living instanceof Player && !world.f_46443_) {
                this.onChargeReleased(stack, world, living);
                ((Player)living).m_36335_().m_41524_((Item)this, 20);
            }
            living.m_5810_();
            return;
        }
        LazyOptional cap = ((Player)living).getCapability(PlayerMagicProvider.MAGIC);
        if (!cap.isPresent()) {
            living.m_5810_();
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)cap.resolve().get();
        if (!magic.getCastingResource().hasEnough(living, this.getTickChargeCost(stack))) {
            living.m_5810_();
            return;
        }
        magic.getCastingResource().consume(living, this.getTickChargeCost(stack));
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int ticksRemaining) {
        if (ticksRemaining == 0) {
            // empty if block
        }
    }
}

