/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.renderers;

import com.mna.items.renderers.books.ItemBookRenderer;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemSpellBookRenderer
extends ItemBookRenderer {
    private boolean renderBookInFirstPerson = true;

    public ItemSpellBookRenderer(BlockEntityRenderDispatcher berd, EntityModelSet ems, ResourceLocation openModel, ResourceLocation closedModel, boolean renderBookInFirstPerson) {
        super(berd, ems, openModel, closedModel);
        this.renderBookInFirstPerson = renderBookInFirstPerson;
    }

    @Override
    public void m_108829_(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            if (!this.renderBookInFirstPerson) {
                return;
            }
        } else if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            if (!this.renderBookInFirstPerson) {
                this.renderArm(matrixStack, buffer, combinedLight, HumanoidArm.RIGHT);
            }
            WorldRenderUtils.spawnFirstPersonParticlesForStack(stack, HumanoidArm.RIGHT);
            if (!this.renderBookInFirstPerson) {
                return;
            }
        } else if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            if (!this.renderBookInFirstPerson) {
                this.renderArm(matrixStack, buffer, combinedLight, HumanoidArm.LEFT);
            }
            WorldRenderUtils.spawnFirstPersonParticlesForStack(stack, HumanoidArm.LEFT);
            if (!this.renderBookInFirstPerson) {
                return;
            }
        }
        super.m_108829_(stack, itemDisplayContext, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    private void renderArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, HumanoidArm side) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)mc.f_91074_.m_108560_());
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)mc.f_91074_);
        matrixStackIn.m_85836_();
        if (side == HumanoidArm.RIGHT) {
            matrixStackIn.m_85837_(0.75, -0.25, 0.0);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(95.0f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-30.0f));
            playerrenderer.m_117770_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)mc.f_91074_);
        } else {
            matrixStackIn.m_85837_(0.25, -0.25, 0.0);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(260.0f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(30.0f));
            playerrenderer.m_117813_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)mc.f_91074_);
        }
        matrixStackIn.m_85849_();
    }
}

