/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.ritual;

import com.mna.ManaAndArtifice;
import com.mna.tools.BiomeUtils;
import com.mna.tools.StructureUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class ThaumaturgicLink
extends Item {
    private static final String NBT_RECIPEID = "linked_position";
    private static final String NBT_LINK_TYPE = "link_type";
    public static final String LINK_TYPE_BIOME = "biome";
    public static final String LINK_TYPE_STRUCTURE = "structure";
    private static ArrayList<ResourceLocation> all_structure_locations;
    private static ArrayList<ResourceLocation> all_biome_locations;

    public ThaumaturgicLink() {
        super(new Item.Properties());
    }

    private ArrayList<ResourceLocation> getAllStructureLocations(ServerLevel world) {
        if (all_structure_locations == null) {
            all_structure_locations = new ArrayList();
            StructureUtils.getAllStructureIDs(world).forEach(s -> all_structure_locations.add((ResourceLocation)s));
        }
        return all_structure_locations;
    }

    private ArrayList<ResourceLocation> getAllBiomeLocations(ServerLevel world) {
        if (all_biome_locations == null) {
            all_biome_locations = new ArrayList();
            BiomeUtils.getAllBiomeIDs(world).forEach(s -> all_biome_locations.add((ResourceLocation)s));
        }
        return all_biome_locations;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceLocation recipe = this.getLocationKey(stack);
        if (recipe == null) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)recipe.toString()));
    }

    @Nullable
    public ResourceLocation getLocationKey(ItemStack stack) {
        if (!stack.m_41782_() || stack.m_41720_() != this) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (!nbt.m_128441_(NBT_RECIPEID)) {
            return null;
        }
        ResourceLocation rLoc = new ResourceLocation(nbt.m_128423_(NBT_RECIPEID).m_7916_());
        return rLoc;
    }

    public boolean isStructure(ItemStack stack) {
        if (!stack.m_41782_() || stack.m_41720_() != this) {
            return false;
        }
        CompoundTag nbt = stack.m_41783_();
        if (!nbt.m_128441_(NBT_LINK_TYPE)) {
            return false;
        }
        return nbt.m_128461_(NBT_LINK_TYPE).equals(LINK_TYPE_STRUCTURE);
    }

    public boolean isBiome(ItemStack stack) {
        if (!stack.m_41782_() || stack.m_41720_() != this) {
            return false;
        }
        CompoundTag nbt = stack.m_41783_();
        if (!nbt.m_128441_(NBT_LINK_TYPE)) {
            return false;
        }
        return nbt.m_128461_(NBT_LINK_TYPE).equals(LINK_TYPE_BIOME);
    }

    public static void setBiomeKey(ServerLevel level, ItemStack stack, Holder<Biome> biome) {
        CompoundTag nbt = stack.m_41784_();
        ResourceLocation key = BiomeUtils.getBiomeID(level, biome);
        if (key != null) {
            nbt.m_128359_(NBT_RECIPEID, key.toString());
            nbt.m_128359_(NBT_LINK_TYPE, LINK_TYPE_BIOME);
        } else {
            ManaAndArtifice.LOGGER.error("Failed to look up biome key, not setting location.");
        }
    }

    public static void setStructureKey(ServerLevel level, ItemStack stack, Holder<Structure> structure) {
        CompoundTag nbt = stack.m_41784_();
        ResourceLocation key = StructureUtils.getStructureID(level, structure);
        if (key != null) {
            nbt.m_128359_(NBT_RECIPEID, key.toString());
            nbt.m_128359_(NBT_LINK_TYPE, LINK_TYPE_STRUCTURE);
        } else {
            ManaAndArtifice.LOGGER.error("Failed to look up structure key, not setting location.");
        }
    }

    public ItemStack getRandomLink(ServerLevel world) {
        ItemStack output = new ItemStack((ItemLike)this);
        if (world.f_46441_.m_188499_()) {
            output.m_41784_().m_128359_(NBT_RECIPEID, this.getAllBiomeLocations(world).get((int)(Math.random() * (double)this.getAllBiomeLocations(world).size())).toString());
            output.m_41784_().m_128359_(NBT_LINK_TYPE, LINK_TYPE_BIOME);
        } else {
            output.m_41784_().m_128359_(NBT_RECIPEID, this.getAllStructureLocations(world).get((int)(Math.random() * (double)this.getAllStructureLocations(world).size())).toString());
            output.m_41784_().m_128359_(NBT_LINK_TYPE, LINK_TYPE_STRUCTURE);
        }
        return output;
    }
}

