/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.items.inventory.ISpellBookInventory;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.gui.containers.providers.NamedRoteBook;
import com.mna.items.renderers.books.RoteBookRenderer;
import com.mna.items.sorcery.SpellBook;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;

public class BookOfRote
extends SpellBook {
    public BookOfRote() {
        super(false);
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new RoteBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedRoteBook();
    }

    @Override
    public ISpellBookInventory getInventory(ItemStack item, IPlayerMagic magic) {
        if (magic == null) {
            return null;
        }
        return magic.getRoteInventory();
    }

    @Override
    public CompoundTag getSpellCompound(ItemStack stack, Player player) {
        if (player == null) {
            return new CompoundTag();
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return new CompoundTag();
        }
        ItemStack selectedStack = magic.getRoteInventory().m_8020_(BookOfRote.getActiveSpellSlot(stack));
        return selectedStack.m_41783_();
    }

    @Override
    public int m_8105_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("cur_spell_use_duration")) {
            return tag.m_128451_("cur_spell_use_duration");
        }
        return 9999;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ItemStack held = player.m_21120_(hand);
            IPlayerRoteSpells rote = (IPlayerRoteSpells)player.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (rote == null || magic == null) {
                return InteractionResultHolder.m_19100_((Object)held);
            }
            ItemStack bookStack = player.m_21120_(hand);
            ItemStack selectedStack = this.getSelectedStack(bookStack, player);
            SpellRecipe recipe = SpellRecipe.fromNBT(selectedStack.m_41783_());
            if (recipe.isValid() && !magic.isModifierPressed()) {
                if (!player.m_7500_()) {
                    ArrayList modified_attrs = new ArrayList();
                    if (!rote.isRote((ISpellComponent)((ModifiedSpellPart)recipe.getShape()).getPart())) {
                        String shapeName = Component.m_237115_((String)((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).getRegistryName().toString()).getString();
                        player.m_213846_((Component)Component.m_237110_((String)"item.mna.book_of_rote.part_not_rote", (Object[])new Object[]{shapeName}));
                        return InteractionResultHolder.m_19100_((Object)held);
                    }
                    modified_attrs.addAll(((ModifiedSpellPart)recipe.getShape()).getContainedAttributes().stream().filter(a -> ((ModifiedSpellPart)recipe.getShape()).getValueWithoutMultipliers((Attribute)((Object)a)) != ((ModifiedSpellPart)recipe.getShape()).getDefaultValue((Attribute)((Object)a))).collect(Collectors.toList()));
                    for (IModifiedSpellPart<SpellEffect> component : recipe.getComponents()) {
                        if (!rote.isRote(component.getPart())) {
                            String componentName = Component.m_237115_((String)component.getPart().getRegistryName().toString()).getString();
                            player.m_213846_((Component)Component.m_237110_((String)"item.mna.book_of_rote.part_not_rote", (Object[])new Object[]{componentName}));
                            return InteractionResultHolder.m_19100_((Object)held);
                        }
                        modified_attrs.addAll(component.getContainedAttributes().stream().filter(a -> component.getValueWithoutMultipliers((Attribute)((Object)a)) != component.getDefaultValue((Attribute)((Object)a))).collect(Collectors.toList()));
                    }
                    for (int m = 0; m < modified_attrs.size(); ++m) {
                        boolean modifier_rote = false;
                        Attribute attr = (Attribute)((Object)modified_attrs.get(m));
                        for (int i = 0; i < rote.getRoteModifiers().size(); ++i) {
                            Modifier mod = rote.getRoteModifiers().get(i);
                            if (mod == null || !mod.modifiesType(attr)) continue;
                            modifier_rote = true;
                            break;
                        }
                        if (modifier_rote) continue;
                        player.m_213846_((Component)Component.m_237110_((String)"item.mna.spell.modifier_not_rote", (Object[])new Object[]{attr}));
                        return InteractionResultHolder.m_19100_((Object)held);
                    }
                }
                CompoundTag bookTag = bookStack.m_41784_();
                bookTag.m_128405_("cur_spell_use_duration", recipe.getMaxChannelTime());
                bookStack.m_41751_(bookTag);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    @Override
    public ItemStack getSelectedStack(ItemStack bookStack, @Nullable Player player) {
        SimpleContainer bookInv;
        if (bookStack.m_41720_() instanceof SpellBook && (bookInv = (SimpleContainer)this.getInventory(bookStack, player != null ? (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null) : null)) != null) {
            ItemStack selectedStack = bookInv.m_8020_(BookOfRote.getActiveSpellSlot(bookStack));
            return selectedStack;
        }
        return ItemStack.f_41583_;
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        return compoundnbt != null && compoundnbt.m_128425_("color", 99) ? compoundnbt.m_128451_("color") : 11278103;
    }
}

