/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.handlers;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseClientMessage;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClientMessageHandler {
    public static void HandleClientMessage(BaseClientMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return;
        }
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> message.Handle((Level)clientWorld.get(), ManaAndArtifice.instance.proxy.getClientPlayer()));
    }
}

