/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.network.ExtendedItemStackPacketBuffer;
import com.mna.network.messages.BaseClientMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExtendedSlotContentsMessage
extends BaseClientMessage {
    private int screenId = 0;
    private int slot = 0;
    private int stateID = 0;
    private ItemStack stack = ItemStack.f_41583_;

    public ExtendedSlotContentsMessage(int screenId, int stateId, int slot, ItemStack stack) {
        this.screenId = screenId;
        this.slot = slot;
        this.stack = stack.m_41777_();
        this.stateID = stateId;
        this.messageIsValid = true;
    }

    public ExtendedSlotContentsMessage() {
        this.messageIsValid = false;
    }

    public int getScreenID() {
        return this.screenId;
    }

    public int getSlotIndex() {
        return this.slot;
    }

    public int getStateID() {
        return this.stateID;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public static ExtendedSlotContentsMessage decode(FriendlyByteBuf buf) {
        ExtendedSlotContentsMessage msg = new ExtendedSlotContentsMessage();
        ExtendedItemStackPacketBuffer bufferWrapper = new ExtendedItemStackPacketBuffer((ByteBuf)buf);
        try {
            msg.screenId = bufferWrapper.readInt();
            msg.slot = bufferWrapper.readInt();
            msg.stateID = bufferWrapper.readInt();
            msg.stack = bufferWrapper.readExtendedItemStack();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ExtendedSlotContentsMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ExtendedSlotContentsMessage msg, FriendlyByteBuf buf) {
        ExtendedItemStackPacketBuffer bufferWrapper = new ExtendedItemStackPacketBuffer((ByteBuf)buf);
        bufferWrapper.writeInt(msg.getScreenID());
        bufferWrapper.writeInt(msg.getSlotIndex());
        bufferWrapper.writeInt(msg.getStateID());
        bufferWrapper.writeExtendedItemStack(msg.getStack());
    }

    @Override
    public void Handle(Level world, Player player) {
        if (player.f_36096_.f_38840_ == this.getScreenID()) {
            player.f_36096_.m_182406_(this.getSlotIndex(), this.getStateID(), this.getStack());
        }
    }
}

