/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IChunkMagic;
import com.mna.capabilities.chunkdata.ChunkMagicProvider;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.BaseServerMessage;
import com.mna.tools.math.MathUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;

public class RequestWardDataMessage
extends BaseServerMessage {
    public static final int MAX_SIZE = 7;
    AABB bounds;

    public RequestWardDataMessage(AABB bounds) {
        if (bounds.m_82362_() > 7.0 || bounds.m_82376_() > 7.0 || bounds.m_82385_() > 7.0) {
            throw new InvalidParameterException("RequestWardDataMessage: Requested bounds may be no larger than 7 blocks on any axis");
        }
        this.bounds = bounds;
        this.messageIsValid = true;
    }

    public RequestWardDataMessage() {
        this.messageIsValid = false;
    }

    public static RequestWardDataMessage decode(FriendlyByteBuf buf) {
        RequestWardDataMessage msg = new RequestWardDataMessage();
        try {
            BlockPos min = buf.m_130135_();
            BlockPos max = buf.m_130135_();
            AABB bounds = MathUtils.createInclusiveBB(min, max);
            if (bounds.m_82362_() > 7.0 || bounds.m_82376_() > 7.0 || bounds.m_82385_() > 7.0) {
                ManaAndArtifice.LOGGER.error("RequestWardDataMessage: Requested bounds may be no larger than 7 blocks on any axis");
                return msg;
            }
            msg.bounds = bounds;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RequestWardDataMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RequestWardDataMessage msg, FriendlyByteBuf buf) {
        BlockPos min = BlockPos.m_274561_((double)msg.bounds.f_82288_, (double)msg.bounds.f_82289_, (double)msg.bounds.f_82290_);
        BlockPos max = BlockPos.m_274561_((double)msg.bounds.f_82291_, (double)msg.bounds.f_82292_, (double)msg.bounds.f_82293_);
        buf.m_130064_(min);
        buf.m_130064_(max);
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        if (this.bounds == null) {
            return;
        }
        HashMap<ChunkPos, IChunkMagic> chunkMagics = new HashMap<ChunkPos, IChunkMagic>();
        ArrayList<Long> ward_positions = new ArrayList<Long>();
        for (int x = (int)this.bounds.f_82288_; x <= (int)this.bounds.f_82291_; ++x) {
            for (int y = (int)this.bounds.f_82289_; y <= (int)this.bounds.f_82292_; ++y) {
                for (int z = (int)this.bounds.f_82290_; z <= (int)this.bounds.f_82293_; ++z) {
                    IChunkMagic chunkMagic;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!world.m_46749_(pos) || (chunkMagic = chunkMagics.computeIfAbsent(new ChunkPos(pos), chunkPos -> {
                        LevelChunk chunkAccess = world.m_46745_(pos);
                        return (IChunkMagic)chunkAccess.getCapability(ChunkMagicProvider.MAGIC).orElse(null);
                    })) == null || !chunkMagic.isWarded(pos.m_121878_())) continue;
                    ward_positions.add(pos.m_121878_());
                }
            }
        }
        long[] arr = ward_positions.stream().mapToLong(i -> i).toArray();
        ServerMessageDispatcher.sendRenderWard(player, arr);
    }
}

