/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.manaweaving;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.api.recipes.IManaweavingRecipe;
import com.mna.recipes.ItemAndPatternCraftingInventory;
import com.mna.recipes.ItemAndPatternRecipe;
import com.mna.recipes.RecipeInit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ManaweavingRecipe
extends ItemAndPatternRecipe
implements IManaweavingRecipe {
    private static final ResourceLocation NO_ENCHANT = new ResourceLocation("mna", "none");
    private static IForgeRegistry<Enchantment> __enchantRegistry;
    private ResourceLocation enchantment;
    private int enchantmentMagnitude;
    private boolean copyNBT = false;

    public ManaweavingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        super.parseExtraJson(recipeJSON);
        if (recipeJSON.has("enchant")) {
            this.enchantment = new ResourceLocation(recipeJSON.get("enchant").getAsString());
            this.enchantmentMagnitude = recipeJSON.has("magnitude") ? recipeJSON.get("magnitude").getAsInt() : 1;
        }
        if (recipeJSON.has("copy_nbt")) {
            this.copyNBT = recipeJSON.get("copy_nbt").getAsBoolean();
        }
    }

    @Override
    public void runValidation() {
        super.runValidation();
        if (this.requiredItems.length > 9) {
            ManaAndArtifice.LOGGER.error("Manaweaving recipe can't have more than 9 items; this will be uncraftable! [" + this.m_6423_().toString() + "]");
        }
        if (this.requiredPatterns.length > 6) {
            ManaAndArtifice.LOGGER.error("Manaweaving recipe can't have more than 6 patterns; this will be uncraftable! [" + this.m_6423_().toString() + "]");
        }
    }

    @Override
    public boolean matches(CraftingContainer inv, Level worldIn) {
        if (!(inv instanceof ItemAndPatternCraftingInventory)) {
            return false;
        }
        ItemAndPatternCraftingInventory mwInv = (ItemAndPatternCraftingInventory)inv;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<String> patterns = new ArrayList<String>((Collection<String>)mwInv.getPatterns());
        for (int i = 0; i < 9; ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            items.add(inv.m_8020_(i));
        }
        return this.itemsMatchShapeless(items) && this.patternsMatchShaped(patterns);
    }

    public boolean matches(Map<Enchantment, Integer> runeEnchantment) {
        if (runeEnchantment.size() != 1 || this.enchantment == null) {
            return false;
        }
        for (Enchantment ench : runeEnchantment.keySet()) {
            if (!this.enchantment.equals((Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench)) || this.enchantmentMagnitude != runeEnchantment.get(ench)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getResultItem() {
        IForgeRegistry itemRegistry;
        if ((this.__outputItem == null || this.__outputItem.m_41619_()) && (itemRegistry = ForgeRegistries.ITEMS) != null) {
            Item outputItem = (Item)itemRegistry.getValue(this.output);
            if (outputItem == null) {
                return ItemStack.f_41583_;
            }
            this.__outputItem = new ItemStack((ItemLike)outputItem, this.outputQuantity);
            if (this.__outputNBT != null) {
                this.__outputItem.m_41751_(this.__outputNBT.m_6426_());
            }
            if (this.enchantment != null) {
                Enchantment resolved;
                if (__enchantRegistry == null) {
                    __enchantRegistry = ForgeRegistries.ENCHANTMENTS;
                }
                if (__enchantRegistry != null && (resolved = (Enchantment)__enchantRegistry.getValue(this.enchantment)) != null) {
                    LinkedHashMap map = Maps.newLinkedHashMap();
                    map.put(resolved, this.enchantmentMagnitude);
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)this.__outputItem);
                }
            }
        }
        return this.__outputItem;
    }

    @Override
    public boolean isEnchantment() {
        return !this.getEnchantment().equals((Object)NO_ENCHANT);
    }

    @Override
    public ResourceLocation getEnchantment() {
        return this.enchantment == null ? NO_ENCHANT : this.enchantment;
    }

    public void setEnchantment(ResourceLocation location) {
        this.enchantment = location;
    }

    @Override
    public int getEnchantmentMagnitude() {
        return this.enchantmentMagnitude;
    }

    public void setEnchantmentMagnitude(int magnitude) {
        this.enchantmentMagnitude = magnitude;
    }

    @Override
    public boolean getCopyNBT() {
        return this.copyNBT;
    }

    public void setCopyNBT(boolean copy) {
        this.copyNBT = copy;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeInit.MANAWEAVING_RECIPE_SERIALIZER.get();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeInit.MANAWEAVING_RECIPE_TYPE.get();
    }

    @Override
    protected int maxItems() {
        return 9;
    }

    @Override
    protected int maxPatterns() {
        return 6;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        Enchantment ench;
        ItemStack out = this.getResultItem();
        if (this.isEnchantment() && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.getEnchantment())) != null) {
            out.m_41714_(ench.m_44700_(this.enchantmentMagnitude));
        }
        return out;
    }

    @Override
    public ResourceLocation getRegistryId() {
        return this.m_6423_();
    }
}

