/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.api.sound.SFX;
import com.mna.entities.faction.Broker;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RitualEffectBroker
extends RitualEffect {
    HashMap<BlockPos, Vector3f> effectWindDirections = new HashMap();

    public RitualEffectBroker(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        if (context.getLevel().m_5776_()) {
            return true;
        }
        Broker entity = new Broker(context.getLevel());
        entity.m_6034_((double)context.getCenter().m_123341_() + 0.5, context.getCenter().m_123342_(), (double)context.getCenter().m_123343_() + 0.5);
        entity.m_35891_(12000);
        context.getLevel().m_7967_((Entity)entity);
        context.getLevel().m_6263_(null, (double)context.getCenter().m_123341_(), (double)context.getCenter().m_123342_(), (double)context.getCenter().m_123343_(), SFX.Event.Ritual.IRON_BELL, SoundSource.AMBIENT, 1.0f, 1.0f);
        this.effectWindDirections.remove(context.getCenter());
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        Vec3 pos;
        BlockPos block;
        int i;
        RandomSource rand = context.getLevel().m_213780_();
        Vector3f wind = this.effectWindDirections.getOrDefault(context.getCenter(), new Vector3f(rand.m_188501_() - 0.5f, 0.0f, rand.m_188501_() - 0.5f));
        wind.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)(rand.m_188503_(4) - 2)));
        for (i = 0; i < 5; ++i) {
            block = context.getCenter().m_7918_(-3 + rand.m_188503_(7), 0, -3 + rand.m_188503_(7));
            pos = new Vec3((double)block.m_123341_() + rand.m_188500_(), (double)((float)block.m_123342_() + rand.m_188501_()), (double)block.m_123343_() + rand.m_188500_());
            context.getLevel().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (double)0.04f, (double)0.32f, (double)0.03f);
        }
        for (i = 0; i < 75; ++i) {
            block = context.getCenter().m_7918_(-3 + rand.m_188503_(7), 0, -3 + rand.m_188503_(7));
            pos = new Vec3((double)block.m_123341_() + rand.m_188500_(), (double)block.m_123342_(), (double)block.m_123343_() + rand.m_188500_());
            context.getLevel().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (double)(wind.x() * 0.25f), (double)(wind.y() * 0.25f), (double)(wind.z() * 0.25f));
        }
        if (rand.m_188501_() < 0.1f) {
            BlockPos block2 = context.getCenter().m_7918_(-3 + rand.m_188503_(7), 2, -3 + rand.m_188503_(7));
            Vec3 pos2 = new Vec3((double)block2.m_123341_() + rand.m_188500_(), (double)((float)block2.m_123342_() + rand.m_188501_() * 2.0f), (double)block2.m_123343_() + rand.m_188500_());
            for (int i2 = 0; i2 < 50; ++i2) {
                context.getLevel().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_RANDOM.get())), pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_(), (double)0.05f, (double)0.05f, (double)0.05f);
            }
        }
        this.effectWindDirections.put(context.getCenter(), wind);
        return true;
    }
}

