/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.rituals.IRitualContext;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.blocks.tileentities.ChalkRuneTile;
import com.mna.entities.utility.PresentItem;
import com.mna.items.ItemInit;
import com.mna.rituals.effects.RitualEffectHole;
import com.mna.tools.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class RitualEffectStaircase
extends RitualEffectHole {
    public RitualEffectStaircase(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        int delay = 10;
        BlockPos pos = context.getCenter().m_7495_();
        Direction dir = context.getRecipe().getMatchedDirection(context.getLevel(), context.getCenter());
        if (dir == Direction.SOUTH || dir == Direction.NORTH) {
            dir = dir.m_122424_();
        }
        while (pos.m_123342_() > context.getLevel().m_141937_() && context.getLevel().m_8055_(pos).m_60734_() != Blocks.f_50752_) {
            DelayedEventQueue.pushEvent(context.getLevel(), new TimedDelayedEvent<RitualEffectHole.DelayData>("staircase", delay, new RitualEffectHole.DelayData(context.getCaster(), pos, context.getLevel()), this::breakBlocks));
            delay += 10;
            pos = pos.m_7495_().m_121955_(dir.m_122436_());
        }
        MutableBoolean drop_book = new MutableBoolean(true);
        context.getAllPositions().forEach(c -> {
            ChalkRuneTile crt;
            BlockEntity be;
            if (c.isPresent() && c.getReagent() != null && c.getReagent().getResourceLocation().equals((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)ItemInit.FLAT_LANDS_BOOK.get()))) && (be = context.getLevel().m_7702_(c.getBlockPos())) instanceof ChalkRuneTile && (crt = (ChalkRuneTile)be).isGhostItem()) {
                drop_book.setFalse();
            }
        });
        if (drop_book.booleanValue()) {
            PresentItem epi = new PresentItem(context.getLevel(), context.getCenter().m_123341_(), context.getCenter().m_123342_() + 1, context.getCenter().m_123343_());
            epi.m_32045_(new ItemStack((ItemLike)ItemInit.FLAT_LANDS_BOOK.get()));
            epi.m_20334_(0.0, 0.0, 0.0);
            context.getLevel().m_7967_((Entity)epi);
        }
        return true;
    }

    private void breakBlocks(String identifier, RitualEffectHole.DelayData data) {
        if (data.caster == null || data.world == null || !data.world.m_46749_(data.center)) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos target = data.center.m_7918_(i, j, k);
                    if (!data.world.m_46749_(target) || data.world.m_7702_(target) != null) continue;
                    BlockUtils.destroyBlock((LivingEntity)data.caster, data.world, target, false, (Tier)Tiers.IRON);
                }
            }
        }
    }
}

