/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.config.GeneralConfig;
import com.mna.factions.Factions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ComponentBackdraft
extends SpellEffect {
    public ComponentBackdraft(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.RANGE, 3.0f, 1.0f, 6.0f, 0.5f, 3.5f), new AttributeValuePair(Attribute.DAMAGE, 0.5f, 0.5f, 2.0f, 0.25f, 2.0f));
        this.addReagent(new ItemStack((ItemLike)Items.f_42613_), new IFaction[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (!target.isLivingEntity() || !target.getLivingEntity().m_6060_()) {
            return ComponentApplicationResult.FAIL;
        }
        int fireTicks = target.getLivingEntity().m_20094_();
        int damageSteps = fireTicks / 20;
        target.getLivingEntity().m_6469_(target.getLivingEntity().m_269291_().m_269549_(), (float)damageSteps * modificationData.getValue(Attribute.DAMAGE) * GeneralConfig.getDamageMultiplier());
        target.getLivingEntity().m_20095_();
        int targetFireTicks = fireTicks / 2;
        context.getServerLevel().m_45976_(LivingEntity.class, target.getLivingEntity().m_20191_().m_82400_((double)modificationData.getValue(Attribute.RANGE))).stream().forEach(e -> {
            if (e == source.getCaster() || e == target.getLivingEntity()) {
                return;
            }
            if (e.m_20094_() < targetFireTicks) {
                e.m_7311_(targetFireTicks);
            }
        });
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.FIRE;
    }

    @Override
    public IFaction getFactionRequirement() {
        return Factions.DEMONS;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }
}

