/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.effects.EffectInit;
import com.mna.factions.Factions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;

public class ComponentHemmorhage
extends SpellEffect {
    public ComponentHemmorhage(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.DAMAGE, 5.0f, 5.0f, 20.0f, 5.0f, 3.0f), new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 32.0f, 1.0f, 3.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (target.isLivingEntity()) {
            LivingEntity living = target.getLivingEntity();
            if (living.m_6336_() == MobType.f_21641_) {
                return ComponentApplicationResult.FAIL;
            }
            if (living.m_6084_() && living.m_21023_((MobEffect)EffectInit.CURSE_OF_AGONY.get())) {
                living.m_21195_((MobEffect)EffectInit.CURSE_OF_AGONY.get());
                float damage = modificationData.getValue(Attribute.DAMAGE);
                float radius = modificationData.getValue(Attribute.RADIUS);
                living.m_6469_(living.m_269291_().m_269425_(), damage);
                if (living.m_21224_()) {
                    context.getLevel().m_45933_((Entity)source.getCaster(), living.m_20191_().m_82400_((double)radius)).forEach(e -> {
                        LivingEntity secondaryTarget;
                        if (e instanceof LivingEntity && (secondaryTarget = (LivingEntity)e).m_6336_() != MobType.f_21641_) {
                            secondaryTarget.m_6469_(secondaryTarget.m_269291_().m_269425_(), damage / 2.0f);
                        }
                    });
                }
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.BLOOD;
    }

    @Override
    public float initialComplexity() {
        return 30.0f;
    }

    @Override
    public IFaction getFactionRequirement() {
        return Factions.DEMONS;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.AoE.BLOOD;
    }
}

