/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.effects.EffectInit;
import com.mna.entities.boss.attacks.IllusionCreeper;
import com.mna.factions.Factions;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ComponentIllusoryCreeper
extends SpellEffect {
    public ComponentIllusoryCreeper(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.DURATION, 10.0f, 10.0f, 60.0f, 5.0f, 5.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        Level world = context.getLevel();
        if (!world.f_46443_) {
            if (source.getCaster() == null || context.hasEntityBeenAffected(this, (Entity)source.getCaster())) {
                return ComponentApplicationResult.FAIL;
            }
            context.addAffectedEntity(this, (Entity)source.getCaster());
            IllusionCreeper ic = new IllusionCreeper(world);
            Vec3i normal = target.getBlockFace(this).m_122436_();
            BlockPos spawnPos = BlockPos.m_274446_((Position)target.getPosition().m_82520_((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_()));
            int count = 0;
            while (count < 10 && !world.m_8055_(spawnPos).m_60812_((BlockGetter)world, spawnPos).m_83281_()) {
                ++count;
                spawnPos = spawnPos.m_7494_();
            }
            if (count >= 10) {
                return ComponentApplicationResult.FAIL;
            }
            ic.m_146884_(Vec3.m_82539_((Vec3i)spawnPos));
            ic.getPersistentData().m_128379_("mna:deathflag", true);
            ic.m_7292_(new MobEffectInstance((MobEffect)EffectInit.TIMED_DEATH.get(), (int)modificationData.getValue(Attribute.DURATION) * 20));
            world.m_7967_((Entity)ic);
        }
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public IFaction getFactionRequirement() {
        return Factions.FEY;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public List<Affinity> getValidTinkerAffinities() {
        return Arrays.asList(Affinity.ARCANE, Affinity.ENDER, Affinity.WATER, Affinity.WIND, Affinity.ICE, Affinity.LIGHTNING, Affinity.EARTH);
    }

    @Override
    public boolean isSilverSpell() {
        return true;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.SELF;
    }
}

