/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ComponentPull
extends SpellEffect {
    public static final String FLING_STRENGTH = "mna:flung";
    public static final String FLING_TIME = "mna:fling_time";

    public ComponentPull(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.SPEED, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        float speed = modificationData.getValue(Attribute.SPEED);
        if (target.isLivingEntity()) {
            LivingEntity le = target.getLivingEntity();
            float max_velocity = 2.0f;
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), le, SlotTypePreset.RING)) {
                max_velocity = 3.0f;
            }
            if (source.hasCasterReference() && le == source.getCaster()) {
                if (source.isPlayerCaster()) {
                    return ComponentApplicationResult.FAIL;
                }
                Vec3 motion = source.getCaster().m_20154_().m_82541_().m_82490_(-0.5);
                motion = motion.m_82490_((double)(speed * 2.0f));
                source.getCaster().m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                motion = source.getCaster().m_20184_();
                source.getCaster().m_20334_(Math.min((double)max_velocity, motion.f_82479_), Math.min((double)max_velocity, motion.f_82480_), Math.min((double)max_velocity, motion.f_82481_));
                source.getCaster().f_19864_ = true;
                if (source.isPlayerCaster()) {
                    ((ServerPlayer)source.getPlayer()).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)le));
                }
                this.setFlags(le, speed);
                return ComponentApplicationResult.SUCCESS;
            }
            if (le instanceof Player) {
                Player targetPlayer = (Player)le;
                Vec3 motion = source.hasCasterReference() ? source.getCaster().m_20154_().m_82541_().m_82490_(-0.5) : targetPlayer.m_20154_().m_82541_().m_82490_(0.5);
                motion = motion.m_82490_((double)(speed * 2.0f));
                targetPlayer.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                motion = targetPlayer.m_20184_();
                targetPlayer.m_20334_(Math.min((double)max_velocity, motion.f_82479_), Math.min((double)max_velocity, motion.f_82480_), Math.min((double)max_velocity, motion.f_82481_));
                targetPlayer.f_19864_ = true;
                ((ServerPlayer)targetPlayer).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)targetPlayer));
                if (!CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), (LivingEntity)targetPlayer, SlotTypePreset.RING)) {
                    this.setFlags((LivingEntity)targetPlayer, speed);
                }
                return ComponentApplicationResult.SUCCESS;
            }
            float mX = (float)(target.getLivingEntity().m_20185_() - source.getOrigin().m_7096_());
            float mZ = (float)(target.getLivingEntity().m_20189_() - source.getOrigin().m_7094_());
            le.m_147240_((double)speed, (double)mX, (double)mZ);
            le.m_5997_(0.0, (double)(0.2f * speed), 0.0);
            if (le instanceof PathfinderMob) {
                ((PathfinderMob)le).m_21573_().m_26573_();
            }
            this.setFlags(le, speed);
            return ComponentApplicationResult.SUCCESS;
        }
        if (target.isEntity()) {
            float mX = (float)(source.getOrigin().m_7096_() - target.getEntity().m_20185_());
            float mZ = (float)(source.getOrigin().m_7094_() - target.getEntity().m_20189_());
            target.getEntity().f_19812_ = true;
            Vec3 vector3d = target.getEntity().m_20184_();
            Vec3 vector3d1 = new Vec3((double)mX, 0.0, (double)mZ).m_82541_().m_82490_((double)(-speed));
            target.getEntity().m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, target.getEntity().m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)speed) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    private void setFlags(LivingEntity le, float strength) {
        le.getPersistentData().m_128350_(FLING_STRENGTH, strength);
        le.getPersistentData().m_128356_(FLING_TIME, le.m_9236_().m_46467_());
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.WIND;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WIND;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age > 10 || caster == null) {
            return;
        }
        float particle_spread = 1.0f;
        int particleCount = 10;
        Vec3 velocity = caster.m_20154_();
        for (int i = 0; i < particleCount; ++i) {
            world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)caster), impact_position.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.NEUTRAL;
    }
}

