/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools.proxy;

import com.mna.KeybindInit;
import com.mna.api.blocks.tile.pylon.PylonTileBase;
import com.mna.api.sound.Music;
import com.mna.blocks.tileentities.renderers.PylonRenderer;
import com.mna.entities.constructs.animated.Construct;
import com.mna.gui.HUDOverlayRenderer;
import com.mna.gui.constructs.GuiConstructDiagnostics;
import com.mna.guide.GuideBookEntries;
import com.mna.sound.EntityAliveLoopingSound;
import com.mna.sound.PredicateLoopingSound;
import com.mna.tools.DidYouKnowHelper;
import com.mna.tools.ISidedProxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public class ClientProxy
implements ISidedProxy,
SoundEventListener,
ClientAdvancements.Listener {
    private Minecraft mc = Minecraft.m_91087_();
    private long clientTickCounter;
    private Entity queuedRenderViewEntity;
    private Vec3 lastTickPosition;
    private SoundInstance activeDanceMix;
    private boolean initialized = false;
    private Advancement queryAdvancement = null;
    private AdvancementProgress progress = null;
    private HashMap<Long, Integer> wardRenderers = new HashMap();
    private boolean lockWardRenderers = false;
    private Construct __dummyconstruct;

    @Override
    public Player getClientPlayer() {
        return this.mc.f_91074_;
    }

    @Override
    public Level getClientWorld() {
        return this.mc.f_91073_;
    }

    @Override
    public long getGameTicks() {
        return this.clientTickCounter;
    }

    @Override
    public void incrementTick() {
        if (!this.initialized) {
            this.mc.m_91106_().m_120374_((SoundEventListener)this);
            this.initialized = true;
        }
        ++this.clientTickCounter;
        if (this.queuedRenderViewEntity != null) {
            this.mc.f_91075_ = this.queuedRenderViewEntity;
            this.mc.f_91063_.m_109106_(this.queuedRenderViewEntity);
            this.queuedRenderViewEntity = null;
        }
        this.lastTickPosition = this.mc.f_91074_ != null ? this.mc.f_91074_.m_20182_() : Vec3.f_82478_;
        HashSet toRemove = new HashSet();
        this.wardRenderers.keySet().forEach(l -> {
            int duration = this.wardRenderers.get(l) - 1;
            if (duration <= 0) {
                toRemove.add(l);
            } else {
                this.wardRenderers.put((Long)l, duration);
            }
        });
        this.lockWardRenderers = true;
        toRemove.forEach(l -> this.wardRenderers.remove(l));
        this.lockWardRenderers = false;
    }

    @Override
    public Vec3 getClientLastTickPosition() {
        return this.lastTickPosition;
    }

    @Override
    public void openConstructDiagnostics(Construct target) {
        Minecraft.m_91087_().m_91152_((Screen)new GuiConstructDiagnostics(target));
    }

    @Override
    public boolean isUIModifierKeyDown() {
        return ((KeyMapping)KeybindInit.InventoryItemOpen.get()).m_90857_();
    }

    @Override
    public Construct getDummyConstructForRender() {
        if (this.__dummyconstruct == null && this.getClientWorld() != null) {
            this.__dummyconstruct = new Construct(this.getClientWorld());
        }
        return this.__dummyconstruct;
    }

    @Override
    public void resetRenderViewEntity() {
        this.setRenderViewEntity((Entity)this.mc.f_91074_);
    }

    @Override
    public void setRenderViewEntity(Entity e) {
        this.queuedRenderViewEntity = e;
    }

    @Override
    public boolean isGamePaused() {
        return Minecraft.m_91087_().m_91104_();
    }

    @Override
    public void setFlySpeed(Player player, float speed) {
        player.m_150110_().m_35943_(speed);
    }

    @Override
    public void setFlightEnabled(Player player, boolean enabled) {
        if (player.m_150110_().f_35936_ == enabled) {
            return;
        }
        if (enabled) {
            player.m_150110_().f_35936_ = true;
        } else {
            boolean creative;
            player.m_150110_().f_35936_ = creative = player.m_7500_() || player.m_5833_();
            if (!creative) {
                player.m_150110_().f_35935_ = false;
            } else {
                player.m_150110_().m_35943_(0.05f);
            }
        }
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).m_6885_();
        }
    }

    @Override
    public boolean checkConstructDanceMixPlaying() {
        if (this.activeDanceMix != null) {
            if (!Minecraft.m_91087_().m_91106_().m_120403_(this.activeDanceMix)) {
                this.activeDanceMix = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public void m_6985_(SoundInstance inst, WeighedSoundEvents weight) {
        if (inst.m_7904_().equals((Object)Music.Construct.DANCE_MIX.m_11660_())) {
            this.activeDanceMix = inst;
        }
    }

    @Override
    public Vec3 getCameraPosition() {
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        return camera.m_90583_();
    }

    @Override
    public void playSingleSound(SoundEvent sound) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)((float)(0.8 + Math.random() * 0.4))));
    }

    @Override
    public void playLoopingSound(SoundEvent sound, String identifier, Predicate<String> predicate) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PredicateLoopingSound(sound, "active_loop", predicate));
    }

    @Override
    public void playLoopingSound(SoundEvent sound, String identifier, Predicate<String> predicate, float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PredicateLoopingSound(sound, "active_loop", predicate).setVolume(volume));
    }

    @Override
    public void playLoopingSound(SoundEvent sound, String identifier, Predicate<String> predicate, float volume, BlockPos position) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PredicateLoopingSound(sound, "active_loop", predicate).setVolume(volume).setPosition(position));
    }

    @Override
    public void playEntityAliveLoopingSound(SoundEvent sound, Entity entity) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityAliveLoopingSound(sound, entity));
    }

    @Override
    public void showDidYouKnow(Player player, String msg) {
        DidYouKnowHelper.CheckAndShowDidYouKnow(player, msg);
    }

    @Override
    public boolean playerHasAdvancement(Player player, ResourceLocation advancementID) {
        Minecraft mc = Minecraft.m_91087_();
        ClientAdvancements advancements = mc.f_91074_.f_108617_.m_105145_();
        this.queryAdvancement = advancements.m_104396_().m_139337_(advancementID);
        if (this.queryAdvancement == null) {
            return false;
        }
        this.progress = null;
        advancements.m_104397_((ClientAdvancements.Listener)this);
        if (this.progress != null) {
            advancements.m_104397_(null);
            return this.progress.m_8193_();
        }
        return false;
    }

    @Override
    public void showCodexEntriesUnlocked() {
        HUDOverlayRenderer.instance.showCodexEntriesUnlocked();
    }

    public void m_5513_(Advancement pAdvancement) {
    }

    public void m_5505_(Advancement pAdvancement) {
    }

    public void m_7204_() {
    }

    public void m_5504_(Advancement pAdvancement) {
    }

    public void m_5516_(Advancement pAdvancement) {
    }

    public void m_6896_(Advancement pAdvancement) {
    }

    public void m_7922_(Advancement pAdvancement, AdvancementProgress pProgress) {
        if (this.queryAdvancement == pAdvancement) {
            this.progress = pProgress;
        }
    }

    @Override
    public void registerPylonRendererForType(BlockEntityType<? extends PylonTileBase> pylonTile) {
        BlockEntityRenderers.m_173590_(pylonTile, ctx -> new PylonRenderer(ctx));
    }

    @Override
    public void recalculateCodexUnlocks() {
        GuideBookEntries.INSTANCE.updateUnlockedEntries(null);
    }

    @Override
    public float getPartialTick() {
        return Minecraft.m_91087_().getPartialTick();
    }

    @Override
    public HashMap<Long, Integer> getWardRenderers() {
        return this.wardRenderers;
    }

    @Override
    public void addWardRenderer(long blockPos, int duration) {
        if (this.lockWardRenderers) {
            return;
        }
        this.wardRenderers.put(blockPos, duration);
    }
}

