/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.tinkersjewelry;

import com.mojang.logging.LogUtils;
import dev.ferriarnus.tinkersjewelry.GemAttributes;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterialData;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterialRecipe;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterialRenderInfo;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterialSprite;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterialStatsData;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterialTraitData;
import dev.ferriarnus.tinkersjewelry.data.JewelryMaterials;
import dev.ferriarnus.tinkersjewelry.data.JewelryModifierProvider;
import dev.ferriarnus.tinkersjewelry.data.JewelryModifierRecipe;
import dev.ferriarnus.tinkersjewelry.data.JewelryPartSprite;
import dev.ferriarnus.tinkersjewelry.data.JewelrySmeltryRecipe;
import dev.ferriarnus.tinkersjewelry.data.JewelryStationSlotLayout;
import dev.ferriarnus.tinkersjewelry.data.JewelryToolDefinitionData;
import dev.ferriarnus.tinkersjewelry.data.JewelryToolsRecipe;
import dev.ferriarnus.tinkersjewelry.items.ItemRegistry;
import dev.ferriarnus.tinkersjewelry.tools.hooks.CuriosModifierHooks;
import dev.ferriarnus.tinkersjewelry.tools.modifiers.JewelryModifiers;
import dev.ferriarnus.tinkersjewelry.tools.stats.BlankBandMaterialStats;
import dev.ferriarnus.tinkersjewelry.tools.stats.GemMaterialStats;
import dev.ferriarnus.tinkersjewelry.tools.stats.JewelryToolStats;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.data.sprite.TinkerMaterialSpriteProvider;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="tinkersjewelry")
public class TinkersJewelry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "tinkersjewelry";
    public static final TagKey<Item> JEWELRY = ItemTags.create((ResourceLocation)new ResourceLocation("tinkersjewelry", "modifiable/jewelry"));

    public TinkersJewelry() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(EventPriority.LOWEST, this::gatherData);
        modEventBus.addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.addListener(this::commonSetup);
        JewelryToolStats.register();
        ItemRegistry.registerItems();
        JewelryModifiers.registerModifiers();
        GemAttributes.register();
        ForgeMod.enableMilkFluid();
    }

    public void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
        MaterialRegistry.getInstance().registerStatType(BlankBandMaterialStats.TYPE);
        MaterialRegistry.getInstance().registerStatType(GemMaterialStats.TYPE);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        CuriosModifierHooks.init();
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        generator.addProvider(server, (DataProvider)new JewelryToolsRecipe(generator.getPackOutput()));
        generator.addProvider(server, (DataProvider)new JewelryMaterialRecipe(generator.getPackOutput()));
        generator.addProvider(server, (DataProvider)new JewelrySmeltryRecipe(generator.getPackOutput()));
        JewelryMaterialData newMaterials = new JewelryMaterialData(generator.getPackOutput());
        generator.addProvider(server, (DataProvider)newMaterials);
        generator.addProvider(server, (DataProvider)new JewelryMaterialStatsData(generator.getPackOutput(), newMaterials));
        generator.addProvider(server, (DataProvider)new JewelryMaterialTraitData(generator.getPackOutput(), newMaterials));
        generator.addProvider(server, (DataProvider)new JewelryToolDefinitionData(generator.getPackOutput()));
        generator.addProvider(server, (DataProvider)new JewelryStationSlotLayout(generator.getPackOutput()));
        generator.addProvider(server, (DataProvider)new JewelryModifierProvider(generator.getPackOutput()));
        generator.addProvider(server, (DataProvider)new JewelryModifierRecipe(generator.getPackOutput()));
        TinkerMaterialSpriteProvider materialSprites = new TinkerMaterialSpriteProvider();
        JewelryMaterialSprite newMaterialSprites = new JewelryMaterialSprite();
        JewelryPartSprite partSprites = new JewelryPartSprite();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        GeneratorPartTextureJsonGenerator.StatOverride.Builder builder = new GeneratorPartTextureJsonGenerator.StatOverride.Builder();
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.copper.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.iron.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.gold.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.osmium.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.tungsten.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.platinum.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.silver.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.lead.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.slimesteel.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.amethystBronze.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.nahuatl.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.pigIron.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.roseGold.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.steel.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.bronze.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.constantan.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.invar.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.electrum.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.platedSlimewood.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.manyullyn.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.cinderslime.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.queensSlime.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.cobalt.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)MaterialIds.hepatizon.getId());
        builder.add(BlankBandMaterialStats.ID, (ResourceLocation)JewelryMaterials.hematite);
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.rock.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.flint.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.obsidian.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.necroticBone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.bone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.blazingBone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.venombone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.scorchedStone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.searedStone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.enderPearl.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.whitestone.getId());
        builder.add(GemMaterialStats.ID, (ResourceLocation)MaterialIds.necronium.getId());
        GeneratorPartTextureJsonGenerator.StatOverride overrides = builder.build();
        generator.addProvider(client, (DataProvider)new JewelryMaterialRenderInfo(generator.getPackOutput(), newMaterialSprites, existingFileHelper));
        generator.addProvider(client, (DataProvider)new GeneratorPartTextureJsonGenerator(generator.getPackOutput(), MODID, (AbstractPartSpriteProvider)partSprites, overrides));
        generator.addProvider(client, (DataProvider)new MaterialPartTextureGenerator(generator.getPackOutput(), existingFileHelper, (AbstractPartSpriteProvider)partSprites, overrides, new AbstractMaterialSpriteProvider[]{materialSprites, newMaterialSprites}));
    }
}

