/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.tinkersjewelry.tools.modifiers.gem;

import dev.ferriarnus.tinkersjewelry.TinkersJewelry;
import dev.ferriarnus.tinkersjewelry.tools.stats.JewelryToolStats;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.tools.stats.ToolType;

public class TemperateModifier
extends Modifier
implements ConditionalStatModifierHook,
TooltipModifierHook {
    private static final float MAX_TEMPERATURE = 1.25f;
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_AMPLIFICATION = 0.120000005f;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.TOOLTIP);
    }

    private static float diminishingPercent(float level) {
        if (level < 5.0f) {
            return 0.025f * level * (11.0f - level);
        }
        return 0.75f + (level - 5.0f) * 0.05f;
    }

    private static float getBonus(LivingEntity living, BlockPos pos) {
        return ((Biome)living.m_9236_().m_204166_(pos).m_203334_()).m_47505_(pos) - 0.75f;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == JewelryToolStats.AMPLIFICATION) {
            float bonus = TemperateModifier.getBonus(living, living.m_20183_());
            baseValue += Mth.m_14154_((float)bonus) * 0.120000005f * multiplier * modifier.getEffectiveLevel();
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        ToolType type = ToolType.from((Item)tool.getItem(), (ToolType[])ToolType.NO_MELEE);
        if (type != null) {
            float bonus = entry.getEffectiveLevel();
            bonus = player != null && key == TooltipKey.SHIFT ? (bonus *= TemperateModifier.getBonus((LivingEntity)player, player.m_20183_())) : (bonus *= 1.0f);
            float value = Mth.m_14154_((float)bonus) * ((Float)tool.getStats().get((IToolStat)JewelryToolStats.AMPLIFICATION)).floatValue() * 0.120000005f;
            TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)this, (FloatToolStat)JewelryToolStats.AMPLIFICATION, TinkersJewelry.JEWELRY, (float)value, tooltip);
        }
    }
}

