/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.tinkersjewelry.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.ferriarnus.tinkersjewelry.tools.stats.JewelryToolStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record BlankBandMaterialStats(int durability, float amplification) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(new ResourceLocation("tinkersjewelry", "plain_ring"));
    public static final MaterialStatType<BlankBandMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new BlankBandMaterialStats(100, 1.0f), RecordLoadable.create((RecordField)IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)FloatLoadable.FROM_ZERO.requiredField("amplification", BlankBandMaterialStats::amplification), BlankBandMaterialStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)JewelryToolStats.AMPLIFICATION.getDescription());

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public MaterialStatsId getIdentifier() {
        return ID;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue((float)this.durability));
        info.add(JewelryToolStats.AMPLIFICATION.formatValue(this.amplification));
        return info;
    }

    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder modifierStatsBuilder, float scale) {
        ToolStats.DURABILITY.update(modifierStatsBuilder, Float.valueOf((float)this.durability * scale));
        JewelryToolStats.AMPLIFICATION.update(modifierStatsBuilder, Float.valueOf(this.amplification * scale));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlankBandMaterialStats that = (BlankBandMaterialStats)o;
        return this.durability == that.durability && this.amplification == that.amplification;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.durability, Float.valueOf(this.amplification));
    }
}

