/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import waves.network.WaveCodecs;

public class WaveParticleOption
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<WaveParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<WaveParticleOption>(){

        public WaveParticleOption fromCommand(ParticleType<WaveParticleOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            Vec3 startPos = new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble());
            reader.expect(' ');
            Vec3 shorePos = new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble());
            reader.expect(' ');
            Vec3 direction = new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble());
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float speed = reader.readFloat();
            reader.expect(' ');
            int waveSize = reader.readInt();
            reader.expect(' ');
            int surroundWaterBlocks = reader.readInt();
            return new WaveParticleOption(type, startPos, shorePos, direction, scale, size, speed, waveSize, surroundWaterBlocks);
        }

        public WaveParticleOption fromNetwork(ParticleType<WaveParticleOption> type, FriendlyByteBuf buffer) {
            Vec3 startPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            Vec3 shorePos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            Vec3 direction = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            float scale = buffer.readFloat();
            float size = buffer.readFloat();
            float speed = buffer.readFloat();
            int waveSize = buffer.readInt();
            int surroundWaterBlocks = buffer.readInt();
            return new WaveParticleOption(type, startPos, shorePos, direction, scale, size, speed, waveSize, surroundWaterBlocks);
        }
    };
    private final ParticleType<WaveParticleOption> type;
    private final Vec3 startPos;
    private final Vec3 shorePos;
    private final Vec3 direction;
    private final float scale;
    private final float size;
    private final float speed;
    private final int waveSize;
    private final int surroundWaterBlocks;

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.startPos.f_82479_);
        buffer.writeDouble(this.startPos.f_82480_);
        buffer.writeDouble(this.startPos.f_82481_);
        buffer.writeDouble(this.shorePos.f_82479_);
        buffer.writeDouble(this.shorePos.f_82480_);
        buffer.writeDouble(this.shorePos.f_82481_);
        buffer.writeDouble(this.direction.f_82479_);
        buffer.writeDouble(this.direction.f_82480_);
        buffer.writeDouble(this.direction.f_82481_);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(this.size);
        buffer.writeFloat(this.speed);
        buffer.writeInt(this.waveSize);
        buffer.writeInt(this.surroundWaterBlocks);
    }

    public String m_5942_() {
        return String.format("%s %s %s %s %f %f %f %d %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.type), this.startPos, this.shorePos, this.direction, Float.valueOf(this.scale), Float.valueOf(this.size), Float.valueOf(this.speed), this.waveSize, this.surroundWaterBlocks);
    }

    public static Codec<WaveParticleOption> getCodec(ParticleType<WaveParticleOption> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)WaveCodecs.VEC3.fieldOf("startPos").forGetter(option -> option.startPos), (App)WaveCodecs.VEC3.fieldOf("shorePos").forGetter(option -> option.shorePos), (App)WaveCodecs.VEC3.fieldOf("direction").forGetter(option -> option.direction), (App)Codec.FLOAT.fieldOf("scale").forGetter(option -> Float.valueOf(option.scale)), (App)Codec.FLOAT.fieldOf("size").forGetter(option -> Float.valueOf(option.size)), (App)Codec.FLOAT.fieldOf("speed").forGetter(option -> Float.valueOf(option.speed)), (App)Codec.INT.fieldOf("waveSize").forGetter(option -> option.waveSize), (App)Codec.INT.fieldOf("surroundWaterBlocks").forGetter(option -> option.surroundWaterBlocks)).apply((Applicative)instance, (startPos, shorePos, direction, scale, size, speed, waveSize, surroundWaterBlocks) -> new WaveParticleOption(type, (Vec3)startPos, (Vec3)shorePos, (Vec3)direction, scale.floatValue(), size.floatValue(), speed.floatValue(), (int)waveSize, (int)surroundWaterBlocks)));
    }

    public WaveParticleOption(ParticleType<WaveParticleOption> type, Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks) {
        this.type = type;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.scale = scale;
        this.size = size;
        this.speed = speed;
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public Vec3 getStartPos() {
        return this.startPos;
    }

    public Vec3 getShorePos() {
        return this.shorePos;
    }

    public Vec3 getDirection() {
        return this.direction;
    }

    public float getScale() {
        return this.scale;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getWaveSize() {
        return this.waveSize;
    }

    public int getSurroundWaterBlocks() {
        return this.surroundWaterBlocks;
    }
}

