/*
 * Decompiled with CFR 0.152.
 */
package waves.common.entities;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import waves.common.WavesTags;
import waves.config.Config;
import waves.util.WaveHelpers;

public class Wave
extends Entity {
    public boolean hasInitializedParameters = false;
    public Level level;
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public float scale;
    public float size;
    public float speed;
    public int waveSize;
    public int surroundWaterBlocks;
    public int seaLevel;
    public double initialDistance;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlacedBlock = false;
    public int waveSpriteOld;
    public double angleToShore;
    public float quadSize;
    public boolean onGround;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public int age;
    public double diagonalSize;
    public AABB aabb;

    public Wave(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.level = level;
    }

    public void setParameters(Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks, int seaLevel) {
        this.hasInitializedParameters = true;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.scale = scale;
        this.size = size;
        this.speed = speed;
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.seaLevel = seaLevel;
        this.m_146884_(startPos);
        this.xd = direction.m_7096_() * (double)speed;
        this.zd = direction.m_7094_() * (double)speed;
        this.angleToShore = WaveHelpers.getAngle(direction);
        this.quadSize = size * 0.5f;
        this.setSize(this.quadSize, (double)this.quadSize * 0.075, (double)this.quadSize * 0.2);
        this.m_20331_(true);
        this.f_19794_ = true;
        this.initialDistance = startPos.m_82554_(shorePos);
        this.waveSpriteOld = 0;
        this.age = 0;
        this.diagonalSize = Math.sqrt(Math.pow(this.quadSize, 2.0) + Math.pow(this.quadSize, 2.0)) / 2.0;
        this.aabb = new AABB(-this.diagonalSize, -this.diagonalSize, -this.diagonalSize, this.diagonalSize, this.diagonalSize, this.diagonalSize);
    }

    public void m_8119_() {
        Level level;
        if (!this.hasInitializedParameters) {
            return;
        }
        Vec3 currentPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        if (((Boolean)Config.COMMON.debug.get()).booleanValue() && (level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.level.m_46467_() % 10L == 0L) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, currentPos.m_7096_() + this.f_19796_.m_188583_() * 0.1, currentPos.m_7098_() + 0.25 + this.f_19796_.m_188500_() * 0.1, currentPos.m_7094_() + this.f_19796_.m_188583_() * 0.1, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        double distance = currentPos.m_82554_(this.shorePos);
        FluidState fluidState = WaveHelpers.getFastFluidState(this.level, blockPos.m_7495_());
        boolean hasFluidBelow = fluidState == null ? true : !fluidState.m_76178_();
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        double vecSpeed = new Vec3(this.xd, 0.0, this.zd).m_82553_();
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            if (vecSpeed <= 0.01) {
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.zd = vecInverse.m_7094_() * 0.015;
                this.xd = vecInverse.m_7096_() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.m_82554_(this.shorePos) <= 2.0) {
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).m_82553_() * 0.02);
            this.xd *= speedFactor;
            this.zd *= speedFactor;
        }
        this.m_6478_(MoverType.SELF, new Vec3(this.xd, 0.0, this.zd));
        this.depositBlock(currentPos, this.waveSpriteOld);
        if (this.hasPlacedBlock || this.age > 600 || hasFluidBelow && this.hasTouchedLand) {
            this.m_146870_();
            this.m_6074_();
        }
        if (this.waveSpriteOld <= waveSprite) {
            this.waveSpriteOld = waveSprite;
        }
        ++this.age;
        if (((Boolean)Config.COMMON.waveEntityInteraction.get()).booleanValue() && this.level.m_46467_() % (long)((Integer)Config.COMMON.waveInteractionUpdateFrequency.get()).intValue() == 0L) {
            AABB box = this.aabb.m_82383_(currentPos).m_82400_(2.0);
            List entityList = this.level.m_45976_(Entity.class, box);
            block0: for (Entity entity : entityList) {
                if (entity instanceof Wave) continue;
                boolean isWhitelisted = WaveHelpers.isEntity(entity, WavesTags.Entities.WAVE_INTERACTION_WHITELIST);
                boolean isBlacklisted = WaveHelpers.isEntity(entity, WavesTags.Entities.WAVE_INTERACTION_BLACKLIST);
                if ((!isWhitelisted || isBlacklisted) && (isWhitelisted || isBlacklisted)) continue;
                double sizeNorm = ((double)this.size - 3.0) / 11.0;
                double sizeForceFactor = sizeNorm + 0.5;
                Vec3 sizeFactor = new Vec3(0.125, 0.125, 0.125).m_82490_(sizeNorm * 3.0 + 1.0);
                for (double i = 0.0; i < 7.0; i += 1.0) {
                    ServerLevel server;
                    Level level2;
                    double spacing = (i / 3.0 - 1.0) * (double)this.quadSize * 0.5;
                    Vec3 offsetVec = new Vec3(spacing, 0.0, 0.0).m_82524_((float)(-this.angleToShore + 1.5707963267948966));
                    Vec3 aabbCenter = offsetVec.m_82549_(currentPos);
                    AABB aabb = new AABB(Vec3.f_82478_, sizeFactor).m_82383_(aabbCenter);
                    if (entity.m_20191_().m_82381_(aabb)) {
                        if (this.level.m_46467_() % 1L + (long)this.f_19796_.m_188503_(8) == 0L && (level2 = this.level) instanceof ServerLevel) {
                            server = (ServerLevel)level2;
                            double entityWidth = (double)entity.m_20205_() * 0.5;
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123769_, entity.m_20185_() + this.f_19796_.m_188583_() * entityWidth * 0.8, currentPos.m_7098_() - 0.1 + this.f_19796_.m_188500_() * 0.2, entity.m_20189_() + this.f_19796_.m_188583_() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_() + this.f_19796_.m_188583_() * entityWidth * 0.8, currentPos.m_7098_() - 0.1 + this.f_19796_.m_188500_() * 0.2, entity.m_20189_() + this.f_19796_.m_188583_() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        entity.m_20256_(entity.m_20184_().m_82549_(new Vec3(this.xd * 0.025, (double)this.quadSize * 0.0015, this.zd * 0.025).m_82490_(sizeForceFactor).m_82490_(((Double)Config.COMMON.waveInteractionForceFactor.get()).doubleValue())));
                        continue block0;
                    }
                    if (!((Boolean)Config.COMMON.debug.get()).booleanValue() || !((level2 = this.level) instanceof ServerLevel)) continue;
                    server = (ServerLevel)level2;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, aabbCenter.m_7096_(), aabbCenter.m_7098_(), aabbCenter.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void depositBlock(Vec3 currentPos, int waveSprite) {
        if (!this.hasPlacedBlock && this.hasReachedShore && waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1) {
            this.hasPlacedBlock = true;
            RandomSource random = this.level.m_213780_();
            if (random.m_188503_(((Integer)Config.COMMON.waveBlockDepositChance.get()).intValue()) == 0) {
                BlockPos posDeposit = WaveHelpers.getRandomBlockPosAlongWave(this.level, random, currentPos, this.direction, this.size, this.seaLevel);
                BlockState stateDeposit = WaveHelpers.getFastBlockState(this.level, posDeposit);
                BlockState stateDepositBelow = WaveHelpers.getFastBlockState(this.level, posDeposit.m_7495_());
                Optional<Block> depositBlock = WaveHelpers.randomBlock(WavesTags.Blocks.TIDE_POOL_BLOCKS, random);
                if (!depositBlock.isEmpty()) {
                    BlockState depositState = depositBlock.get().m_49966_();
                    if ((stateDeposit.m_60795_() || stateDeposit.m_247087_()) && stateDepositBelow.m_60819_().m_76178_() && depositState.m_60710_((LevelReader)this.level, posDeposit)) {
                        this.level.m_46597_(posDeposit, depositState);
                    }
                }
            }
        }
    }

    public void setSize(double length, double height, double width) {
        this.bbWidth = (float)width;
        this.bbHeight = (float)height;
        this.m_20011_(new AABB(-length, -width, -height, length, width, height));
    }

    public Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
    }

    public void m_7380_(CompoundTag tag) {
    }

    public void m_7378_(CompoundTag tag) {
    }
}

