/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PlacementLib {
    private static final List<Block> wireWhiteList = new LinkedList<Block>();
    private static final List<Block> gateWhiteList = new LinkedList<Block>();

    public static boolean canPlaceWireOnSide(Level world, BlockPos pos, Direction side) {
        BlockState state = world.m_8055_(pos);
        if (wireWhiteList.contains(state.m_60734_())) {
            return true;
        }
        return state.m_60783_((BlockGetter)world, pos, side);
    }

    public static boolean canPlaceGateOnSide(Level world, BlockPos pos, Direction side) {
        if (PlacementLib.canPlaceWireOnSide(world, pos, side)) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        return gateWhiteList.contains(state.m_60734_());
    }

    public static boolean canPlaceLight(Level world, BlockPos pos, Direction side) {
        if (PlacementLib.canPlaceWireOnSide(world, pos, side)) {
            return true;
        }
        if (side == Direction.UP) {
            return Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)side);
        }
        return false;
    }

    public static void dropTowardsPlayer(Level world, BlockPos pos, ItemStack stack, Player player) {
        if (world.f_46443_ || !world.m_46469_().m_46207_(GameRules.f_46136_)) {
            return;
        }
        Vector3 bpos = Vector3.fromBlockPos((BlockPos)pos);
        Vector3 d = new Vector3(player.m_20182_()).subtract(bpos).normalize();
        Vector3 vel = d.copy().multiply(8.0);
        Vector3 tpos = bpos.add(Vector3.CENTER).add(d.copy().multiply(1.25));
        ItemEntity item = new ItemEntity(world, tpos.x, tpos.y, tpos.z, stack);
        vel.multiply(0.02);
        item.m_20334_(vel.x, vel.y, vel.z);
        item.m_32010_(0);
        world.m_7967_((Entity)item);
    }

    static {
        wireWhiteList.add(Blocks.f_50141_);
        wireWhiteList.add(Blocks.f_50039_);
        wireWhiteList.add(Blocks.f_50032_);
        wireWhiteList.add(Blocks.f_50040_);
        gateWhiteList.add(Blocks.f_50058_);
    }
}

